/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.ArrayList;
import java.util.List;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminStatusUI extends com.jurismarches.vradi.ui.admin.AdminContentUI {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1TPW8TQRBdm9jOJyGJCAGCZMBKgWCdJlUiSAiKiGU+hEGKcMPe3RJvtL5bdueSCwXiJ/AToKdBoqNCFNQUNIi/gBAFLWJ2/XFxOBSEi/Xdzrw3b+bevP5GCkaT8zssSaiOQxBtTmtrW1t3vB3uww1ufC0URJp0frk8yTfJWNC/N0AuNusWXu3Cq+tRW0UhDw+gl+tk1MC+5KbFOQA5N4jwjak2+uHlRMW6x9oXlcX68sf3/Ivg+as8IYlCdcPYSvkoVNrJUJ3kRQBkGivtsqpk4TbK0CLcRr0T9m5dMmNuszZ/Qp6RUp0UFdNIBuTCv7fsOBw+UUAmWNAWYQMYxObBJpAlP2rTnVgL02bab3FDdzULBI0FdZnUj0JAYrp2EKeUYywCmak0XMHNUIBgUjzlehHIghsCUishuaYdTfSPzJRmyIuCfZyEbTqhZg9nQGt3WchlmlOq3Gee5Eg/NzDjTraL2czJPmC4Uqszj8vFw8Tu1iZNAxkBAZLX+WPowcZ9zRnwTq/Y4QD0egwQhQ7brzNRqWFrkZRWMBY7NYBIQ4OoUney9nXKHvMK7XN2oDU0Jk2NmTon1yQFHeM1zqL5p5fvYajj4rlDLraELvprdubzu69vN3rWHcLaJzNTD2weWkrpSHENwpae7Pg2BiGrt5habpIRwyWurVvL+QxhjW4YxWG9KQunFk5vMtNCikLpy/sPs48+HSP5DTIqIxZsMJu/iZ+ppXEKkQwSdW3VKRrfG8bzhNWGBgKe4F5Mr4hQipCXGeAieTHwqwmOYT5jDH0t3sjHnzONN6u9UeRQ2um/pqfjKDwkxU41t8fdFc3c2zFleBxE6SpmLWfO/s+qruEX3Hkps1dhrUOOrwQMWNkTYYBGwz4tgLoG7NOi4ztzJJ+9vmyPK//LAKQo2X4UOysvZbOUkeU30BKKje0FAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminStatusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminStatusUI adminStatusUI = this;
    protected javax.swing.JPanel content;
    protected javax.swing.JButton createStatus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Status> statuses;
    protected List<Status> deleted;
    
    
    void $afterCompleteSetup() {
        createStatuses(false);
    }
    
    public List<Status> getStatuses(){
        return statuses;
    }
    
    public List<Status> getDeleted(){
        return deleted;
    }
    
    public void createStatuses(boolean triggeredByCancelButton) {
        int confirm = JOptionPane.DEFAULT_OPTION;
        if(triggeredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog(this,
                        _("vradi.admin.cancel.message"),
                        _("vradi.admin.cancel.title"),
                        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        if(!triggeredByCancelButton || confirm == JOptionPane.YES_OPTION) {
            content.removeAll();
            jaxx.runtime.JAXXUtil.assignment(statuses = getHandler().getAllStatuses(), "statuses", com.jurismarches.vradi.ui.admin.content.AdminStatusUI.this);
            for (Status status : statuses){
                createStatus(status);
            }
            jaxx.runtime.JAXXUtil.assignment(deleted = new ArrayList<Status>(), "deleted", com.jurismarches.vradi.ui.admin.content.AdminStatusUI.this);
            setModified(false);
        }
    }
    
    protected void createNewStatus() {
        Status status = new StatusImpl();
        status.setValue(content.getComponentCount());
        status.setModifiable(true);
        statuses.add(status);
        createStatus(status);
    }
    
    protected void createStatus(Status status) {
    
        StatusEditionUI editionUI = new StatusEditionUI(this);
    
        status.addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                setModified(true);
            }
        });
    
        editionUI.setBean(status);
    
        content.add(editionUI);
        validate();
    }
    
    public void up(StatusEditionUI editionUI) {
         move(editionUI, -1);
    }
    
    public void down(StatusEditionUI editionUI) {
         move(editionUI, 1);
    }
    
    public void delete(StatusEditionUI editionUI) {
        remove(editionUI);
        deleted.add(editionUI.getBean());
        setModified(true);
    }
    
    public void remove(StatusEditionUI editionUI) {
    
        Status status = editionUI.getBean();
    
        // Remove in list
        statuses.remove(status);
    
        // Remove in UI
        content.remove(editionUI);
    }
    
    protected void move(StatusEditionUI editionUI, int inc) {
        Status status = editionUI.getBean();
    
        // Get index
        int index = statuses.indexOf(status) + inc;
    
        if (index > 0 && statuses.size() > index) {
    
            if (log.isDebugEnabled()) {
                log.debug("Move " + status.getName() + " to " + index);
            }
    
            remove(editionUI);
    
            // Add in list
            statuses.add(index, status);
    
            // Add in UI
            content.add(editionUI, index);
    
            revalidate();
            
            setModified(true);
        }
    }
    
    @Override
    public void save() {
        getHandler().saveStatuses(this);
    }
    
    @Override
    public Object getBean() {
        return null;
    }
    
    @Override
    public void setBean(Object bean) {
    }
    
    @Override
    protected void postLoadBean() {
    }
    
    @Override
    public void cancel() {
        createStatuses(true);
    }
    
    @Override
    protected void clearUI() {
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminStatusUI() {
        super();
        $initialize();
    }

    public AdminStatusUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createStatus(java.awt.event.ActionEvent event) {
        createNewStatus(); setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JButton getCreateStatus() {
        return createStatus;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0, BorderLayout.CENTER);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createCreateStatus() {
        $objectMap.put("createStatus", createStatus = new javax.swing.JButton());
        
        createStatus.setName("createStatus");
        createStatus.setText(_("vradi.adminStatus.createStatus"));
        createStatus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createStatus"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(createStatus, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(content);
        
        // apply 2 property setters
        createStatus.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminStatusUI", this);
        deleted = new ArrayList<Status>();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminStatus.title"));
        createCreateStatus();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createContent();
        // inline creation of adminStatusUI
        setName("adminStatusUI");
        
        $completeSetup();
    }

}