/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public abstract class AdminContentUI<B> extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CREATION = "creation";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLOCK_LAYER_UI_BLOCK = "blockLayerUI.block";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_COMMON_ACTIONS_VISIBLE = "commonActions.visible";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_CREATE_VISIBLE = "create.visible";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_SAVE_VISIBLE = "save.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUy27USBStNN0dEkiAhNcoPAJEAiHkBhYISMTkgSICnRlEAkK0hCjbRbpCucpUlRtnFqP5hPmEmT0bJHasEAvWLNggfgEhFmwRt6rd7Tg4jUX3otq+j3PPPeV7n39CFSXRiXUcx46MuKYBcW7O3b//p7tOPH2dKE/SUAuJ2r+BEio10C6/a1canWrUTXotSa8tiCAUnPBN2dN1NKz0BiOqSYjW6Gg2w1OqttJ1T8dhJDuoXVJ5qP99+Vz61//n/xJCcQjsRqGVyZ9lpZ2U66hEfY3GoFIL1xjma0BDUr4GfEeMbYFhpf7AAXmK/kaDdVQNsQQwjU4Wb9li2Pw41Gjn1M3bmBN2XiPHE4GzHkmqAiy9JlFOS2KfOhF1sB9Q7syZc0FwDcB3l8LQolQBIxA+fUwJUN9nWDqGuTMvBCOYbwrzJMGaCm7eR1N7tYUZ9ckW626XCe9JHW8QeXcJGszIqJ5RU8FEwEMSlOYOEymFXMUuIxrNZDJtLQx6JBgr5rzXMS4TpfAasZnLwicsxRzU0I+LpUaHc6jYDBM51E0ou8LfgMs0isRJWFvrbNwIyB4IPucZaaxxIhvQuaIL5v2YOY53ffvgMvVyIr+N0uhQDr8b8yLOZlY9zD0TPp4hOB9p3b6hNLSscMs2d2YrhLnQjEeiiUx1mCQnnaT0Ux9ooIqMwAxyNn4cvjvgao/d4S1jZwCt99vB8fevPr5c7MzaGNQ+kBu6aVXADIRShERqakrvaQ9apCmrLeNwuoGGFGGwZ+weOZJDbCVxAzmo1/7aTbpzA6smQFQGP7x+c/DRux2otIiGmcD+IjbxS2hINyWoIJgfh7/PWka7n+2Ec6/hBmIyvCFAfDQ6A58innQp9+FGrsUgwpEcEbpM3KG3X8dXXsx2hBgAYr9tG56KUXmAqpQzyoldO8lGyV0zu0JFIl+kmyNvlwyY/+EwmZiL9ryU12nFTrZxX4kj83fVsjZPMxZkfwGQETcZ/gXBhOwTbDBSZMmDxYbGZtqSTGINi9eNNLn2q7DGfLkHsaNFiLWooslm2QZmsgDMeFNI+hf0h9kco2s8gAVugm/lQ04VgCxTr70mtqF1ukh3hJu16fcJU9Yk7tXOzzGM+WEPFmcLIXh9IzR7dFEMYbVvDr10ONe3DsUQeulQDKGXDgbhOyZYGaZoCgAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.BlockingLayerUI blockLayerUI;
    protected javax.swing.JPanel body;
    protected javax.swing.JButton cancel;
    protected jaxx.runtime.swing.Table commonActions;
    protected javax.swing.JButton create;
    protected java.lang.Boolean creation;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorTable;
    protected jaxx.runtime.swing.HBox lastModifiedPanel;
    protected java.lang.Boolean modified;
    protected javax.swing.JButton save;
    protected jaxx.runtime.swing.Table toolbar;
    protected java.lang.Boolean valide;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminContentUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * @return the editing bean of the content
     */
    public abstract B getBean();
    
    /**
     * @param bean selected
     */
    public abstract void setBean(B bean);
    
    /**
     * Call after set bean
     */
    protected abstract void postLoadBean();
    
    /**
     * Save the editing bean
     */
    public abstract void save();
    
    /**
     * Save the editing bean and unmodify the form
     */
    public void postSave() {
        setModified(false);
        save();
    }
    
    public void cancel() {
        getHandler().cancel(this, getHelper().getSelectedNode(), true);
    }
    
    protected AdminNavigationTreeHelper getHelper() {
        return getContextValue(AdminNavigationTreeHelper.class);
    }
    
    public AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected Icon updateCollapseIcon(boolean c) {
        String key = c ? "collapseIcon" : "expandIcon";
        Icon i = (Icon) getClientProperty(key);
        return i;
    }
    
    protected void addBusinessEntityModifiedPCS(BusinessEntity bean) {
        if (bean != null) {
            bean.addPropertyChangeListener(new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (isEnabled()) {
                        setModified(true);
                    }
                }
            });
        }
    }
    
    protected void addBusinessEntityPCSLogger(BusinessEntity bean) {
        if (bean != null) {
            bean.addPropertyChangeListener(new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (log.isDebugEnabled()) {
                        log.debug("bean." + evt.getPropertyName() + " <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                    }
                }
            });
        }
    }
    
    protected void addPCSLogger() {
        addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("ui." + evt.getPropertyName() + " <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
            }
        });
    }
                        
    void $afterCompleteSetup() {
        addPropertyChangeListener("bean", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getBean() != null) {
                    if (getBean() instanceof BusinessEntity) {
                        addBusinessEntityModifiedPCS((BusinessEntity)getBean());
                    } else if (getBean() instanceof WikittyExtension) {
                        ((WikittyExtension)getBean()).addPropertyChangeListener(new PropertyChangeListener() {
    
                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if (isEnabled()) {
                                    setModified(true);
                                }
                            }
                        });
                    }
                    if (getBean() != null && getBean() instanceof BusinessEntity) {
                        BusinessEntity entity = (BusinessEntity)getBean();
                        lastModifiedPanel.removeAll();
    
                        // FIXME EC20100915 pour l'instant le test est fait car
                        // c'est la condition (hack) d'affichage des buttons
                        // sinon le cast rajoute l'extension est la condition est fausse
                        if (!isInCreation()) {
                            ModificationTag beanTag = VradiService.getWikittyProxy().cast(entity, ModificationTag.class);
                            Date lastModified = beanTag.getLastModified();
                            String lastModifier = beanTag.getLastModifier();
    
                            if (lastModified != null && lastModifier != null) {
                                String labelText = String.format(_("vradi.entity.lastModified.date.user"), lastModified, lastModifier);
                                lastModifiedPanel.add(new JLabel(labelText));
                            }
                            lastModifiedPanel.validate();
                        } else {
                            setModified(true);        
                        }
                    }
                } else {
                    clearUI();
                }
                postLoadBean();
            }
        });
        setContextValue(errorTable, "errorTable");
        SwingUtil.getLayer(body).setUI(blockLayerUI);
    }
    
    /**
     * Renvoi vrai si le bean est en phase de creation.
     *
     * @return {@code true} si le bean est en phase de creation
     */
    protected boolean isInCreation() {
        if (getBean() == null) {
            return false;
        }
        BusinessEntity entity = (BusinessEntity)getBean();
        return !entity.getExtensionNames().contains(ModificationTag.EXT_MODIFICATIONTAG);
    }
    
    protected abstract void clearUI();

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminContentUI() {
        $initialize();
    }

    public AdminContentUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        cancel();
    }

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        postSave();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        postSave();
    }

    public void doTableChanged__on__errorTable(javax.swing.event.TableModelEvent event) {
        setValide(errorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.BlockingLayerUI getBlockLayerUI() {
        return blockLayerUI;
    }

    public javax.swing.JPanel getBody() {
        return body;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public jaxx.runtime.swing.Table getCommonActions() {
        return commonActions;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public java.lang.Boolean getCreation() {
        return creation;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorTable() {
        return errorTable;
    }

    public jaxx.runtime.swing.HBox getLastModifiedPanel() {
        return lastModifiedPanel;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public jaxx.runtime.swing.Table getToolbar() {
        return toolbar;
    }

    public java.lang.Boolean getValide() {
        return valide;
    }

    public java.lang.Boolean isCreation() {
        return creation !=null && creation;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCreation(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.creation;
        this.creation = newValue;
        firePropertyChange(PROPERTY_CREATION, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setValide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.valide;
        this.valide = newValue;
        firePropertyChange(PROPERTY_VALIDE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommonActions() {
        if (!allComponentsCreated) {
            return;
        }
        commonActions.add($JPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(lastModifiedPanel, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(cancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(save, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(create, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBlockLayerUI() {
        $objectMap.put("blockLayerUI", blockLayerUI = new jaxx.runtime.swing.BlockingLayerUI());
        
        blockLayerUI.setUseIcon(false);
    }

    protected void createBody() {
        $objectMap.put("body", body = new javax.swing.JPanel());
        
        body.setName("body");
        body.setLayout(new BorderLayout());
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCommonActions() {
        $objectMap.put("commonActions", commonActions = new jaxx.runtime.swing.Table());
        
        commonActions.setName("commonActions");
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreation() {
        $objectMap.put("creation", creation = false);
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        
        errorTable.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorTable"));
    }

    protected void createLastModifiedPanel() {
        $objectMap.put("lastModifiedPanel", lastModifiedPanel = new jaxx.runtime.swing.HBox());
        
        lastModifiedPanel.setName("lastModifiedPanel");
        lastModifiedPanel.setHorizontalAlignment(4);
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        
        toolbar.setName("toolbar");
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.NORTH);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(commonActions, BorderLayout.SOUTH);
        addChildrenToCommonActions();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        blockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        create.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("create"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createModified();
        createCreation();
        createValide();
        createBlockLayerUI();
        createErrorTable();
        createToolbar();
        createBody();
        createCommonActions();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        createLastModifiedPanel();
        createCancel();
        createSave();
        createCreate();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.putClientProperty("expandIcon", SwingUtil.createActionIcon("expand"));
        $JPanel0.putClientProperty("collapseIcon", SwingUtil.createActionIcon("collapse"));
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLOCK_LAYER_UI_BLOCK, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                blockLayerUI.setBlock(!isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMMON_ACTIONS_VISIBLE, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                commonActions.setVisible(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CANCEL_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                cancel.setEnabled(isModified());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_ENABLED, true ,"modified" ,"valide") {
        
            @Override
            public void processDataBinding() {
                save.setEnabled(isModified() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_VISIBLE, true ,"creation") {
        
            @Override
            public void processDataBinding() {
                save.setVisible(!isCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_ENABLED, true ,"modified" ,"valide") {
        
            @Override
            public void processDataBinding() {
                create.setEnabled(isModified() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_VISIBLE, true ,"creation") {
        
            @Override
            public void processDataBinding() {
                create.setVisible(isCreation());
            }
        });
    }

}