/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.solr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrQueryParser;

class SolrQParser
extends QParser {
    private static Log log = LogFactory.getLog(SolrQParser.class);
    String sortStr;
    SolrQueryParser lparser;

    public SolrQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    public Query parse() throws ParseException {
        String defaultField = this.getParam("df");
        if (defaultField == null) {
            defaultField = "text";
        }
        this.lparser = new SolrQueryParser((QParser)this, defaultField);
        this.lparser.setAllowLeadingWildcard(true);
        String opParam = this.getParam("q.op");
        if (opParam != null) {
            this.lparser.setDefaultOperator("AND".equals(opParam) ? QueryParser.Operator.AND : QueryParser.Operator.OR);
        }
        String qstr = this.getString();
        log.debug((Object)("Query parse : " + qstr));
        return this.lparser.parse(qstr);
    }

    public String[] getDefaultHighlightFields() {
        return new String[]{this.lparser.getField()};
    }
}

