/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.ModificationTagImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.offer.RequestFormViewHandler;
import com.jurismarches.vradi.ui.offer.RequestFormViewUI;
import com.jurismarches.vradi.ui.offer.editors.CurrencyEditor;
import com.jurismarches.vradi.ui.offer.editors.DateEditor;
import com.jurismarches.vradi.ui.offer.editors.DateTimeEditor;
import com.jurismarches.vradi.ui.offer.editors.EmailEditor;
import com.jurismarches.vradi.ui.offer.editors.NumEditor;
import com.jurismarches.vradi.ui.offer.editors.StringEditor;
import com.jurismarches.vradi.ui.offer.editors.TextEditor;
import com.jurismarches.vradi.ui.offer.editors.UrlEditor;
import com.jurismarches.vradi.ui.offer.editors.VradiEditor;
import com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusHandler;
import com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FacetTopic;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class OfferEditHandler {
    private static final Log log = LogFactory.getLog(OfferEditHandler.class);
    private static final String DEFAULT_EDITOR_NAME = "$default";
    public static final String REQUIRED_FIELD_CONTEXT = "required";
    private VradiStorageService vradiStorageService = null;
    protected static Map<String, Class<? extends VradiEditor<?, ?>>> editorMapping;

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }

    public OfferEditUI initUI(JAXXContext rootContext, String formId) {
        Form form = (Form)VradiService.getWikittyProxy().restore(Form.class, formId);
        return this.initUI(rootContext, form);
    }

    public OfferEditUI initUI(JAXXContext rootContext, Form data) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load form '" + data.getObjet() + "' with status : " + data.getStatus()));
        }
        context.add((Object)data);
        UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class);
        OfferEditUI ui = new OfferEditUI((JAXXContext)context);
        this.fillfields(ui, data);
        DefaultListModel fileModel = ui.getEmbeddedFileListModel();
        if (data != null && data.getFiles() != null) {
            for (String fileName : data.getFiles()) {
                fileModel.addElement(fileName);
            }
        }
        DefaultListModel attachmentModel = ui.getAttachmentFileListModel();
        if (data != null && data.getAttachments() != null) {
            for (String attachmentName : data.getAttachments()) {
                attachmentModel.addElement(attachmentName);
            }
        }
        try {
            List thesaurusToPropose = this.getVradiStorageService().proposeThesaurus(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Find " + thesaurusToPropose.size() + " thesaurus to propose for form " + data.getObjet()));
            }
            this.addPropositions((JAXXContext)ui, thesaurusToPropose.toArray(new Thesaurus[thesaurusToPropose.size()]));
        }
        catch (VradiException eee) {
            log.error((Object)"Cant get propositions of thesaurus ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        ThesaurusHandler thesaurusHandler = UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class);
        thesaurusHandler.initThesaurus(ui);
        return ui;
    }

    public List<Thesaurus> proposeThesaurus(Form form) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proposeThesaurus(form)");
        }
        if (form == null) {
            return null;
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Form").eq("Infogene.id", form.getId()).criteria();
        List<Thesaurus> nodes = ThesaurusDataHelper.getAllThesaurus();
        Set formNodes = form.getThesaurus();
        for (Thesaurus node : nodes) {
            Set tags;
            if (formNodes != null && formNodes.contains(node.getWikittyId()) || (tags = node.getTags()) == null || tags.isEmpty()) continue;
            Search tagSearch = Search.query((Search.KIND)Search.KIND.OR);
            for (String string : tags) {
                if (string.isEmpty()) continue;
                tagSearch.keyword(string);
            }
            Criteria facetCriteria = tagSearch.criteria(node.getWikittyId());
            criteria.addFacetCriteria(facetCriteria);
        }
        PagedResult forms = VradiService.getWikittyProxy().findAllByCriteria(Form.class, criteria);
        List<Thesaurus> result = new ArrayList<Thesaurus>();
        if (forms != null && forms.getNumFound() > 0) {
            ArrayList<String> thesaurusIds = new ArrayList<String>();
            Map facetsMap = forms.getFacets();
            block2: for (Map.Entry entry : facetsMap.entrySet()) {
                List facetTopics = (List)entry.getValue();
                for (FacetTopic facetTopic : facetTopics) {
                    if (facetTopic.getCount() <= 0) continue;
                    thesaurusIds.add(facetTopic.getTopicName());
                    continue block2;
                }
            }
            if (!thesaurusIds.isEmpty()) {
                result = ThesaurusDataHelper.restoreThesaurus(thesaurusIds);
            }
        }
        return result;
    }

    public void fillfields(OfferEditUI ui, Form form) {
        Collection extensions = form.getExtensionNames();
        for (String extensionName : extensions) {
            if (extensionName.equals("ModificationTag") || extensionName.equals("Infogene") || extensionName.equals("Form")) continue;
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
            WikittyExtension extension = entityWikitty.getWikitty().getExtension(extensionName);
            Collection fieldNames = extension.getFieldNames();
            for (String fieldName : fieldNames) {
                this.createField(ui, extension, fieldName, (BusinessEntity)form);
            }
        }
    }

    protected void createField(OfferEditUI ui, WikittyExtension extension, String fieldName, BusinessEntity data) {
        VradiEditor editor;
        JPanel content = ui.getContent();
        FieldType fieldType = extension.getFieldType(fieldName);
        if (!fieldType.isCollection() && (editor = this.getEditor(fieldType, (JAXXContext)ui)) != null) {
            String extensionName = extension.getName();
            Object value = data.getField(extensionName, fieldName);
            editor.setFieldName(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
            editor.setFieldDescription(fieldDesc);
            editor.setExtensionName(extensionName);
            editor.setExtensionFieldName(fieldName);
            editor.setValue(value);
            if (fieldType.isNotNull()) {
                editor.setValidatorContext(REQUIRED_FIELD_CONTEXT);
            }
            content.add(editor);
            content.setVisible(true);
        }
    }

    public OfferEditUI getUI(JAXXContext context) {
        if (context instanceof OfferEditUI) {
            return (OfferEditUI)context;
        }
        return null;
    }

    protected void addPropositions(JAXXContext context, Thesaurus[] props) {
        OfferEditUI ui = this.getUI(context);
        DefaultListModel propositionListModel = ui.getPropositionListModel();
        propositionListModel.removeAllElements();
        for (Thesaurus p : props) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add proposition element : " + p.getName()));
            }
            propositionListModel.addElement(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(JAXXContext context, Form form) {
        VradiUser vradiUser;
        Component[] components;
        log.info((Object)("Saving Form: " + form.getWikittyId()));
        WikittyProxy proxy = VradiService.getWikittyProxy();
        OfferEditUI offerEditUI = this.getUI(context);
        VradiContext.LISTEN_THESAURUS_MODIF = false;
        try {
            form.clearThesaurus();
            for (Object s : offerEditUI.getPropositionList().getSelectedValues()) {
                Thesaurus selected = (Thesaurus)s;
                form.addThesaurus(selected.getWikittyId());
                selected = ThesaurusDataHelper.restoreThesaurus(selected.getWikittyId());
                selected.addChildren(form.getWikittyId());
                proxy.store((BusinessEntity)selected);
            }
            for (Component c : offerEditUI.getThesaurus().getComponents()) {
                Object[] selected;
                ThesaurusUI thesaurusUI = (ThesaurusUI)((Object)c);
                DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
                for (Object s : selected = model.toArray()) {
                    Thesaurus thesaurus = (Thesaurus)s;
                    form.addThesaurus(thesaurus.getWikittyId());
                    thesaurus = ThesaurusDataHelper.restoreThesaurus(thesaurus.getWikittyId());
                    thesaurus.addChildren(form.getWikittyId());
                    proxy.store((BusinessEntity)thesaurus);
                }
            }
        }
        catch (Exception eee) {
            log.error((Object)"Cant init thesaurus : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        finally {
            VradiContext.LISTEN_THESAURUS_MODIF = true;
        }
        JPanel content = offerEditUI.getContent();
        for (Component c : components = content.getComponents()) {
            VradiEditor editor = (VradiEditor)c;
            this.updateFormField(editor, form);
        }
        this.updateFormField(offerEditUI.getObjetEditor(), form);
        this.updateFormField(offerEditUI.getIdEditor(), form);
        this.updateFormField(offerEditUI.getSourceTextEditor(), form);
        this.updateFormField(offerEditUI.getSourceURLEditor(), form);
        this.updateFormField(offerEditUI.getEntityEditor(), form);
        this.updateFormField(offerEditUI.getCountryEditor(), form);
        this.updateFormField(offerEditUI.getDepartmentEditor(), form);
        this.updateFormField(offerEditUI.getDatePubEditor(), form);
        this.updateFormField(offerEditUI.getDatePeremeptionEditor(), form);
        this.updateFormField(offerEditUI.getDescriptionEditor(), form);
        if (!form.getExtensionNames().contains("ModificationTag")) {
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
            entityWikitty.getWikitty().addExtension(ModificationTagImpl.extensionModificationTag);
        }
        form.setField("ModificationTag", "lastModifier", (Object)((vradiUser = (VradiUser)context.getContextValue(VradiUser.class)) != null ? vradiUser.getLogin() : null));
        form.setField("ModificationTag", "lastModified", (Object)new Date());
        try {
            form = (Form)proxy.store((BusinessEntity)form);
        }
        catch (Exception eee) {
            log.error((Object)("Your form is obselete (" + form.getObjet() + ")"), (Throwable)eee);
            JOptionPane.showMessageDialog(this.getUI(context), I18n._((String)"vradi.error.formWikittyObselete", (Object[])new Object[]{form.getObjet()}), I18n._((String)"vradi.error.formWikittyObselete.title"), 64);
            return;
        }
        try {
            for (File embeddedFile : offerEditUI.getEmbeddedFilesToUpload()) {
                VradiService.getFileService().uploadFormEmbeddedFile(embeddedFile, form.getId());
            }
            for (File attachementFile : offerEditUI.getAttachmentFilesToUpload()) {
                VradiService.getFileService().uploadFormAttachment(attachementFile, form.getId());
            }
        }
        catch (Exception eee) {
            log.error((Object)("Cant upload files for form : " + form.getObjet()), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        OfferListUI offerListUI = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        offerListUI.getSearchHandler().executeQuery((JAXXContext)offerListUI);
    }

    void updateFormField(VradiEditor editor, Form form) {
        String extensionName = editor.getExtensionName();
        String extensionFieldName = editor.getExtensionFieldName();
        Object value = editor.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating: " + extensionName + "." + extensionFieldName + "=" + value));
        }
        form.setField(extensionName, extensionFieldName, value);
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = (VradiMainUIHandler)VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void findQueries(JAXXContext context) {
        OfferEditUI ui = this.getUI(context);
        Form form = ui.getData();
        try {
            Map queries = this.getVradiStorageService().findQueriesReturningForm(form);
            RequestFormViewHandler handler = UIHelper.getHandler(context, RequestFormViewHandler.class);
            RequestFormViewUI requestFormViewUI = handler.initUI(context, queries);
            requestFormViewUI.setVisible(true);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
    }

    public void viewInPDF(JAXXContext context) {
        final OfferEditUI ui = this.getUI(context);
        final Form form = ui.getData();
        VradiTask<String> generatePDF = new VradiTask<String>(context, false){

            @Override
            public String doAction() throws Exception {
                return VradiService.getVradiStorageService().generatePDF(form, true);
            }

            @Override
            public void doWhenDone() throws Exception {
                String fileUri = (String)this.get();
                if (fileUri == null) {
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.offerEdit.cantGeneratePDF"), I18n._((String)"vradi.offerEdit.cantGeneratePDFTitle"), 0);
                    return;
                }
                File file = VradiService.getFileService().downloadPDF(fileUri);
                Desktop.getDesktop().open(file);
            }
        };
        generatePDF.execute();
    }

    public void addEmbeddedFile(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addFile(context)");
        }
        FileFilter imageFileFilter = new FileFilter(){
            private final String[] FILTER_EXTENSIONS = new String[]{"jpg", "jpeg", "png", "gif"};

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String extension : this.FILTER_EXTENSIONS) {
                    if (!file.getName().toLowerCase().endsWith(extension)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Images(.jpg, .jpeg, .png, .gif)";
            }
        };
        File file = FileUtil.getFile((Component)this.getUI(context), (FileFilter[])new FileFilter[]{imageFileFilter});
        if (file != null) {
            this.getUI(context).getEmbeddedFilesToUpload().add(file);
            DefaultListModel model = this.getUI(context).getEmbeddedFileListModel();
            model.addElement(file.getName());
            this.getUI(context).getData().addFiles(file.getName());
        }
    }

    public void removeEmbeddedFile(JAXXContext context) {
        int fileIndex = this.getUI(context).getEmbeddedFileList().getSelectedIndex();
        if (fileIndex >= 0) {
            DefaultListModel model = this.getUI(context).getEmbeddedFileListModel();
            String fileName = (String)model.remove(fileIndex);
            this.getUI(context).getData().removeFiles(fileName);
        }
    }

    public void addAttachmentFile(JAXXContext context) {
        File attachment;
        if (log.isDebugEnabled()) {
            log.debug((Object)"addAttachment(context)");
        }
        if ((attachment = FileUtil.getFile((Component)this.getUI(context), (FileFilter[])new FileFilter[0])) != null) {
            this.getUI(context).getAttachmentFilesToUpload().add(attachment);
            DefaultListModel model = this.getUI(context).getAttachmentFileListModel();
            model.addElement(attachment.getName());
            this.getUI(context).getData().addAttachments(attachment.getName());
        }
    }

    public void removeAttachmentFile(JAXXContext context) {
        int attachmentIndex = this.getUI(context).getAttachmentFileList().getSelectedIndex();
        if (attachmentIndex >= 0) {
            DefaultListModel model = this.getUI(context).getAttachmentFileListModel();
            String attachmentName = (String)model.remove(attachmentIndex);
            this.getUI(context).getData().removeAttachments(attachmentName);
        }
    }

    protected synchronized VradiEditor getEditor(FieldType type, JAXXContext context) {
        String editorName;
        if (editorMapping == null) {
            editorMapping = new TreeMap();
            editorMapping.put(FieldTypeEnum.STRING.name(), StringEditor.class);
            editorMapping.put(FieldTypeEnum.DATE_TIME.name(), DateTimeEditor.class);
            editorMapping.put(FieldTypeEnum.DATE.name(), DateEditor.class);
            editorMapping.put(FieldTypeEnum.EMAIL.name(), EmailEditor.class);
            editorMapping.put(FieldTypeEnum.NUMERIC.name(), NumEditor.class);
            editorMapping.put(FieldTypeEnum.TEXT.name(), TextEditor.class);
            editorMapping.put(FieldTypeEnum.URL.name(), UrlEditor.class);
            editorMapping.put(FieldTypeEnum.CURRENCY.name(), CurrencyEditor.class);
            editorMapping.put(DEFAULT_EDITOR_NAME, StringEditor.class);
        }
        FieldTypeEnum typeEnum = FieldTypeEnum.valueOf((FieldType)type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("typeEnum of type " + type + " = " + typeEnum));
        }
        String string = editorName = typeEnum == null ? DEFAULT_EDITOR_NAME : typeEnum.name();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor name for type [" + type.getType() + "] : " + editorName));
        }
        Class<VradiEditor<?, ?>> editorClass = editorMapping.get(editorName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor class to use : " + editorClass));
        }
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = editorClass.getConstructors()) {
                if (constructor.getParameterTypes() == null || constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(JAXXContext.class)) continue;
                VradiEditor editor = (VradiEditor)constructor.newInstance(context);
                editor.init();
                return editor;
            }
            return null;
        }
        catch (Exception eee) {
            throw new IllegalStateException(eee);
        }
    }

    public void changeStatusAndSave(JAXXContext context, Form form, Status status) {
        try {
            String intialStatus = form.getStatus();
            String updateStatus = status.getWikittyId();
            if (intialStatus == null || !updateStatus.equals(intialStatus)) {
                VradiUser vradiUser;
                if (!form.getExtensionNames().contains("ModificationTag")) {
                    BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
                    entityWikitty.getWikitty().addExtension(ModificationTagImpl.extensionModificationTag);
                }
                String statusModifier = (vradiUser = (VradiUser)context.getContextValue(VradiUser.class)) != null ? vradiUser.getLogin() : null;
                log.info((Object)String.format("Updating: statusModifier=%s on form: %s", statusModifier, form.getWikittyId()));
                log.info((Object)String.format("New Status: %s, Old Status: %s", intialStatus, updateStatus));
                form.setField("ModificationTag", "lastModifier", (Object)statusModifier);
                form.setField("ModificationTag", "lastModifier", (Object)statusModifier);
            }
            form.setStatus(updateStatus);
            this.save(context, form);
        }
        catch (Exception eee) {
            log.error((Object)("Cant change status for form '" + (form == null ? "null" : form.getObjet()) + "' with status '" + (status == null ? "null" : I18n._((String)status.getName())) + "'"), (Throwable)eee);
        }
    }
}

