/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.email.loadors.AbstractEmailNodeLoador;
import com.jurismarches.vradi.ui.email.loadors.EmailFormNodeLoadors;
import com.jurismarches.vradi.ui.email.loadors.EmailGroupNodeLoadors;
import com.jurismarches.vradi.ui.email.loadors.EmailUsersNodeLoadors;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class EmailNavigationTreeHelper
extends NavTreeHelper<VradiTreeNode>
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(EmailNavigationTreeHelper.class);
    protected List<Session> sessions;
    public static String PATH_SEPARATOR = "/";
    protected EmailFilterEnum filter = EmailFilterEnum.FILTER_BY_USER;

    public EmailNavigationTreeHelper(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public WikittyProxy getProxy() {
        return this.getDataProvider().getWikittyProxy();
    }

    protected EmailHandler getHandler(JAXXContext context) {
        return UIHelper.getHandler(context, EmailHandler.class);
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public boolean isByForm() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_FORM);
    }

    public boolean isByUser() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_USER);
    }

    public boolean isByGroup() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_GROUP);
    }

    public Session getSelectedActiveSession() {
        Session session;
        Session activeSession = null;
        VradiTreeNode selectedNode = (VradiTreeNode)this.getSelectedNode();
        if (selectedNode != null && (session = EmailNavigationTreeHelper.getParentSession(selectedNode)) != null && session.getStatus() != VradiConstants.SessionStatus.CANCELED.getValue() && session.getStatus() != VradiConstants.SessionStatus.SENT.getValue()) {
            activeSession = session;
        }
        return activeSession;
    }

    public void updateTree(List<Session> sessions, EmailFilterEnum filter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("update data, nb sessions : " + sessions.size()));
        }
        this.filter = filter;
        this.sessions = sessions;
        VradiTreeNode rootNode = new VradiTreeNode(String.class, "Root node", null, null);
        for (Session session : sessions) {
            rootNode.add(this.createSessionNode(session));
        }
        DefaultTreeModel model = this.createModel(rootNode, new Object[0]);
        rootNode.populateChilds(this.getBridge(), this.getDataProvider());
        ((JTree)this.getUI()).setModel(model);
    }

    public VradiTreeNode createSessionNode(Session session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createSession node " + session.getSessionDate() + " num " + session.getNum()));
        }
        String sessionId = session.getWikittyId();
        AbstractEmailNodeLoador nodeLoador = null;
        if (this.isByForm()) {
            nodeLoador = new EmailFormNodeLoadors();
        } else if (this.isByUser()) {
            nodeLoador = new EmailUsersNodeLoadors();
        } else if (this.isByGroup()) {
            nodeLoador = new EmailGroupNodeLoadors();
        }
        return new VradiTreeNode(Session.class, sessionId, null, nodeLoador);
    }

    public List<Sending> getSendingToDisplay(VradiTreeNode node) {
        HashMap<String, Sending> result = new HashMap<String, Sending>();
        Class type = node.getInternalClass();
        String id = node.getId();
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        if (type.equals(Form.class)) {
            List<Sending> sendings = this.getSendingByForm(session, id);
            this.addSendingToMap(result, sendings);
        } else if (type.equals(Session.class)) {
            Set sendingIdsSet = session.getSending();
            if (sendingIdsSet == null) {
                return new ArrayList<Sending>();
            }
            ArrayList sendingIds = new ArrayList(sendingIdsSet);
            List sendings = this.getProxy().restore(Sending.class, sendingIds);
            this.addSendingToMap(result, sendings);
        } else if (QueryMaker.class.isAssignableFrom(type)) {
            Sending sending = EmailDataHelper.getSending(session, id);
            result.put(sending.getWikittyId(), sending);
        }
        return new ArrayList<Sending>(result.values());
    }

    protected void addSendingToMap(Map<String, Sending> result, List<Sending> sendings) {
        for (Sending sending : sendings) {
            result.put(sending.getWikittyId(), sending);
        }
    }

    protected List<Sending> getSendingByForm(Session session, String formId) {
        Set sendingIdsSet = session.getSending();
        ArrayList<Sending> result = new ArrayList<Sending>();
        if (sendingIdsSet == null) {
            return result;
        }
        List sendings = this.getProxy().restore(Sending.class, new ArrayList(sendingIdsSet));
        for (Sending sending : sendings) {
            Set formIdsSet = sending.getForm();
            if (formIdsSet == null) {
                return result;
            }
            if (!formIdsSet.contains(formId)) continue;
            result.add(sending);
        }
        return result;
    }

    protected List<String> getStringAsList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }

    public static Session getParentSession(VradiTreeNode node) {
        VradiTreeNode sessionNode = EmailNavigationTreeHelper.getParentSessionNode(node);
        if (sessionNode == null) {
            return null;
        }
        return (Session)VradiService.getWikittyProxy().restore(Session.class, sessionNode.getId());
    }

    public static VradiTreeNode getParentSessionNode(VradiTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.getInternalClass().equals(Session.class)) {
            return node;
        }
        VradiTreeNode parent = (VradiTreeNode)node.getParent();
        return EmailNavigationTreeHelper.getParentSessionNode(parent);
    }

    protected void refresh(VradiTreeNode parentNode) {
        if (parentNode == null) {
            return;
        }
        List selectedNodes = this.getSelectedNodes();
        parentNode.removeAllChildren();
        parentNode.populateChilds(this.getBridge(), this.getDataProvider());
        ((NavTreeBridge)this.getBridge()).nodeStructureChanged((TreeNode)((Object)parentNode));
        this.selectNodes(selectedNodes);
    }

    public void putWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"[Email] put wikitty");
        }
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            VradiTreeNode existingNode;
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            VradiTreeNode selectedNode = (VradiTreeNode)this.getSelectedNode();
            if (wikittyExtensions.contains("Session")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[Session] put wikitty");
                }
                if ((existingNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId})) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Session] Modification case :  " + existingNode.getId()));
                    }
                    this.refresh(existingNode);
                    return;
                }
                Session session = (Session)this.getProxy().restore(Session.class, wikittyId);
                if (session == null) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[Session] Creation case :  " + session.getWikittyId()));
                }
                ((VradiTreeNode)this.getRootNode()).add(this.createSessionNode(session));
            }
            if (wikittyExtensions.contains("Sending")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[Sending] put wikitty");
                }
                if ((existingNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId})) != null) {
                    VradiTreeNode toRefresh = EmailNavigationTreeHelper.getParentSessionNode(existingNode);
                    if (toRefresh != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("[Sending] Modification case :  " + toRefresh.getId()));
                        }
                        this.refresh(toRefresh);
                    }
                    return;
                }
                Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Session").contains("Session.sending", wikittyId).criteria();
                Session session = (Session)this.getProxy().findByCriteria(Session.class, criteria);
                if (session == null) {
                    return;
                }
                VradiTreeNode toRefresh = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{session.getWikittyId()});
                if (toRefresh != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] Creation case :  " + toRefresh.getId()));
                    }
                    this.refresh(toRefresh);
                }
            }
            if (selectedNode == null) continue;
            UIHelper.selectNodeLater((NavHelper)this, selectedNode.getId());
        }
    }

    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put extension event : " + event));
        }
    }

    public void removeExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove extension event : " + event));
        }
    }

    public void clearExtension(WikittyServiceEvent event) {
    }

    public static enum EmailFilterEnum {
        FILTER_BY_USER(I18n._((String)"vradi.email.userFilter")),
        FILTER_BY_GROUP(I18n._((String)"vradi.email.groupFilter")),
        FILTER_BY_FORM(I18n._((String)"vradi.email.formFilter"));

        protected int value;
        protected String text;

        private EmailFilterEnum(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

