/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.loadors.RootThesaurusTreeTableNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.ThesaurusTreeTableNodeLoadors;
import com.jurismarches.vradi.ui.admin.models.ThesaurusTreeTableModel;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class ThesaurusTreeTableHelper
extends NavTreeTableHelper<VradiTreeTableNode>
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(ThesaurusTreeTableHelper.class);
    protected RootThesaurus rootThesaurus;

    public ThesaurusTreeTableHelper() {
        this(new VradiDataProvider());
    }

    public ThesaurusTreeTableHelper(RootThesaurus rootThesaurus) {
        this(new VradiDataProvider());
        this.rootThesaurus = rootThesaurus;
    }

    public ThesaurusTreeTableHelper(VradiDataProvider dataProvider) {
        this.init(dataProvider);
    }

    protected void init(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public void tryToSelect(List<Thesaurus> thesaurus) {
        this.tryToSelect((Collection<String>)this.extractIds(thesaurus));
    }

    public void tryToSelect(Collection<String> thesaurusIds) {
        if (thesaurusIds == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Try to select, ids are null");
            }
            return;
        }
        ArrayList<VradiTreeTableNode> nodes = new ArrayList<VradiTreeTableNode>();
        for (String id : thesaurusIds) {
            VradiTreeTableNode rootNode = (VradiTreeTableNode)this.getRootNode();
            VradiTreeTableNode nodeFound = (VradiTreeTableNode)this.findNode((NavNode)rootNode, new String[]{id});
            if (nodeFound == null) continue;
            nodes.add(nodeFound);
        }
        this.selectNodes(nodes);
    }

    public void tryToUnselect(List<Thesaurus> thesaurus) {
        this.tryToUnselect((Collection<String>)this.extractIds(thesaurus));
    }

    public void tryToUnselect(Collection<String> thesaurusIds) {
        if (thesaurusIds == null) {
            return;
        }
        ArrayList<VradiTreeTableNode> nodes = new ArrayList<VradiTreeTableNode>();
        for (String id : thesaurusIds) {
            VradiTreeTableNode nodeFound = (VradiTreeTableNode)this.findNode(this.getRootNode(), new String[]{id});
            if (nodeFound == null) continue;
            nodes.add(nodeFound);
        }
        this.unSelectNodes(nodes);
    }

    protected List<String> extractIds(List<Thesaurus> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Thesaurus bean : beans) {
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public NavTreeTableModel createTreeModel() {
        NavTreeTableModel model = null;
        if (this.rootThesaurus != null) {
            VradiTreeTableNode root = new VradiTreeTableNode(String.class, "Root node", null, null);
            VradiTreeTableNode rootThesaurusNode = new VradiTreeTableNode(RootThesaurus.class, this.rootThesaurus.getWikittyId(), null, new ThesaurusTreeTableNodeLoadors());
            root.add(rootThesaurusNode);
            model = this.createModel(root, new Object[]{new ThesaurusTreeTableModel()});
            rootThesaurusNode.populateChilds(this.getBridge(), this.getDataProvider());
        } else {
            VradiTreeTableNode root = new VradiTreeTableNode(String.class, "Root node", null, new RootThesaurusTreeTableNodeLoadors());
            model = this.createModel(root, new Object[]{new ThesaurusTreeTableModel()});
            root.populateChilds(this.getBridge(), this.getDataProvider());
        }
        return model;
    }

    public static RootThesaurus getRootThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    protected void refresh(VradiTreeTableNode parentNode) {
        if (parentNode == null) {
            return;
        }
        List selectedNodes = this.getSelectedNodes();
        parentNode.removeAllChildren();
        parentNode.populateChilds(this.getBridge(), this.getDataProvider());
        this.selectNodes(selectedNodes);
    }

    public void putWikitty(WikittyServiceEvent event) {
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            if (wikittyExtensions.contains("Thesaurus")) {
                VradiTreeTableNode existingNode = (VradiTreeTableNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
                if (existingNode != null) {
                    VradiTreeTableNode parent = (VradiTreeTableNode)existingNode.getParent();
                    Thesaurus thesaurusConcerned = ThesaurusDataHelper.restoreThesaurus(wikittyId);
                    String newParentId = thesaurusConcerned.getParent();
                    if (parent != null && !parent.getId().equals(newParentId)) {
                        if (log.isDebugEnabled()) {
                            Thesaurus parentFrom = ThesaurusDataHelper.restoreThesaurus(parent.getId());
                            Thesaurus newParent = ThesaurusDataHelper.restoreThesaurus(newParentId);
                            log.debug((Object)("Move case : " + thesaurusConcerned.getName() + " from parent" + parentFrom.getName() + " to parent" + newParent.getName()));
                        }
                        VradiTreeTableNode newParentNode = (VradiTreeTableNode)this.findNode(this.getRootNode(), new String[]{newParentId});
                        VradiTreeTableNode oldParent = (VradiTreeTableNode)existingNode.getParent();
                        this.refresh(oldParent);
                        this.refresh(newParentNode);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Modification case :  " + thesaurusConcerned.getName()));
                        }
                        VradiTreeTableNode parentNode = (VradiTreeTableNode)existingNode.getParent();
                        this.refresh(parentNode);
                    }
                    return;
                }
                Thesaurus thesaurusConcerned = ThesaurusDataHelper.restoreThesaurus(wikittyId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creation case :  " + thesaurusConcerned.getName()));
                }
                VradiTreeTableNode parentNode = (VradiTreeTableNode)this.findNode(this.getRootNode(), new String[]{thesaurusConcerned.getParent()});
                this.refresh(parentNode);
            }
            if (!wikittyExtensions.contains("RootThesaurus")) continue;
            this.refresh((VradiTreeTableNode)this.getRootNode());
        }
    }

    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        for (String wikittyId : event.getIds()) {
            VradiTreeTableNode node = (VradiTreeTableNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
            if (node == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeTableNode parent = (VradiTreeTableNode)node.getParent();
            this.refresh(parent);
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put extension event : " + event));
        }
    }

    public void removeExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove extension event : " + event));
        }
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

