/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiAction;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

@DefaultApplicationContext.AutoLoad
public class VradiConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(VradiConfig.class);
    protected boolean fullscreen;
    private boolean displayMainUI = true;
    private boolean canUseUI = true;
    protected static final String[] DEFAULT_JAXX_PCS = new String[]{"showNumberEditorButton", "autoPopupNumberEditor", "fullScreen", "locale"};

    public VradiConfig() {
        for (Option option : Option.values()) {
            if (option.defaultValue == null) continue;
            this.setDefaultOption(option.key, option.defaultValue);
        }
        for (Enum enum_ : Action.values()) {
            for (String alias : ((Action)enum_).aliases) {
                this.addActionAlias(alias, ((Action)enum_).action);
            }
        }
    }

    public void parse(String[] args) throws ArgumentsParserException {
        super.parse(args);
        String sVersion = VersionUtil.removeSnapshot((String)this.getOption("application.version"));
        Version version = VersionUtil.valueOf((String)sVersion);
        this.setDefaultOption(Option.VRADI_VERSION.key, version.getVersion());
        Version dbVersion = null;
        dbVersion = version.hasClassifier() ? VersionUtil.removeClassifier((Version)version) : VersionUtil.valueOf((String)version.toString());
        this.setDefaultOption(Option.VRADI_DATABASE_VERSION.key, dbVersion.getVersion());
    }

    public String getCopyrightText() {
        return "Version " + this.getVersion() + " JurisMarches @ 2009 - 2010";
    }

    public Version getVersion() {
        Version option = (Version)this.getOption(Version.class, Option.VRADI_VERSION.key);
        return option;
    }

    public Version getDatabaseVersion() {
        Version option = (Version)this.getOption(Version.class, Option.VRADI_DATABASE_VERSION.key);
        return option;
    }

    public String getLastVersion() {
        String lastVersion = this.getOption(Option.VRADI_LAST_VERSION.key);
        return lastVersion;
    }

    public void setLastVersion(String lastVersion) {
        this.setOption(Option.VRADI_LAST_VERSION.key, lastVersion);
    }

    public boolean isFullScreen() {
        Boolean result = this.getOptionAsBoolean(Option.FULL_SCREEN.key);
        return result != null && result != false;
    }

    public boolean isDisplayMainUI() {
        return this.displayMainUI;
    }

    public boolean isCanUseUI() {
        return this.canUseUI;
    }

    public Locale getLocale() {
        Locale result = (Locale)this.getOption(Locale.class, Option.LOCALE.key);
        return result;
    }

    public void setFullscreen(boolean fullscreen) {
        boolean oldValue = this.isFullScreen();
        this.setOption(Option.FULL_SCREEN.key, fullscreen + "");
        this.saveForUser(new String[0]);
        this.firePropertyChange("fullscreen", oldValue, fullscreen);
    }

    public void setDisplayMainUI(boolean b) {
        this.displayMainUI = b;
    }

    public void setCanUseUI(boolean canUseUI) {
        this.canUseUI = canUseUI;
        if (!canUseUI) {
            this.setDisplayMainUI(false);
        }
    }

    public void setLocale(Locale newLocale) {
        this.setOption(Option.LOCALE.key, newLocale.toString());
        this.saveForUser(new String[0]);
        this.firePropertyChange("locale", null, newLocale);
    }

    public String getRemoteEndpoint() {
        String endpoint = this.getOption(Option.REMOTE_ENDPOINT.key);
        return endpoint;
    }

    public String getQueries() {
        String queries = this.getOption(Option.QUERIES.key);
        return queries;
    }

    public void setQueries(String queries) {
        this.setOption(Option.QUERIES.key, queries);
        this.saveForUser(new String[0]);
    }

    public String getCriterias() {
        String criterias = this.getOption(Option.CRITERIAS.key);
        return criterias;
    }

    public void setCriterias(String criterias) {
        this.setOption(Option.CRITERIAS.key, criterias);
        this.saveForUser(new String[0]);
    }

    public String getRootCriterias() {
        String criterias = this.getOption(Option.CRITERIAS.key);
        return criterias;
    }

    public void setRootCriterias(String criterias) {
        this.setOption(Option.CRITERIAS.key, criterias);
        this.saveForUser(new String[0]);
    }

    public String getRootThesaurus() {
        String rootThesaurus = this.getOption(Option.ROOT_THESAURUS.key);
        return rootThesaurus;
    }

    public void setRootThesaurus(String rootThesaurus) {
        this.setOption(Option.ROOT_THESAURUS.key, rootThesaurus);
        this.saveForUser(new String[0]);
    }

    public String getThesaurus() {
        String thesaurus = this.getOption(Option.THESAURUS.key);
        return thesaurus;
    }

    public void setThesaurus(String thesaurus) {
        this.setOption(Option.THESAURUS.key, thesaurus);
        this.saveForUser(new String[0]);
    }

    public String getOfferColumns() {
        String columns = this.getOption(Option.COLUMNS.key);
        return columns;
    }

    public void setOfferColumns(String columns) {
        this.setOption(Option.COLUMNS.key, columns);
        this.saveForUser(new String[0]);
    }

    public String getThesaurusColors() {
        String columns = this.getOption(Option.THESAURUS_COLORS.key);
        return columns;
    }

    public void setThesaurusColors(String levelAndColors) {
        this.setOption(Option.THESAURUS_COLORS.key, levelAndColors);
        this.saveForUser(new String[0]);
    }

    public boolean isOnClickThesaurusExpanded() {
        boolean result = this.getOptionAsBoolean(Option.THESAURUS_EXPANDED.key);
        return result;
    }

    public void setOnClickThesaurusExpanded(boolean state) {
        this.setOption(Option.THESAURUS_EXPANDED.key, String.valueOf(state));
        this.saveForUser(new String[0]);
    }

    public void setRemoteEndPoint(String newEndpoint) {
        this.setOption(Option.REMOTE_ENDPOINT.key, newEndpoint);
    }

    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove = SwingUtil.findJaxxPropertyChangeListener((String[])DEFAULT_JAXX_PCS, (PropertyChangeListener[])this.getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    public static enum Action {
        HELP(I18n._((String)"vradi.action.commandline.help"), VradiAction.class.getName() + "#help", "-h", "--help"),
        HELP_UI(I18n._((String)"vradi.action.commandline.help.ui"), VradiAction.class.getName() + "#helpUI", "--help-ui"),
        NO_MAIN_UI(I18n._((String)"vradi.action.commandline.disable.main.ui"), VradiAction.class.getName() + "#disableMainUI", "-n", "--no-main"),
        CONFIGURE_UI(I18n._((String)"vradi.action.commandline.configure.ui"), VradiAction.class.getName() + "#configure", "--configure");

        public String description;
        public String action;
        public String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }
    }

    @Deprecated
    public static enum Step {
        AfterInit,
        BeforeExit;

    }

    public static enum Option implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"vradi.config.configFileName.description"), "vradi.properties", String.class, true, true),
        VRADI_VERSION("vradi.version", I18n._((String)"vradi.config.version.description"), null, String.class, true, true),
        VRADI_DATABASE_VERSION("vradi.database.version", I18n._((String)"vradi.config.database.version.description"), null, String.class, true, true),
        VRADI_LAST_VERSION("vradi.last.version", I18n._((String)"vradi.config.last.version.description"), null, String.class, true, true),
        FULL_SCREEN("ui.fullscreen", I18n._((String)"vradi.config.ui.fullscreen"), "false", Boolean.class, false, false),
        LOCALE("ui.locale", I18n._((String)"vradi.config.ui.locale"), Locale.FRANCE.toString(), Locale.class, false, false),
        USERNAME("login", I18n._((String)"vradi.config.login"), "", String.class, true, true),
        PASSWORD("password", I18n._((String)"vradi.config.password"), "", String.class, true, true),
        REMOTE_ENDPOINT("vradi.remote.endpoint", I18n._((String)"vradi.config.remote.endpoint.description"), "", String.class, false, false),
        QUERIES("vradi.queries", I18n._((String)"vradi.config.queries.description"), "", String.class, false, false),
        XML_STREAMS("vradi.xmlStreams", I18n._((String)"vradi.config.xmlStreams.description"), "", String.class, false, false),
        CRITERIAS("vradi.xmlStreams", I18n._((String)"vradi.config.criteria.description"), "", String.class, false, false),
        ROOT_CRITERIAS("vradi.root.criteria", I18n._((String)"vradi.config.root.criteria.description"), "", String.class, false, false),
        THESAURUS("vradi.thesaurus", I18n._((String)"vradi.config.thesaurus.description"), "", String.class, false, false),
        ROOT_THESAURUS("vradi.rootThesaurus", I18n._((String)"vradi.config.rootThesaurus.description"), "", String.class, false, false),
        COLUMNS("vradi.columns", I18n._((String)"vradi.config.columns.description"), "", String.class, false, false),
        THESAURUS_COLORS("vradi.thesaurus.color", I18n._((String)"vradi.config.thesaurus.color.description"), "", String.class, false, false),
        STATUS_COLOR("vradi.status.color", I18n._((String)"vradi.config.status.color.description"), "", String.class, false, false),
        THESAURUS_EXPANDED("vradi.thesaurus.expanded", I18n._((String)"vradi.config.thesaurus.expanded.description"), "", Boolean.class, false, false);

        public String key;
        public String description;
        public String defaultValue;
        public Class<?> type;
        public boolean isTransient;
        public boolean isFinal;

        private Option(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isTransient = isTransient;
            this.isFinal = isFinal;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        public void setFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }
    }
}

