package com.jurismarches.vradi.ui.helpers;

import java.util.Comparator;

import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.*;

/**
 * VradiComparators.
 *
 * @author schorlet
 * @version $Revision: 1189 $ $Date: 2010-08-06 16:34:34 +0200 (ven., 06 août 2010) $
 * @since 12 mars 2010 16:56:44
 */
public class VradiComparators {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(VradiComparators.class);

    public static class BusinessEntityComparator<T extends BusinessEntity> implements Comparator<T> {
        final String extension;
        final String field;
        
        public BusinessEntityComparator(String extension, String field) {
            this.extension = extension;
            this.field = field;
        }
        
        @Override
        public int compare(T o1, T o2) {
            if (o1 != null && o2 != null) {

                Object name1 = o1.getField(extension, field);
                Object name2 = o2.getField(extension, field);
                
                if (name1 != null && name2 != null) {
                    String string1 = WikittyUtil.toString(name1);
                    String string2 = WikittyUtil.toString(name2);
                    
                    return string1.compareToIgnoreCase(string2);

                } else if (name1 != null) {
                    return 1;

                } else if (name2 != null) {
                    return -1;
                }

            } else if (o1 != null) {
                return 1;

            } else if (o2 != null) {
                return -1;
            }

            return 0;
        }
    };
    
    public static final Comparator<Form> FORM_COMPARATOR =
        new BusinessEntityComparator<Form>(Form.EXT_INFOGENE, Form.FIELD_INFOGENE_OBJET);

    public static final Comparator<Client> CLIENT_COMPARATOR =
        new BusinessEntityComparator<Client>(Client.EXT_CLIENT, Client.FIELD_CLIENT_NAME);

    public static final Comparator<User> USER_COMPARATOR =
        new BusinessEntityComparator<User>(User.EXT_USER, User.FIELD_USER_NAME);

    public static final Comparator<Group> GROUP_COMPARATOR =
        new BusinessEntityComparator<Group>(Group.EXT_GROUP, Group.FIELD_GROUP_NAME);

    public static final Comparator<Status> STATUSES_COMPARATOR =
        new BusinessEntityComparator<Status>(Status.EXT_STATUS, Status.FIELD_STATUS_VALUE);

    public static final Comparator<XmlStream> XML_STREAM_COMPARATOR =
        new BusinessEntityComparator<XmlStream>(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME);

    public static final Comparator<WikittyExtension> EXTENSION_COMPARATOR = new Comparator<WikittyExtension>() {
        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            if (o1 != null && o2 != null) {

                String name1 = o1.getName();
                String name2 = o2.getName();
                
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);

                } else if (name1 != null) {
                    return 1;

                } else if (name2 != null) {
                    return -1;
                }

            } else if (o1 != null) {
                return 1;

            } else if (o2 != null) {
                return -1;
            }

            return 0;
        }
    };

    /**
     * Compares VradiUserDTO by getClientName() + ":" + getName().
     */
    public static final Comparator<User> USER_CLIENT_NAME_COMPARATOR = new Comparator<User>() {
        @Override
        public int compare(User o1, User o2) {
            if (o1 != null && o2 != null) {


                WikittyProxy proxy = VradiService.getWikittyProxy();
                Client client1 = proxy.restore(Client.class, o1.getClient());
                Client client2 = proxy.restore(Client.class, o2.getClient());

                String name1 = client1.getName() + ":" + o1.getName();
                String name2 = client2.getName() + ":" + o2.getName();
                return name1.compareToIgnoreCase(name2);

            } else if (o1 != null) {
                return 1;

            } else if (o2 != null) {
                return -1;
            }

            return 0;
        }
    };

    /**
     * Compares VradiThesaurusDTO by namePath : parentPath/getOrder() + ":" + getName().
     */
    public static final Comparator<Thesaurus> THESAURUS_NAME_PATH_COMPARATOR = new Comparator<Thesaurus>() {
        @Override
        public int compare(Thesaurus o1, Thesaurus o2) {
            return ThesaurusDataHelper.getNamePath(o1, "/").compareTo(ThesaurusDataHelper.getNamePath(o2, "/"));
        }
    };

    /**
     * Compares VradiThesaurusDTO by getOrder() + ":" + getName().
     */
    public static final Comparator<Thesaurus> THESAURUS_COMPARATOR = new Comparator<Thesaurus>() {
        @Override
        public int compare(Thesaurus o1, Thesaurus o2) {
            int result = 0;

            if (o1 != null && o2 != null) {
                String orderName1 = ThesaurusDataHelper.concateOrderName(o1);
                String orderName2 = ThesaurusDataHelper.concateOrderName(o2);

                return orderName1.compareToIgnoreCase(orderName2);
            }
            return result;
        }
    };

    public static final Comparator<RootThesaurus> ROOT_THESAURUS_COMPARATOR = new Comparator<RootThesaurus>() {
        @Override
        public int compare(RootThesaurus o1, RootThesaurus o2) {
            int result = 0;

            if (o1 != null && o2 != null) {
                result = o1.getName().compareToIgnoreCase(o2.getName());
            }
            return result;
        }
    };
    
}
 