package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusHandler;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusEditUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_MOVED = "moved";
    public static final String PROPERTY_SAVE = "save";
    public static final String PROPERTY_TITLE_THESAURUS = "titleThesaurus";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_PATH_FIELD_TEXT = "pathField.text";
    public static final String BINDING_TAGS_FIELD_TEXT = "tagsField.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWS28cRRAuL17ba4c8bGIlSoIcYgVFiFknRJGQI4gTsorDJkRZI0XZS3p3OrttzUw33TX2+IL4Cdy4wp0LEjdOiANnDlwQfwEhDlwR1b2P2bXH45FmD/voqvrqq+qqb/b7v6BqNFzdZUni6ThCEXLv8daLF591dnkXP+Gmq4VCqWHwmqlApQ1L/vjcIFxrN214fRhefyBDJSMeTURvNmHR4EHATZ9zRLgyHdE1pt4amzcTFesR6phUFuq3//xd+dr/6rsKQKKI3VtUytpJUWkls02oCB9hmTLtsXrAoh7R0CLqEd837dmDgBnzlIX8C/gS5pswp5gmMIR3ipfsMFx8ohDOYJ8bFuvYPPQFfr6NcKcrQ2831sKETHfJ6u1p5gsvFh7zQxF5SqpYGW9nOlApBzqHMNvhLEK4cQwOsRIo+ATARKhhexzhnK3Vs/V796UMCC51OU3RAR/HIpxNnQfNSn0XQumL14L79ve59Lwayr0jh/PrO6wT8A2EC1NXZvYJ03M261lL0dcfN1mHBxSxbDkkQ9fBqXW6iFBzdJv8NR4Ou2l/v+3cxpBLUvtc24ZKjXA9gwd3Nu9pHHZGjtMQtYjGoyF4QIO0OkVrhyfoDNMBIz63MvjUFMP+OOaQcdEaWzygvURYmUp1P0aUUXaeD7LyIOuZcZ53swNvZwSeoiELaaKGBZ8/UvCW5uxQrvUhvQ174B1jvDlp1HBp6ipIH7xUH9IFnmlDVcd0TDPUPiopz8k0EJMLh8TEAjrrf6srv//054+NkYJcotznM10nBJA2W2mpuLZrRSs9kI8YRVB/wtRmG2rG3ZJTx8sZxFpDM5GjfIPts+HeI2b6BFGd/+PnX1Zf/fYGVBqwGEjmN5j136aL62vqggz8RH18zzE6tb9A72ctN4S5Phe9Ps3H8l0RBSLiawxpSTsx8o8SasTljEaM2XRqv/670vrh3qgZM0Tu4rHuaUOqL2FukM0J6lArMwV0SRke+zLVxCyVnLGfi2ooFVvu/WFmtQE7kDQ+cPquz5CtdUTk0yRSpTZk25Vgv31aGJGUymdOSx6VAHEaZM3PSoDs06OpX5LJLNJK5hC5ciKGPfZzWFwtwKLGYpTP7FMsh8q1AkALw7U7yCFUBOcMbdC+I5QKZwlaNQv3nBue1+pC9cWGN2jdy+LME05L9MrVNb75YxCul56dG6U5vFdkB0Q394bfL11HeYSN0p24VZrD7dIc7hRC+CYH4cPSVRRDyOOwWWTBeGT/n+Y142SYk0qxCP8D9IqjW6ANAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.ThesaurusEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Thesaurus bean;
    protected javax.swing.JTextArea commentField;
    protected java.lang.Boolean modified;
    protected java.lang.Boolean moved;
    protected javax.swing.JTextField nameField;
    protected jaxx.runtime.swing.editor.NumberEditor orderEditor;
    protected javax.swing.JLabel pathField;
    protected javax.swing.JButton pathSelect;
    protected java.lang.Boolean save;
    protected javax.swing.JTextField tagsField;
    protected ThesaurusEditUI thesaurusEditUI = this;
    protected java.lang.String titleThesaurus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(Thesaurus thesaurus, String title, final boolean isCreating) {
        setBean(thesaurus);
        setTitleThesaurus(title);
        orderEditor.setBean(getBean());
        orderEditor.init();
        orderEditor.setModel(getBean().getOrder());
        thesaurus.addPropertyChangeListener(new PropertyChangeListener(){
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                setModified(true);
            }
        });
        setVisible(true);
    }
    
    protected AdminThesaurusHandler getHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    }
    
    protected void valid(){
        setSave(true);
        close();
    }
    
    protected void close(){
        setVisible(false);
        dispose();
    }
    
    protected void move(){
        getHandler().moveThesaurus(this, getBean());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusEditUI() {
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        valid();
    }

    public void doActionPerformed__on__pathSelect(java.awt.event.ActionEvent event) {
        move();
    }

    public void doKeyReleased__on__commentField(java.awt.event.KeyEvent event) {
        bean.setComment(commentField.getText());
    }

    public void doKeyReleased__on__nameField(java.awt.event.KeyEvent event) {
        bean.setName(nameField.getText());
    }

    public void doKeyReleased__on__tagsField(java.awt.event.KeyEvent event) {
        ThesaurusDataHelper.setTagsAsString(getBean(), tagsField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Thesaurus getBean() {
        return bean;
    }

    public javax.swing.JTextArea getCommentField() {
        return commentField;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public java.lang.Boolean getMoved() {
        return moved;
    }

    public javax.swing.JTextField getNameField() {
        return nameField;
    }

    public jaxx.runtime.swing.editor.NumberEditor getOrderEditor() {
        return orderEditor;
    }

    public javax.swing.JLabel getPathField() {
        return pathField;
    }

    public javax.swing.JButton getPathSelect() {
        return pathSelect;
    }

    public java.lang.Boolean getSave() {
        return save;
    }

    public javax.swing.JTextField getTagsField() {
        return tagsField;
    }

    public java.lang.String getTitleThesaurus() {
        return titleThesaurus;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isMoved() {
        return moved !=null && moved;
    }

    public java.lang.Boolean isSave() {
        return save !=null && save;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Thesaurus newValue) {
        com.jurismarches.vradi.entities.Thesaurus oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setMoved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.moved;
        this.moved = newValue;
        firePropertyChange(PROPERTY_MOVED, oldValue, newValue);
    }

    public void setSave(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.save;
        this.save = newValue;
        firePropertyChange(PROPERTY_SAVE, oldValue, newValue);
    }

    public void setTitleThesaurus(java.lang.String newValue) {
        java.lang.String oldValue = this.titleThesaurus;
        this.titleThesaurus = newValue;
        firePropertyChange(PROPERTY_TITLE_THESAURUS, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new javax.swing.JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createMoved() {
        $objectMap.put("moved", moved = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new javax.swing.JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createOrderEditor() {
        $objectMap.put("orderEditor", orderEditor = new jaxx.runtime.swing.editor.NumberEditor(this));
        
        orderEditor.setName("orderEditor");
        orderEditor.setProperty("order");
    }

    protected void createPathField() {
        $objectMap.put("pathField", pathField = new javax.swing.JLabel());
        
        pathField.setName("pathField");
    }

    protected void createPathSelect() {
        $objectMap.put("pathSelect", pathSelect = new javax.swing.JButton());
        
        pathSelect.setName("pathSelect");
        pathSelect.setText(_("vradi.adminThesaurus.move"));
        pathSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pathSelect"));
    }

    protected void createSave() {
        $objectMap.put("save", save = false);
    }

    protected void createTagsField() {
        $objectMap.put("tagsField", tagsField = new javax.swing.JTextField());
        
        tagsField.setName("tagsField");
        tagsField.setColumns(15);
        tagsField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__tagsField"));
    }

    protected void createTitleThesaurus() {
        $objectMap.put("titleThesaurus", titleThesaurus = "");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusEditUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(orderEditor, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(nameField, new GridBagConstraints(2, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(pathField, new GridBagConstraints(1, 2, 2, 1, 0.8, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(pathSelect, new GridBagConstraints(3, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(tagsField, new GridBagConstraints(1, 3, 3, 1, 0.8, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(commentField, new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 6, 2, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(2, 6, 2, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        setTitle(_(titleThesaurus));
        orderEditor.setAutoPopup(false);
        orderEditor.setShowPopupButton(false);
        orderEditor.setShowReset(true);
        orderEditor.setUseFloat(false);
        orderEditor.setUseSign(false);
        pathSelect.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("move"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusEditUI", this);
        createBean();
        createSave();
        createTitleThesaurus();
        createModified();
        createMoved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminThesaurus.orderName"));
        createOrderEditor();
        createNameField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminThesaurus.path"));
        createPathField();
        createPathSelect();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminThesaurus.tags"));
        createTagsField();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminThesaurus.comment"));
        createCommentField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.save"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of thesaurusEditUI
        setName("thesaurusEditUI");
        SwingUtil.setComponentHeight(thesaurusEditUI,400);
        thesaurusEditUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        SwingUtil.setComponentWidth(thesaurusEditUI,600);
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"titleThesaurus") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getTitleThesaurus()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(nameField, getBean().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PATH_FIELD_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                pathField.setText(_(ThesaurusDataHelper.getParentPath(getBean(), "/")));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TAGS_FIELD_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText(tagsField, ThesaurusDataHelper.getTagsAsString(getBean()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(commentField, getBean().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isModified());
            }
        });
    }

}