package com.jurismarches.vradi.ui.admin.loadors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;
import jaxx.runtime.swing.nav.NavDataProvider;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class GroupUsersNodeLoadors extends AbstractVradiNodeLoadors<User> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6834221183179682758L;

    /** Logger */
    static private final Log log = LogFactory.getLog(GroupUsersNodeLoadors.class);

    public GroupUsersNodeLoadors() {
        super(User.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        if (parentId == null) {
            return null;
        }

        WikittyProxy proxy = getProxy(dataProvider);
        Group group = proxy.restore(Group.class, parentId);

        List<User> users = null;
        if (CollectionUtils.isNotEmpty(group.getUser())) {
            users = proxy.restore(User.class, new ArrayList<String>(group.getUser()));
            Collections.sort(users, VradiComparators.USER_COMPARATOR);
        }

        // Return users of group
        return extractIds(users);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}