/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.*;

import com.jurismarches.vradi.ui.admin.loadors.FormTypeNodeLoadors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyServiceEvent;

import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class FormTypeNavigationTreeHelper extends AdminNavigationTreeHelper {

    /** Logger. */
    static private final Log log = LogFactory.getLog(FormTypeNavigationTreeHelper.class);

    public FormTypeNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {

        // Create client category node
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.FORM_TYPE.getCategoryName(),
                null,
                new FormTypeNodeLoadors()
        );
    }
    
    /*
     * @see org.nuiton.wikitty.WikittyServiceListener#putWikitty(org.nuiton.wikitty.WikittyServiceEvent)
     */
    @Override
    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service extension put event : " + event);
        }

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        for (String extensionId : event.getIds()) {
            Set<String> wikittyExtensions = idAndExtensions.get(extensionId);

            // SLE : FIXME dont work !!!
//            if (wikittyExtensions.contains(Form.EXT_FORM)) {
//
//                // for putExtension, wikittyExtensions has only one element
//                VradiTreeNode existingNode = findNode(getRootNode(), extensionId);
//                // cas modification
//                if (existingNode != null) {
//                    refreshNode(existingNode, false);
//                }
//
//                // cas creation
//                else {
//                    VradiTreeNode parentNode = findNode(getRootNode(), AdminBeanConstant.FORM_TYPE.getCategoryName());
//                    VradiTreeNode formTypeNode = getChildLoador(FormTypeNodeLoadors.class).createNode(extensionId, getDataProvider());
//
//                    parentNode.add(formTypeNode);
//                    refresh(parentNode);
//                }
//            }
//            else {
//                log.debug("Can't manage event : " + extensionId + " ( " + wikittyExtensions + " )");
//            }
        }
    }

    /*
     * @see org.nuiton.wikitty.WikittyServiceListener#putWikitty(org.nuiton.wikitty.WikittyServiceEvent)
     */
    @Override
    public void putWikitty(WikittyServiceEvent event) {
        
    }
}
