package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.renderers.AdminCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.datatips.DataTipManager;
import org.nuiton.wikitty.BusinessEntity;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminNavUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILTER_TREE_MODEL = "filterTreeModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminNavUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminNavUI adminNavUI = this;
    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected javax.swing.JTextField filterField;
    protected org.nuiton.widget.tree.FilterTreeModel filterTreeModel;
    protected javax.swing.JPanel importExportContent;
    protected javax.swing.JTree nav;
    protected javax.swing.JPanel navPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.text.Document $Document0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // FIXME add doc about this code !!! Useless now, keep it if commenting it created some bug
    //protected boolean contextInitialized = false;
    
    public  AdminNavUI(JAXXContext parentContext, AdminNavigationTreeHelper helper) {
        SwingUtil.initContext(this, parentContext);
        setContextValue(helper);
        // FIXME add doc about this code !!! Useless now, keep it if commenting it created some bug
        //contextInitialized = true;
    $initialize();
    }
    
    public AdminContentUI getCurrentContent() {
        return (AdminContentUI) contentLayout.getVisibleComponent(content);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected AdminNavigationTreeHelper getHelper() {
        return getContextValue(AdminNavigationTreeHelper.class);
    }
    
    protected void $afterCompleteSetup() {
    
         SwingUtil.addExpandOnClickListener(nav);
    
         // extended tooltip for hidden content
         DataTipManager.get().register(nav);
    
         final VradiDataProvider dataProvider = getHelper().getDataProvider();
    
         // Creation of selection listener to open ui when tree selection change
         TreeSelectionListener selectionListener = new TreeSelectionListener() {
             @Override
             public void valueChanged(TreeSelectionEvent event) {
                 TreePath path = event.getPath();
                 VradiTreeNode node = (VradiTreeNode) path.getLastPathComponent();
                 TreePath oldPath = event.getOldLeadSelectionPath();
    
                 if (log.isDebugEnabled()) {
                     log.debug("Select node " + node);
                 }
    
                 // Do nothing for root
                 if (node.isRoot()) {
                     return;
                 }
    
                 // Ask to save if modified
                 AdminContentUI contentUI = getCurrentContent();
                 if(contentUI != null && contentUI.isModified()) {
    
                     // Show popup
                     VradiTreeNode oldNodeParent = (VradiTreeNode)oldPath.getLastPathComponent();
                     boolean canContinue = getHandler().answerToSave(contentUI, oldNodeParent);
                     if (!canContinue) {
    
                         // l'utilisateur ne veut pas partir au final
                         BusinessEntity bean = (BusinessEntity)contentUI.getBean();
                         if (bean != null) {
    
                             // Other than creation
                             if (oldNodeParent.getId() != null) {
    
                                 // Restore bean saved
                                 Object restored = AdminBeanConstant.getConstantByUIClass(contentUI.getClass()).getBean(new VradiDataProvider(), bean.getWikittyId());
    
                                 // Attach to contentUI
                                 contentUI.setBean(null);
                                 contentUI.setBean(restored);
                             }
    
                             contentUI.setModified(false);
    
                             // Select old node
                             getHelper().selectNode(oldNodeParent);
    
                             contentUI.setModified(true);
                         }
                         return;
                     }
                 }
    
                 // Open ui
                 getHandler().openUI(AdminNavUI.this, dataProvider, contentLayout,
                          content, node);
             }
         };
    
         // Register decorator
         DecoratorProvider decoratorProvider = VradiContext.get().getDecoratorProvider();
    
         // Attach renderer
         nav.setCellRenderer(new AdminCellRenderer(decoratorProvider, dataProvider));
    
         // Register tree
         getHelper().setUI(nav, true, selectionListener);
    
         // Single selection mode
         nav.getSelectionModel().setSelectionMode
                (TreeSelectionModel.SINGLE_TREE_SELECTION);
    }
    
    public void open() {
        SwingUtilities.invokeLater(new Runnable() {
    
            @Override
            public void run() {
                // bug suis les UI autre que nimbus
                // la selection des onglet ne se rafraichit pas tres bien
                repaint();
            }
        });
    }
    
    /**
     * Update tree filter on filter model and expand all tree.
     */
    protected void updateFilter() {
        String filterString = filterField.getText();
        AdminNavTreeFilter treeFilter = new AdminNavTreeFilter(filterString);
        filterTreeModel.setFilter(treeFilter);
    
        // si le filtre n'est pas vide, on etend completement l'arbre
        if (StringUtils.isNotEmpty(filterString)) {
    
            // expand the tree
            SwingUtil.expandTree(nav);
            //expandAll(nav, new TreePath(nav.getModel().getRoot()));
        }
    }
    
    /*
     * Expand all node in tree.
     *
    protected void expandAll(JTree tree, TreePath parent) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                expandAll(tree, path);
            }
        }
        // Expansion or collapse must be done bottom-up
        tree.expandPath(parent);
    }*/
    
    /**
     * Reset filter (clear filter text).
     */
    public void resetFilter() {
        getFilterField().setText("");
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminNavUI() {
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        updateFilter();
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        updateFilter();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JTextField getFilterField() {
        return filterField;
    }

    public org.nuiton.widget.tree.FilterTreeModel getFilterTreeModel() {
        return filterTreeModel;
    }

    public javax.swing.JPanel getImportExportContent() {
        return importExportContent;
    }

    public javax.swing.JTree getNav() {
        return nav;
    }

    public javax.swing.JPanel getNavPanel() {
        return navPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void setFilterTreeModel(org.nuiton.widget.tree.FilterTreeModel newValue) {
        org.nuiton.widget.tree.FilterTreeModel oldValue = this.filterTreeModel;
        this.filterTreeModel = newValue;
        firePropertyChange(PROPERTY_FILTER_TREE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminNavUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(navPanel, JSplitPane.LEFT);
        add(content, JSplitPane.RIGHT);
    }

    protected void addChildrenToNavPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navPanel.add(filterField, BorderLayout.NORTH);
        navPanel.add($JScrollPane0, BorderLayout.CENTER);
        navPanel.add(importExportContent, BorderLayout.SOUTH);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createFilterField() {
        $objectMap.put("filterField", filterField = new javax.swing.JTextField());
        
        filterField.setName("filterField");
        filterField.setColumns(15);
    }

    protected void createFilterTreeModel() {
        $objectMap.put("filterTreeModel", filterTreeModel = new org.nuiton.widget.tree.FilterTreeModel(getHelper().createTreeModel()));
    }

    protected void createImportExportContent() {
        $objectMap.put("importExportContent", importExportContent = new javax.swing.JPanel());
        
        importExportContent.setName("importExportContent");
        importExportContent.setLayout(new GridLayout(1,2));
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new javax.swing.JTree());
        
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(false);
    }

    protected void createNavPanel() {
        $objectMap.put("navPanel", navPanel = new javax.swing.JPanel());
        
        navPanel.setName("navPanel");
        navPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminNavUI();
        addChildrenToNavPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        
        // apply 7 property setters
        setDividerLocation(200);
        setResizeWeight(0.1);
        $JScrollPane0.setColumnHeaderView(filterField);
        nav.setModel(filterTreeModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminNavUI", this);
        createContentLayout();
        createNavPanel();
        createFilterField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getFilterField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFilterTreeModel();
        createNav();
        createImportExportContent();
        createContent();
        // inline creation of adminNavUI
        setName("adminNavUI");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        setDividerSize(12);
        
        $completeSetup();
    }

}