/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.thesaurus.helpers;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.RootThesaurusNodeLoadors;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.ThesaurusNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class ThesaurusTreeHelper
extends NavTreeHelper<VradiTreeNode>
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    protected RootThesaurus rootThesaurus;
    protected Thesaurus thesaurus;
    protected boolean listening = true;

    public ThesaurusTreeHelper(VradiDataProvider dataProvider) {
        this.init(dataProvider);
    }

    public ThesaurusTreeHelper(VradiDataProvider dataProvider, RootThesaurus rootThesaurus) {
        this.rootThesaurus = rootThesaurus;
        this.init(dataProvider);
    }

    public ThesaurusTreeHelper(VradiDataProvider dataProvider, Thesaurus thesaurus) {
        this.thesaurus = thesaurus;
        this.init(dataProvider);
    }

    protected void init(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public TreeModel createTreeModel() {
        VradiTreeNode root;
        if (this.thesaurus != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Root creation] thesaurus " + this.thesaurus.getName()));
            }
            root = new VradiTreeNode(Thesaurus.class, this.thesaurus.getWikittyId(), null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class));
        } else if (this.rootThesaurus != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Root creation] root thesaurus " + this.rootThesaurus.getName()));
            }
            root = new VradiTreeNode(RootThesaurus.class, this.rootThesaurus.getWikittyId(), null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"[Root creation] all root thesaurus");
            }
            root = new VradiTreeNode(String.class, "Root node", null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(RootThesaurusNodeLoadors.class));
        }
        DefaultTreeModel model = this.createModel(root, new Object[0]);
        root.populateChilds(this.getBridge(), this.getDataProvider());
        return model;
    }

    public void tryToSelect(List<Thesaurus> thesaurus) {
        this.tryToSelect((Collection<String>)this.extractIds(thesaurus));
    }

    public void tryToSelect(Collection<String> thesaurusIds) {
        if (thesaurusIds == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Try to select, ids are null");
            }
            return;
        }
        ArrayList<VradiTreeNode> nodes = new ArrayList<VradiTreeNode>();
        for (String id : thesaurusIds) {
            if (id.equals(((VradiTreeNode)this.getRootNode()).getId())) continue;
            VradiTreeNode rootNode = (VradiTreeNode)this.getRootNode();
            VradiTreeNode nodeFound = (VradiTreeNode)this.findNode((NavNode)rootNode, new String[]{id});
            if (nodeFound == null) continue;
            nodes.add(nodeFound);
        }
        this.selectNodes(nodes);
    }

    public void tryToUnselect(List<Thesaurus> thesaurus) {
        this.tryToUnselect((Collection<String>)this.extractIds(thesaurus));
    }

    public void tryToUnselect(Collection<String> thesaurusIds) {
        if (thesaurusIds == null) {
            return;
        }
        ArrayList<VradiTreeNode> nodes = new ArrayList<VradiTreeNode>();
        for (String id : thesaurusIds) {
            VradiTreeNode nodeFound = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{id});
            if (nodeFound == null) continue;
            nodes.add(nodeFound);
        }
        this.unSelectNodes(nodes);
    }

    protected List<String> extractIds(List<Thesaurus> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Thesaurus bean : beans) {
                if (bean == null) continue;
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public static RootThesaurus getRootThesaurus(VradiTreeNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    public static RootThesaurus getRootThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    protected int getIndexOfThesaurusSorted(String wikittyId) {
        Thesaurus concerned = ThesaurusDataHelper.restoreThesaurus(wikittyId);
        List<Thesaurus> thesauruses = ThesaurusDataHelper.getChildrenOfThesaurus(wikittyId);
        Collections.sort(thesauruses, VradiComparators.THESAURUS_COMPARATOR);
        return thesauruses.indexOf(concerned);
    }

    protected int getIndexOfRootThesaurusSorted(String wikittyId) {
        RootThesaurus concerned = ThesaurusDataHelper.restoreRootThesaurus(wikittyId);
        List<RootThesaurus> rootThesauruses = ThesaurusDataHelper.getAllRootThesaurus();
        Collections.sort(rootThesauruses, VradiComparators.ROOT_THESAURUS_COMPARATOR);
        return rootThesauruses.indexOf(concerned);
    }

    protected void refresh(VradiTreeNode parentNode) {
        if (parentNode == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            if (parentNode.getInternalClass().equals(Thesaurus.class)) {
                log.debug((Object)("Refresh thesaurus " + ThesaurusTreeHelper.getThesaurus(parentNode).getName()));
            } else if (parentNode.getInternalClass().equals(RootThesaurus.class)) {
                log.debug((Object)("Refresh rootThesaurus " + ThesaurusTreeHelper.getRootThesaurus(parentNode).getName()));
            } else {
                log.debug((Object)"Refresh root node");
            }
        }
        List selectedNodes = this.getSelectedNodes();
        parentNode.removeAllChildren();
        parentNode.populateChilds(this.getBridge(), this.getDataProvider());
        ((NavTreeBridge)this.getBridge()).nodeStructureChanged((TreeNode)((Object)parentNode));
        this.selectNodes(selectedNodes);
    }

    public void putWikitty(WikittyServiceEvent event) {
        if (!VradiContext.LISTEN_THESAURUS_MODIF) {
            return;
        }
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            if (wikittyExtensions.contains("Thesaurus")) {
                VradiTreeNode existingNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
                if (existingNode != null) {
                    VradiTreeNode parent = (VradiTreeNode)existingNode.getParent();
                    Thesaurus thesaurusConcerned = ThesaurusDataHelper.restoreThesaurus(wikittyId);
                    String newParentId = thesaurusConcerned.getParent();
                    if (parent != null && !parent.getId().equals(newParentId)) {
                        if (log.isDebugEnabled()) {
                            Thesaurus parentFrom = ThesaurusDataHelper.restoreThesaurus(parent.getId());
                            Thesaurus newParent = ThesaurusDataHelper.restoreThesaurus(newParentId);
                            log.debug((Object)("Move case : " + thesaurusConcerned.getName() + " from parent" + parentFrom.getName() + " to parent" + newParent.getName()));
                        }
                        VradiTreeNode oldParent = (VradiTreeNode)existingNode.getParent();
                        this.refresh(oldParent);
                        VradiTreeNode newParentNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{newParentId});
                        this.refresh(newParentNode);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Modification case :  " + thesaurusConcerned.getName()));
                        }
                        VradiTreeNode parentNode = (VradiTreeNode)existingNode.getParent();
                        this.refresh(parentNode);
                    }
                    return;
                }
                Thesaurus thesaurusConcerned = ThesaurusDataHelper.restoreThesaurus(wikittyId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creation case :  " + thesaurusConcerned.getName()));
                }
                VradiTreeNode parentNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{thesaurusConcerned.getParent()});
                this.refresh(parentNode);
            }
            if (!wikittyExtensions.contains("RootThesaurus")) continue;
            this.refresh((VradiTreeNode)this.getRootNode());
        }
    }

    public void removeWikitty(WikittyServiceEvent event) {
        if (!VradiContext.LISTEN_THESAURUS_MODIF) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        for (String wikittyId : event.getIds()) {
            VradiTreeNode node = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
            if (node == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeNode parent = (VradiTreeNode)node.getParent();
            this.refresh(parent);
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put extension event : " + event));
        }
    }

    public void removeExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove extension event : " + event));
        }
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

