/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.email.EmailContentUI;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.email.SessionViewUI;
import com.jurismarches.vradi.ui.email.SessionsListUI;
import com.jurismarches.vradi.ui.email.helpers.EmailBeanConstant;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.task.AbstractProgressBarUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.sun.star.lang.IllegalArgumentException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class EmailHandler {
    private static final Log log = LogFactory.getLog(EmailHandler.class);

    public EmailPopupUI init(JAXXContext rootContext) {
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            ui = new EmailPopupUI((JAXXContext)context);
            VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        return ui;
    }

    public EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI)context;
        }
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public SessionsListUI getSessionsListUI(JAXXContext context) {
        if (context instanceof SessionsListUI) {
            return (SessionsListUI)context;
        }
        return (SessionsListUI)context.getContextValue(SessionsListUI.class);
    }

    public VradiStorageService getStorageService() {
        return VradiService.getVradiStorageService();
    }

    public WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    protected void close(JAXXContext context) {
        EmailPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    public List<Session> getSessions(Date date) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessions for date : " + date));
        }
        List sessions = null;
        try {
            sessions = this.getStorageService().getSessions(date);
        }
        catch (VradiException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        return sessions;
    }

    public void createNewSession(EmailPopupUI ui) {
        try {
            Session session = this.getStorageService().createNewSession();
            ui.updateTree();
        }
        catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create new session", (Throwable)ex);
            }
            JOptionPane.showMessageDialog(ui, I18n._((String)"Can't create new session for reason : %s", (Object[])new Object[]{ex.getMessage()}), I18n._((String)"Can't create new session"), 0);
        }
    }

    public void bindEmailsWithForms(final EmailPopupUI ui) {
        VradiTask<Void> task = new VradiTask<Void>((JAXXContext)ui){

            @Override
            public Void doAction() throws Exception {
                try {
                    Session selectedSession = ui.getHelper().getSelectedActiveSession();
                    if (selectedSession == null) {
                        throw new IllegalArgumentException("No active session selected");
                    }
                    Session currentSession = EmailHandler.this.getStorageService().bindForms(selectedSession);
                    VradiService.getWikittyProxy().store((BusinessEntity)currentSession);
                }
                catch (WikittyException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"An exception occured while binding form", (Throwable)eee);
                    }
                    JOptionPane.showMessageDialog(ui, I18n._((String)"binding.forms.concurrence.message"));
                }
                return null;
            }

            @Override
            public void doWhenDone() throws Exception {
                ui.updateTree();
            }
        };
        task.execute();
    }

    protected List<Form> getSendingForms(Sending sending) {
        Set<String> formIds = sending.getForm();
        if (formIds == null) {
            return null;
        }
        List forms = this.getProxy().restore(Form.class, new ArrayList<String>(formIds));
        if (log.isDebugEnabled()) {
            log.debug((Object)("display " + forms.size() + " forms"));
        }
        return forms;
    }

    protected void openUI(JAXXContext context, VradiDataProvider dataProvider, CardLayout2 contentLayout, JPanel content, VradiTreeNode node) {
        Class editType = node.getInternalClass();
        Class<? extends EmailContentUI> uiClass = EmailBeanConstant.getUIClass(editType);
        EmailContentUI ui = UIHelper.getContentIfExist(contentLayout, content, uiClass);
        String contentName = editType.getName();
        if (ui == null) {
            try {
                Constructor<? extends EmailContentUI> constructor = uiClass.getConstructor(JAXXContext.class);
                ui = constructor.newInstance(context);
            }
            catch (Exception eee) {
                log.error((Object)eee);
                ErrorDialogUI.showError((Exception)eee);
            }
            content.add((Component)ui, contentName);
        }
        ui.openUI(node);
        contentLayout.show((Container)content, contentName);
    }

    public void displaySessions(JAXXContext context, EmailNavigationTreeHelper helper, VradiTreeNode node) {
        SessionsListUI ui = this.getSessionsListUI(context);
        List<Sending> sendings = helper.getSendingToDisplay(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)(sendings.size() + " sendings to display"));
        }
        ui.getSessionContent().removeAll();
        for (Sending sending : sendings) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending displayed : " + sending));
            }
            List<Form> forms = this.getSendingForms(sending);
            OfferListTableModel offerListTableModel = new OfferListTableModel(true);
            OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
            JAXXInitialContext initContext = new JAXXInitialContext().add((Object)context).add((Object)this).add((Object)sending).add((Object)offerListTableModel).add((Object)offerListColumnFactory);
            SessionViewUI viewUI = new SessionViewUI((JAXXContext)initContext);
            ui.getSessionContent().add(viewUI);
            OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
            OfferTable listTable = viewUI.getListTable();
            OfferListTableModel listTableModel = (OfferListTableModel)listTable.getModel();
            FormPagedResult formPageDTO = new FormPagedResult();
            formPageDTO.setFormsToShow(forms);
            listTableModel.setFormPagedResult(formPageDTO);
            listTable.setModel(listTableModel);
            listTable.setDefaultRenderer(Boolean.class, renderer);
            listTable.setDefaultRenderer(Date.class, renderer);
            listTable.setDefaultRenderer(Double.class, renderer);
            listTable.setDefaultRenderer(String.class, renderer);
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
            listTable.addHighlighter(highlighter);
        }
    }

    public void displayForm(JAXXContext context, EmailNavigationTreeHelper helper, VradiTreeNode node) {
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        context.setContextValue((Object)session);
        String id = node.getId();
        Form form = (Form)this.getProxy().restore(Form.class, id);
        context.setContextValue((Object)form);
    }

    public <E extends QueryMaker> void addQueryMaker(JPanel ui, Session session, List<Form> forms, E selected) {
        for (Form form : forms) {
            this.addQueryMaker(ui, session, form, selected);
        }
    }

    public <E extends QueryMaker> void addQueryMaker(JPanel ui, Session session, Form form, E selected) {
        block3: {
            int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmAdd", (Object[])new Object[]{form.getObjet()}), I18n._((String)"vradi.email.confirmAddTitle"), 0);
            if (yes == 0) {
                ArrayList<Form> formsToBind = new ArrayList<Form>();
                formsToBind.add(form);
                QueryMaker bean = this.getRealQueryMaker(selected);
                try {
                    List sending = this.getStorageService().createSending(session, bean, formsToBind);
                    VradiService.getWikittyProxy().store(sending);
                }
                catch (VradiException eee) {
                    ErrorDialogUI.showError((Exception)((Object)eee));
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Cant add sending : " + (Object)((Object)eee)));
                }
            }
        }
    }

    public <E extends QueryMaker> void removeQueryMaker(JPanel ui, Session session, List<Form> forms, Class<E> clazz, Object[] selecteds) {
        for (Form form : forms) {
            this.removeQueryMaker(ui, session, form, clazz, selecteds);
        }
    }

    public <E extends QueryMaker> void removeQueryMaker(JPanel ui, Session session, Form form, Class<E> clazz, Object[] selecteds) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmDelete", (Object[])new Object[]{form.getObjet()}), I18n._((String)"vradi.email.confirmDeleteTitle"), 0);
        if (yes == 0) {
            for (Object selected : selecteds) {
                try {
                    List sending = this.getStorageService().removeAllSending(session, form, this.getRealQueryMaker((QueryMaker)selected));
                    VradiService.getWikittyProxy().store(sending);
                }
                catch (VradiException eee) {
                    ErrorDialogUI.showError((Exception)((Object)eee));
                    log.error((Object)("Cant add sending : " + (Object)((Object)eee)));
                }
            }
        }
    }

    protected void reloadTree(EmailPopupUI ui) {
        EmailNavigationTreeHelper helper = ui.getHelper();
        TreePath[] selectionPaths = helper.getSelectionModel().getSelectionPaths();
        ui.updateTree();
        if (selectionPaths != null) {
            helper.getSelectionModel().setSelectionPaths(selectionPaths);
        }
    }

    protected <E extends QueryMaker> QueryMaker getRealQueryMaker(E toConvert) {
        String wikittyId = toConvert.getWikittyId();
        return (QueryMaker)this.getProxy().restore(toConvert.getClass(), wikittyId);
    }

    public void sendSending(SessionViewUI ui, final Sending sending) {
        Object[] options = new Object[]{I18n._((String)"vradi.email.confirmSendSending.optionYes"), I18n._((String)"vradi.email.confirmSendSending.optionNo"), I18n._((String)"vradi.email.confirmSendSending.optionOtherMail")};
        int i = JOptionPane.showOptionDialog(ui, I18n._((String)"vradi.email.confirmSendSending", (Object[])new Object[]{this.getQueryMakerName(sending)}), I18n._((String)"vradi.email.confirmSendSendingTitle"), 1, 3, null, options, options[2]);
        String email = null;
        if (i == 2) {
            email = JOptionPane.showInputDialog(ui, I18n._((String)"vradi.email.confirmSendSending.askMail"), I18n._((String)"vradi.email.confirmSendSending.askMailTitle"), -1);
            i = 0;
        }
        if (i == 0) {
            Session session = this.getSessionBySending(sending.getWikittyId());
            final String sessionParagraph = session.getParagraph();
            final String finalEmail = email;
            final EmailPopupUI finalUI = ui.getParentContainer(EmailPopupUI.class);
            VradiTask<Void> sendSendingTask = new VradiTask<Void>((JAXXContext)ui, "vradi.email.sendSending"){

                @Override
                public Void doAction() throws VradiException {
                    Sending sendingResult = null;
                    try {
                        sendingResult = EmailHandler.this.getStorageService().sendMessage(sending.getWikittyId(), sessionParagraph, finalEmail);
                    }
                    catch (VradiException eee) {
                        JOptionPane.showMessageDialog(finalUI, I18n._((String)"vradi.email.sendSending.sendError", (Object[])new Object[]{eee.getMessage()}), I18n._((String)"vradi.email.sendSession.error"), 0);
                        EmailHandler.this.updateSendingStatus(sendingResult, VradiConstants.SendingStatus.ERROR);
                    }
                    return null;
                }

                @Override
                public void doWhenError(Exception eee) {
                    EmailHandler.this.updateSendingStatus(sending, VradiConstants.SendingStatus.ERROR);
                }
            };
            sendSendingTask.execute();
        }
    }

    public boolean send(final EmailPopupUI ui) {
        final Session session = ui.getHelper().getSelectedActiveSession();
        int confirm = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmSendSession"), I18n._((String)"vradi.email.confirmSendSessionTitle"), 0, 3);
        if (confirm != 0) {
            return false;
        }
        if (!this.checkAllSending(ui, session)) {
            return false;
        }
        AbstractProgressBarUI pb = new AbstractProgressBarUI((JAXXContext)ui){
            private static final long serialVersionUID = 5926558779822425487L;

            @Override
            public void cancel() {
                try {
                    VradiService.getVradiStorageService().stopSentMail(session);
                    this.dispose();
                }
                catch (VradiException eee) {
                    log.info((Object)"Cant stop sending emails : ", (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                ui.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        if (log.isInfoEnabled()) {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
            log.info((Object)("Sending session : " + session.getNum() + " - " + format.format(session.getSessionDate()) + " status : " + VradiConstants.SessionStatus.getStatus((int)session.getStatus()).getDescription()));
        }
        VradiTask<Boolean> pdfGenerationAndSendingTask = new VradiTask<Boolean>((JAXXContext)ui, pb, I18n.n_((String)"vradi.email.generation")){

            @Override
            public Boolean doAction() throws Exception {
                try {
                    VradiService.getVradiStorageService().generatePDFForSession(session.getWikittyId());
                }
                catch (Exception eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)this.getErrorMsg(), (Throwable)eee);
                    }
                    this.doWhenError(eee);
                    ErrorDialogUI.showError((Exception)eee);
                    return false;
                }
                return true;
            }

            @Override
            public void doWhenDone() throws Exception {
                Boolean result = (Boolean)this.get();
                if (result != null && result.booleanValue()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Start sending mails");
                    }
                    VradiTask<Void> sentTask = new VradiTask<Void>((JAXXContext)ui, this.pb, I18n.n_((String)"vradi.email.sendSession")){

                        @Override
                        public Void doAction() throws Exception {
                            try {
                                VradiService.getVradiStorageService().sendMessages(session.getWikittyId());
                            }
                            catch (VradiException eee) {
                                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.email.sendSending.sendError", (Object[])new Object[]{eee.getMessage()}), I18n._((String)"vradi.email.sendSession.error"), 0);
                                EmailHandler.this.updateSessionStatus(session, VradiConstants.SessionStatus.ERROR);
                            }
                            return null;
                        }

                        @Override
                        public void doWhenError(Exception eee) {
                            EmailHandler.this.updateSessionStatus(session, VradiConstants.SessionStatus.ERROR);
                        }
                    };
                    sentTask.execute();
                }
            }

            @Override
            public void doWhenError(Exception eee) {
                EmailHandler.this.updateSessionStatus(session, VradiConstants.SessionStatus.ERROR);
            }
        };
        pdfGenerationAndSendingTask.execute();
        return true;
    }

    protected boolean checkAllSending(EmailPopupUI ui, Session session) {
        ArrayList<String> alreadyAskFormType = new ArrayList<String>();
        for (Sending sending : this.getSendingList(session)) {
            String emailUser;
            String userId = sending.getUser();
            User user = (User)this.getProxy().restore(User.class, userId);
            if (user != null && ((emailUser = user.getEmail()) == null || emailUser.isEmpty())) {
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                boolean abord = this.askAbordSending(ui, I18n._((String)"vradi.email.askUserEmailEmpty", (Object[])new Object[]{user.getName(), client.getName()}));
                if (abord) {
                    this.updateSendingStatus(sending, VradiConstants.SendingStatus.ERROR);
                    return false;
                }
            }
            ArrayList<String> formIds = new ArrayList<String>(sending.getForm());
            List forms = this.getProxy().restore(Form.class, formIds);
            for (Form form : forms) {
                boolean fileExists;
                WikittyExtension extension;
                block11: {
                    String extensionName = null;
                    for (String ext : form.getExtensionNames()) {
                        if (ext.equals("Infogene") || ext.equals("Form")) continue;
                        extensionName = ext;
                        break;
                    }
                    VradiStorageService storageService = VradiService.getVradiStorageService();
                    extension = null;
                    try {
                        extension = storageService.getFormType(extensionName);
                    }
                    catch (VradiException eee) {
                        log.error((Object)("Cant get formType for form " + form.getObjet() + " with extention : " + extensionName), (Throwable)eee);
                        ErrorDialogUI.showError((Exception)((Object)eee));
                    }
                    String template = VradiHelper.getFormTypeTemplate(extension);
                    fileExists = false;
                    try {
                        File file = VradiService.getFileService().downloadTemplate(extensionName, template);
                        if (file != null) {
                            fileExists = file.isFile();
                        }
                    }
                    catch (VradiException eee) {
                        if (!log.isErrorEnabled()) break block11;
                        log.error((Object)"Can't download template", (Throwable)eee);
                        ErrorDialogUI.showError((Exception)((Object)eee));
                    }
                }
                if (fileExists || alreadyAskFormType.contains(extension.getName())) continue;
                boolean abord = this.askAbordSending(ui, I18n._((String)"vradi.email.askModelEmpty", (Object[])new Object[]{extension.getName()}));
                if (abord) {
                    return false;
                }
                alreadyAskFormType.add(extension.getName());
            }
        }
        return true;
    }

    protected boolean askAbordSending(EmailPopupUI ui, String msg) {
        int i = JOptionPane.showConfirmDialog(ui, msg, I18n._((String)"vradi.email.askAbordSendingTitle"), 0);
        return i != 0;
    }

    public Sending updateSendingStatus(Sending sending, VradiConstants.SendingStatus status) {
        if (sending == null) {
            return null;
        }
        Sending sendingRestored = (Sending)this.getProxy().restore(Sending.class, sending.getWikittyId());
        sendingRestored.setStatus(status.getValue());
        log.info((Object)("Saving sending " + sendingRestored.getWikittyId() + " with status " + status.getDescription()));
        return (Sending)this.getProxy().store((BusinessEntity)sendingRestored);
    }

    public Session updateSessionStatus(Session session, VradiConstants.SessionStatus status) {
        if (session == null) {
            return null;
        }
        Session sessionRestored = (Session)this.getProxy().restore(Session.class, session.getWikittyId());
        sessionRestored.setStatus(status.getValue());
        sessionRestored.setSessionDate(new Date());
        log.info((Object)("Saving session " + sessionRestored.getWikittyId() + " with status " + status.getDescription()));
        return (Session)this.getProxy().store((BusinessEntity)sessionRestored);
    }

    protected String getQueryMakerName(Sending sending) {
        String userId = sending.getUser();
        String groupId = sending.getGroup();
        if (userId != null) {
            return ((User)this.getProxy().restore(User.class, userId)).getName();
        }
        if (groupId != null) {
            return ((Group)this.getProxy().restore(Group.class, groupId)).getName();
        }
        return "";
    }

    public void cancelSession(EmailPopupUI ui) {
        int i;
        Session session = ui.getHelper().getSelectedActiveSession();
        if (session != null && (i = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confimCloseSession"), I18n._((String)"vradi.email.confimCloseSession.titles"), 0)) == 0) {
            this.updateSessionStatus(session, VradiConstants.SessionStatus.CANCELED);
        }
    }

    public void updateReceptionProof(Session session, Sending sending, boolean isSelected) {
        sending.setReceptionProof(isSelected);
        String groupId = sending.getGroup();
        Group group = (Group)this.getProxy().restore(Group.class, groupId);
        if (group != null) {
            ArrayList<String> userIds = new ArrayList<String>(group.getUser());
            List users = this.getProxy().restore(User.class, userIds);
            for (User user : users) {
                Sending userSending = this.getSendingForUser(session, user.getWikittyId());
                this.updateReceptionProof(session, userSending, isSelected);
            }
        }
        this.getProxy().store((BusinessEntity)sending);
    }

    public void updateParagraph(Session session, Sending sending, String text) {
        sending.setParagraph(text);
        String groupId = sending.getGroup();
        Group group = (Group)this.getProxy().restore(Group.class, groupId);
        if (group != null) {
            ArrayList<String> userIds = new ArrayList<String>(group.getUser());
            List users = this.getProxy().restore(User.class, userIds);
            for (User user : users) {
                Sending userSending = this.getSendingForUser(session, user.getWikittyId());
                String userParagraph = userSending.getParagraph();
                if (userParagraph != null && !userParagraph.isEmpty()) continue;
                this.updateParagraph(session, userSending, text);
            }
        }
        this.getProxy().store((BusinessEntity)sending);
    }

    protected List<Sending> getSendingList(Session session) {
        if (session == null || session.getSending() == null) {
            return new ArrayList<Sending>();
        }
        ArrayList<String> sendingIds = new ArrayList<String>(session.getSending());
        return this.getProxy().restore(Sending.class, sendingIds);
    }

    protected List<User> getUserOfClient(String clientId) {
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "Client");
        query.contains("User.client", this.getStringAsList(clientId));
        Criteria criteria = query.criteria();
        PagedResult nodes = this.getProxy().findAllByCriteria(User.class, criteria);
        return nodes.getAll();
    }

    protected Sending getSendingForUser(Session session, String userId) {
        List<Sending> sendings = this.getSendingList(session);
        for (Sending sending : sendings) {
            if (!sending.getUser().equals(userId)) continue;
            return sending;
        }
        return null;
    }

    protected Session getSessionBySending(String sendingId) {
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "Session");
        query.contains("Session.sending", this.getStringAsList(sendingId));
        Criteria criteria = query.criteria();
        PagedResult nodes = this.getProxy().findAllByCriteria(Session.class, criteria);
        return (Session)nodes.getFirst();
    }

    protected List<String> getStringAsList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }
}

