/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-independent"}, sequential=true)
public class SequencerFailoverTest {
    JChannel a;
    JChannel b;
    JChannel c;
    static final String GROUP = "SequencerFailoverTest";
    static final int NUM_MSGS = 50;
    static final String props = "sequencer.xml";

    @BeforeMethod
    public void setUp() throws Exception {
        this.a = new JChannel(props);
        this.a.setName("A");
        this.a.connect(GROUP);
        this.b = new JChannel(props);
        this.b.setName("B");
        this.b.connect(GROUP);
        this.c = new JChannel(props);
        this.c.setName("C");
        this.c.connect(GROUP);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        Util.close(this.c, this.b, this.a);
    }

    @Test
    public void testBroadcastSequence() throws Exception {
        MyReceiver rb = new MyReceiver("B");
        MyReceiver rc = new MyReceiver("C");
        this.b.setReceiver(rb);
        this.c.setReceiver(rc);
        View v2 = this.b.getView();
        View v3 = this.c.getView();
        System.out.println("ch2's view: " + v2 + "\nch3's view: " + v3);
        assert (v2.equals(v3));
        new Thread(){

            @Override
            public void run() {
                Util.sleep(3000L);
                System.out.println("** killing A");
                try {
                    Util.shutdown(SequencerFailoverTest.this.a);
                }
                catch (Exception e) {
                    System.err.println("failed shutting down channel " + SequencerFailoverTest.this.a.getAddress() + ", exception=" + e);
                }
                System.out.println("** A killed");
                SequencerFailoverTest.injectSuspectEvent(SequencerFailoverTest.this.a.getAddress(), new JChannel[]{SequencerFailoverTest.this.b, SequencerFailoverTest.this.c});
                SequencerFailoverTest.this.a = null;
            }
        }.start();
        for (int i = 1; i <= 50; ++i) {
            Util.sleep(300L);
            this.b.send(new Message(null, null, new Integer(i)));
            System.out.print("-- messages sent: " + i + "/" + 50 + "\r");
        }
        System.out.println("");
        v2 = this.b.getView();
        v3 = this.c.getView();
        System.out.println("B's view: " + v2 + "\nC's view: " + v3);
        assert (v2.equals(v3));
        assert (v2.size() == 2);
        for (int i = 15000; i > 0; i -= 1000) {
            int s2 = rb.size();
            int s3 = rc.size();
            if (s2 >= 50 && s3 >= 50) {
                System.out.print("B: " + s2 + " msgs, C: " + s3 + " msgs\r");
                break;
            }
            Util.sleep(1000L);
            System.out.print("sleeping for " + i / 1000 + " seconds (B: " + s2 + " msgs, C: " + s3 + " msgs)\r");
        }
        System.out.println("-- verifying messages on B and C");
        List<Integer> list_b = rb.getList();
        List<Integer> list_c = rc.getList();
        System.out.println("B: " + list_b + "\nC: " + list_c);
        assert (list_b.size() == list_c.size());
        System.out.println("OK: both B and C have the same number of messages (" + list_b.size() + ")");
        assert (list_b.size() == 50 && list_c.size() == 50);
        System.out.println("OK: both B and C have the expected number (50) of messages");
        System.out.println("verifying B and C have the same order");
        for (int i = 0; i < list_b.size(); ++i) {
            Integer el_b = list_b.get(i);
            Integer el_c = list_c.get(i);
            assert (el_b.equals(el_c)) : "element at index=" + i + " in B (" + el_b + ") is different from element " + i + " in C (" + el_c + ")";
        }
        System.out.println("OK: B and C's message are in the same order");
    }

    private static void injectSuspectEvent(Address suspected_mbr, JChannel ... channels) {
        Event evt = new Event(9, suspected_mbr);
        for (JChannel ch : channels) {
            GMS gms = (GMS)ch.getProtocolStack().findProtocol(GMS.class);
            if (gms == null) continue;
            gms.up(evt);
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private final List<Integer> list = new LinkedList<Integer>();
        private final String name;

        public MyReceiver(String name) {
            this.name = name;
        }

        public List<Integer> getList() {
            return this.list;
        }

        public int size() {
            return this.list.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            Integer val = (Integer)msg.getObject();
            List<Integer> list = this.list;
            synchronized (list) {
                this.list.add(val);
            }
        }

        void clear() {
            this.list.clear();
        }
    }
}

