/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.InetAddress;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.MPING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"broken"}, sequential=true)
public class ChannelConcurrencyTest
extends ChannelTestBase {
    public void testPlainChannel() throws Throwable {
        this.testhelper(false);
    }

    public void testwithDispatcher() throws Throwable {
        this.testhelper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testhelper(boolean useDispatcher) throws Throwable {
        int count = 8;
        ExecutorService executor = Executors.newFixedThreadPool(8);
        CountDownLatch latch = new CountDownLatch(8);
        JChannel[] channels = new JChannel[8];
        Task[] tasks = new Task[8];
        long start = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            channels[i] = i == 0 ? this.createChannel(true, 8) : this.createChannel(channels[0]);
            tasks[i] = new Task(latch, channels[i], useDispatcher);
            ChannelConcurrencyTest.changeMergeInterval(channels[i]);
            ChannelConcurrencyTest.changeViewBundling(channels[i]);
            ChannelConcurrencyTest.replaceDiscoveryProtocol(channels[i]);
        }
        for (Task t : tasks) {
            executor.execute(t);
        }
        int timeoutToConverge = 120;
        boolean successConnecting = false;
        try {
            successConnecting = latch.await(timeoutToConverge, TimeUnit.SECONDS);
            if (successConnecting) {
                this.log.info("All connected. Converging...");
                Task[] arr$ = tasks;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Task t = arr$[i$];
                    Throwable ex = t.getException();
                    if (ex == null) continue;
                    throw ex;
                }
                boolean converged = false;
                for (int counter = 0; counter < timeoutToConverge && !converged; ++counter) {
                    for (JChannel channel : channels) {
                        boolean bl = converged = channel.getView() != null && channel.getView().size() == 8;
                        if (!converged) break;
                    }
                    TimeUnit.SECONDS.sleep(1L);
                }
                long duration = System.currentTimeMillis() - start;
                this.log.info("Converged to a single group after " + duration + " ms; group is:\n");
                for (int i = 0; i < channels.length; ++i) {
                    this.log.info("#" + (i + 1) + ": " + channels[i].getAddress() + ": " + channels[i].getView());
                }
            }
            for (JChannel channel : channels) {
                ChannelConcurrencyTest.assertEquals("View ok for channel " + channel.getAddress(), 8, channel.getView().size());
            }
            ChannelConcurrencyTest.assertTrue("All channels were succefully connected", successConnecting);
        }
        finally {
            Util.sleep(2500L);
            executor.shutdownNow();
            this.log.info("closing channels: ");
            for (JChannel ch : channels) {
                ch.close();
                Util.sleep(500L);
            }
        }
    }

    private static void changeViewBundling(JChannel channel) {
        ProtocolStack stack = channel.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol(GMS.class);
        if (gms != null) {
            gms.setViewBundling(true);
            gms.setMaxBundlingTime(500L);
        }
    }

    private static void changeMergeInterval(JChannel channel) {
        ProtocolStack stack = channel.getProtocolStack();
        MERGE2 merge = (MERGE2)stack.findProtocol(MERGE2.class);
        if (merge != null) {
            merge.setMinInterval(5000L);
            merge.setMaxInterval(10000L);
        }
    }

    private static void replaceDiscoveryProtocol(JChannel ch) throws Exception {
        ProtocolStack stack = ch.getProtocolStack();
        Protocol discovery = stack.removeProtocol("TCPPING");
        if (discovery != null) {
            TP transport = stack.getTransport();
            MPING mping = new MPING();
            InetAddress bindAddress = Util.getBindAddress(new Properties());
            mping.setBindAddr(bindAddress);
            mping.setMulticastAddress("230.1.2.3");
            mping.setMcastPort(8888);
            stack.insertProtocol((Protocol)mping, 1, transport.getName());
            mping.setProtocolStack(ch.getProtocolStack());
            mping.init();
            mping.start();
            System.out.println("Replaced TCPPING with MPING. See http://wiki.jboss.org/wiki/Wiki.jsp?page=JGroupsMERGE2");
        }
    }

    private static class MyHandler
    implements RequestHandler {
        private MyHandler() {
        }

        @Override
        public Object handle(Message msg) {
            return msg.getObject();
        }
    }

    private static class Task
    implements Runnable {
        private final Channel c;
        private final CountDownLatch latch;
        private Throwable exception = null;
        private boolean useDispatcher = false;

        public Task(CountDownLatch latch, Channel c, boolean useDispatcher) {
            this.latch = latch;
            this.c = c;
            this.useDispatcher = useDispatcher;
        }

        public Throwable getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.c.connect("ChannelConcurrencyTest");
                if (this.useDispatcher && this.c.isConnected()) {
                    MessageDispatcher md = new MessageDispatcher(this.c, null, null, new MyHandler());
                    for (int i = 0; i < 10; ++i) {
                        RspList rsp = md.castMessage(null, new Message(null, null, Integer.valueOf(i)), 2, 2500L);
                        for (Object o : rsp.getResults()) {
                            ChannelTestBase.assertEquals("Wrong result received at " + this.c.getAddress(), i, o);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.exception = e;
                e.printStackTrace();
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

