/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.Util;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class AgeOutCacheTest {
    ScheduledExecutorService timer;

    @BeforeClass
    void start() throws Exception {
        this.timer = Executors.newScheduledThreadPool(5);
    }

    @AfterClass
    void stop() throws Exception {
        this.timer.shutdownNow();
    }

    public void testExpiration() {
        AgeOutCache<Integer> cache = new AgeOutCache<Integer>(this.timer, 500L, new AgeOutCache.Handler<Integer>(){

            @Override
            public void expired(Integer key) {
                System.out.println(key + " expired");
            }
        });
        for (int i = 1; i <= 5; ++i) {
            cache.add(i);
        }
        System.out.println("cache:\n" + cache);
        int size = cache.size();
        assert (size == 5) : "size is " + size;
        Util.sleep(1500L);
        System.out.println("cache:\n" + cache);
        assert ((size = cache.size()) == 0) : "size is " + size;
    }

    public void testRemoveAndExpiration() {
        AgeOutCache<Integer> cache = new AgeOutCache<Integer>(this.timer, 500L);
        for (int i = 1; i <= 5; ++i) {
            cache.add(i);
        }
        System.out.println("cache:\n" + cache);
        cache.remove(3);
        cache.remove(5);
        cache.remove(6);
        System.out.println("cache:\n" + cache);
        assert (cache.size() == 3) : "cache size should be 3 but is " + cache;
        Util.sleep(1500L);
        assert (cache.size() == 0);
    }

    public void testContains() {
        AgeOutCache<Integer> cache = new AgeOutCache<Integer>(this.timer, 5000L);
        for (int i = 1; i <= 5; ++i) {
            cache.add(i);
        }
        System.out.println("cache:\n" + cache);
        assert (cache.contains(3));
        cache.remove(3);
        System.out.println("cache:\n" + cache);
        assert (!cache.contains(3));
        cache.clear();
        assert (cache.size() == 0);
        assert (!cache.contains(4));
    }

    public void testGradualExpiration() {
        AgeOutCache<Integer> cache = new AgeOutCache<Integer>(this.timer, 5000L, new AgeOutCache.Handler<Integer>(){

            @Override
            public void expired(Integer key) {
                System.out.println(key + " expired");
            }
        });
        for (int i = 1; i <= 10; ++i) {
            cache.add(i);
            System.out.print(".");
            Util.sleep(1000L);
        }
        System.out.println("\ncache:\n" + cache);
        int size = cache.size();
        assert (size < 10 && size > 0) : " size was " + size + ", but should have been < 10 or > 0";
    }
}

