/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import org.jgroups.JChannel;
import org.jgroups.blocks.VotingAdapter;
import org.jgroups.blocks.VotingListener;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"})
public class VotingAdapterTest
extends ChannelTestBase {
    private JChannel channel1;
    private JChannel channel2;
    protected VotingAdapter adapter1;
    protected VotingAdapter adapter2;
    protected TestVoteChannelListener listener1;
    protected TestVoteChannelListener listener2;
    protected TestVoteChannelListener listener3;
    protected TestVoteChannelListener listener4;
    protected static boolean logConfigured = false;

    @BeforeMethod
    void setUp() throws Exception {
        this.listener1 = new TestVoteChannelListener(true);
        this.listener2 = new TestVoteChannelListener(true);
        this.listener3 = new TestVoteChannelListener(false);
        this.listener4 = new TestVoteChannelListener(false);
        this.channel1 = this.createChannel(true);
        this.adapter1 = new VotingAdapter(this.channel1);
        this.channel1.connect("VotingAdapterTest");
        this.channel2 = this.createChannel(this.channel1);
        this.adapter2 = new VotingAdapter(this.channel2);
        this.channel2.connect("VotingAdapterTest");
    }

    @AfterMethod
    void tearDown() throws Exception {
        Util.close(this.channel2, this.channel1);
    }

    public void testVoteAll() throws Exception {
        this.adapter1.addVoteListener(this.listener1);
        this.adapter2.addVoteListener(this.listener2);
        boolean voting1 = this.adapter1.vote((Object)"object1", 1, 1000L);
        assert (voting1) : "Result of voting1 should be 'true'";
        this.adapter1.addVoteListener(this.listener3);
        boolean voting2 = this.adapter1.vote((Object)"object2", 1, 1000L);
        assert (!voting2) : "Result of voting2 should be 'false'";
    }

    public static class TestVoteChannelListener
    implements VotingListener {
        private boolean vote;

        public TestVoteChannelListener(boolean vote) {
            this.vote = vote;
        }

        @Override
        public boolean vote(Object decree) {
            return this.vote;
        }
    }
}

