/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.search.DateValueSourceParser;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.function.BoostedQuery;
import org.apache.solr.search.function.DivFloatFunction;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.DualFloatFunction;
import org.apache.solr.search.function.LinearFloatFunction;
import org.apache.solr.search.function.MaxFloatFunction;
import org.apache.solr.search.function.OrdFieldSource;
import org.apache.solr.search.function.PowFloatFunction;
import org.apache.solr.search.function.ProductFloatFunction;
import org.apache.solr.search.function.QueryValueSource;
import org.apache.solr.search.function.RangeMapFloatFunction;
import org.apache.solr.search.function.ReciprocalFloatFunction;
import org.apache.solr.search.function.ReverseOrdFieldSource;
import org.apache.solr.search.function.ScaleFloatFunction;
import org.apache.solr.search.function.SimpleFloatFunction;
import org.apache.solr.search.function.SumFloatFunction;
import org.apache.solr.search.function.TopValueSource;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public abstract class ValueSourceParser
implements NamedListInitializedPlugin {
    public static Map<String, ValueSourceParser> standardValueSourceParsers = new HashMap<String, ValueSourceParser>();

    public abstract void init(NamedList var1);

    public abstract ValueSource parse(FunctionQParser var1) throws ParseException;

    static {
        standardValueSourceParsers.put("ord", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                String field = fp.parseId();
                return new TopValueSource(new OrdFieldSource(field));
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("rord", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                String field = fp.parseId();
                return new TopValueSource(new ReverseOrdFieldSource(field));
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("top", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                if (source instanceof TopValueSource) {
                    return source;
                }
                return new TopValueSource(source);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("linear", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float slope = fp.parseFloat().floatValue();
                float intercept = fp.parseFloat().floatValue();
                return new LinearFloatFunction(source, slope, intercept);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("max", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float val = fp.parseFloat().floatValue();
                return new MaxFloatFunction(source, val);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("recip", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float m = fp.parseFloat().floatValue();
                float a = fp.parseFloat().floatValue();
                float b = fp.parseFloat().floatValue();
                return new ReciprocalFloatFunction(source, m, a, b);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("scale", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float min = fp.parseFloat().floatValue();
                float max = fp.parseFloat().floatValue();
                return new TopValueSource(new ScaleFloatFunction(source, min, max));
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("pow", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource a = fp.parseValueSource();
                ValueSource b = fp.parseValueSource();
                return new PowFloatFunction(a, b);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("div", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource a = fp.parseValueSource();
                ValueSource b = fp.parseValueSource();
                return new DivFloatFunction(a, b);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("map", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float min = fp.parseFloat().floatValue();
                float max = fp.parseFloat().floatValue();
                float target = fp.parseFloat().floatValue();
                Float def = fp.hasMoreArguments() ? fp.parseFloat() : null;
                return new RangeMapFloatFunction(source, min, max, target, def);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("sqrt", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                return new SimpleFloatFunction(source){

                    protected String name() {
                        return "sqrt";
                    }

                    protected float func(int doc, DocValues vals) {
                        return (float)Math.sqrt(vals.floatVal(doc));
                    }
                };
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("log", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                return new SimpleFloatFunction(source){

                    protected String name() {
                        return "log";
                    }

                    protected float func(int doc, DocValues vals) {
                        return (float)Math.log10(vals.floatVal(doc));
                    }
                };
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("abs", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                return new SimpleFloatFunction(source){

                    protected String name() {
                        return "abs";
                    }

                    protected float func(int doc, DocValues vals) {
                        return Math.abs(vals.floatVal(doc));
                    }
                };
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("sum", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new SumFloatFunction(sources.toArray(new ValueSource[sources.size()]));
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("product", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new ProductFloatFunction(sources.toArray(new ValueSource[sources.size()]));
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("sub", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource a = fp.parseValueSource();
                ValueSource b = fp.parseValueSource();
                return new DualFloatFunction(a, b){

                    protected String name() {
                        return "sub";
                    }

                    protected float func(int doc, DocValues aVals, DocValues bVals) {
                        return aVals.floatVal(doc) - bVals.floatVal(doc);
                    }
                };
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("query", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                Query q = fp.parseNestedQuery();
                float defVal = 0.0f;
                if (fp.hasMoreArguments()) {
                    defVal = fp.parseFloat().floatValue();
                }
                return new QueryValueSource(q, defVal);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("boost", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                Query q = fp.parseNestedQuery();
                ValueSource vs = fp.parseValueSource();
                BoostedQuery bq = new BoostedQuery(q, vs);
                return new QueryValueSource(bq, 0.0f);
            }

            public void init(NamedList args) {
            }
        });
        standardValueSourceParsers.put("ms", new DateValueSourceParser());
    }
}

