/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: FormPagedResult.java 1786 2010-11-16 13:46:15Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-services/src/main/java/com/jurismarches/vradi/beans/FormPagedResult.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.jurismarches.vradi.entities.Form;

/**
 * Contient en meme tps les parametres de recherches et les resultats and
 * les parametres en résultats.
 * 
 * @author morin
 *         Date: 4 déc. 2009
 *         Time: 09:43:37
 */
public class FormPagedResult implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public static final String FORMS_TO_SHOW_PROPERTY = "formsToShow";
    public static final String TOTAL_FOUND_FORM_NB_PROPERTY = "totalFoundFormNb";
    public static final String PAGE_TO_SHOW_PROPERTY = "pageToShow";
    public static final String NB_FORMS_TO_SHOW_PROPERTY = "nbFormsToShow";
    public static final String FIELD_TO_SORT_PROPERTY = "fieldToSort";
    public static final String ASCENDING_PROPERTY = "ascending";

    /** Result forms. */
    protected List<String> formsIdsToShow;

    /** Total result count. */
    protected int totalFoundFormNb = 0;

    /** Current page index. */
    protected int pageToShow = 0;

    /** Total page count. */
    protected int nbFormsToShow = 0;

    /** Field name to sort (wikitty fqName). */
    protected String fieldToSort = null;

    /** Sort order. */
    protected boolean ascending = true;

    public FormPagedResult() {
        formsIdsToShow = new ArrayList<String>();
    }

    public FormPagedResult(List<Form> formsToShow) {
        this(formsToShow, formsToShow.size(), 0, formsToShow.size());
    }

    public FormPagedResult(List<Form> formsToShow, int totalFoundFormNb, int pageToShow, int nbFormsToShow) {
        this();
        this.formsIdsToShow = extractIds(formsToShow);
        this.totalFoundFormNb = totalFoundFormNb;
        this.pageToShow = pageToShow;
        this.nbFormsToShow = nbFormsToShow;
    }

    protected List<String> extractIds(List<Form> formsToShow) {
        List<String> formsIds = new ArrayList<String>();
        if (formsToShow != null) {
            for (Form form : formsToShow) {
                if (form != null) {
                    formsIds.add(form.getWikittyId());
                }
            }
        }
        return formsIds;
    }

    public List<String> getFormsIdsToShow() {
        return formsIdsToShow;
    }

    public void setFormsToShow(List<String> formsIdsToShow) {
        List<String> oldValue = this.formsIdsToShow;
        this.formsIdsToShow = formsIdsToShow;
        propertyChange.firePropertyChange(FORMS_TO_SHOW_PROPERTY, oldValue, formsIdsToShow);
    }

    public int getTotalFoundFormNb() {
        return totalFoundFormNb;
    }

    public void setTotalFoundFormNb(int totalFoundFormNb) {
        int oldValue = this.totalFoundFormNb;
        this.totalFoundFormNb = totalFoundFormNb;
        propertyChange.firePropertyChange(TOTAL_FOUND_FORM_NB_PROPERTY, oldValue, totalFoundFormNb);
    }

    public int getPageToShow() {
        return pageToShow;
    }

    public void setPageToShow(int pageToShow) {
        int oldValue = this.pageToShow;
        this.pageToShow = pageToShow;
        propertyChange.firePropertyChange(PAGE_TO_SHOW_PROPERTY, oldValue, pageToShow);
    }

    public int getNbFormsToShow() {
        return nbFormsToShow;
    }

    public void setNbFormsToShow(int nbFormsToShow) {
        int oldValue = this.nbFormsToShow;
        this.nbFormsToShow = nbFormsToShow;
        propertyChange.firePropertyChange(NB_FORMS_TO_SHOW_PROPERTY, oldValue, nbFormsToShow);
    }

    public String getFieldToSort() {
        return fieldToSort;
    }

    public void setFieldToSort(String fieldToSort) {
        String oldValue = this.fieldToSort;
        this.fieldToSort = fieldToSort;
        propertyChange.firePropertyChange(FIELD_TO_SORT_PROPERTY, oldValue, fieldToSort);
    }

    public boolean isAscending() {
        return ascending;
    }

    public void setAscending(boolean ascending) {
        boolean oldValue = this.ascending;
        this.ascending = ascending;
        propertyChange.firePropertyChange(ASCENDING_PROPERTY, oldValue, ascending);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(propertyName, listener);
    }
}
