/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.net.ftp.FTPClient;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.FtpPlugin;
import org.webharvest.runtime.processors.plugins.FtpPluginException;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class FtpPutPlugin
extends WebHarvestPlugin {
    @Override
    public String getName() {
        return "ftp-put";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        block5: {
            FtpPlugin ftpPlugin = (FtpPlugin)scraper.getRunningProcessorOfType(FtpPlugin.class);
            if (ftpPlugin != null) {
                FTPClient ftpClient = ftpPlugin.getFtpClient();
                String path = CommonUtil.nvl(this.evaluateAttribute("path", scraper), "");
                String charset = CommonUtil.nvl(this.evaluateAttribute("charset", scraper), "");
                if (CommonUtil.isEmptyString(charset)) {
                    charset = scraper.getConfiguration().getCharset();
                }
                this.setProperty("Path", path);
                this.setProperty("Charset", charset);
                Variable body = this.executeBody(scraper, scraper.getContext());
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(body.toBinary(charset));
                    boolean succ = ftpClient.storeFile(path, (InputStream)stream);
                    stream.close();
                    if (!succ) {
                        throw new FtpPluginException("Cannot store file \"" + path + "\" to FTP server!");
                    }
                    break block5;
                }
                catch (IOException e) {
                    throw new FtpPluginException(e);
                }
            }
            throw new FtpPluginException("Cannot use ftp put plugin out of ftp plugin context!");
        }
        return new EmptyVariable();
    }

    @Override
    public String[] getValidAttributes() {
        return new String[]{"path", "charset"};
    }

    @Override
    public String[] getRequiredAttributes() {
        return new String[]{"path"};
    }

    @Override
    public String[] getAttributeValueSuggestions(String attributeName) {
        if ("charset".equalsIgnoreCase(attributeName)) {
            Set<String> charsetKeys = Charset.availableCharsets().keySet();
            return new ArrayList<String>(charsetKeys).toArray(new String[charsetKeys.size()]);
        }
        return null;
    }
}

