/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.FtpPlugin;
import org.webharvest.runtime.processors.plugins.FtpPluginException;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class FtpListPlugin
extends WebHarvestPlugin {
    @Override
    public String getName() {
        return "ftp-list";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        block14: {
            FtpPlugin ftpPlugin = (FtpPlugin)scraper.getRunningProcessorOfType(FtpPlugin.class);
            if (ftpPlugin != null) {
                FTPClient ftpClient = ftpPlugin.getFtpClient();
                String path = CommonUtil.nvl(this.evaluateAttribute("path", scraper), "");
                boolean listFiles = this.evaluateAttributeAsBoolean("listfiles", true, scraper);
                boolean listDirs = this.evaluateAttributeAsBoolean("listdirs", true, scraper);
                boolean listLinks = this.evaluateAttributeAsBoolean("listlinks", true, scraper);
                String listFilter = CommonUtil.nvl(this.evaluateAttribute("listfilter", scraper), "");
                Pattern pattern = null;
                if (!CommonUtil.isEmptyString(listFilter)) {
                    StringBuffer buffer = new StringBuffer();
                    block9: for (int i = 0; i < listFilter.length(); ++i) {
                        char ch = listFilter.charAt(i);
                        switch (ch) {
                            case '.': {
                                buffer.append("\\.");
                                continue block9;
                            }
                            case '*': {
                                buffer.append(".*");
                                continue block9;
                            }
                            case '?': {
                                buffer.append(".");
                                continue block9;
                            }
                            default: {
                                buffer.append(ch);
                            }
                        }
                    }
                    try {
                        pattern = Pattern.compile(buffer.toString());
                    }
                    catch (Exception e) {
                        pattern = Pattern.compile("");
                    }
                }
                this.setProperty("Path", path);
                this.setProperty("List Files", listFiles);
                this.setProperty("List Directories", listDirs);
                this.setProperty("List Symbolic Links", listLinks);
                this.setProperty("List Filter", listFilter);
                try {
                    FTPFile[] files = ftpClient.listFiles(path);
                    if (files != null) {
                        ArrayList<String> filenameList = new ArrayList<String>();
                        for (FTPFile ftpFile : files) {
                            if (!(listFiles && ftpFile.isFile() || listDirs && ftpFile.isDirectory()) && (!listLinks || !ftpFile.isSymbolicLink())) continue;
                            String name = ftpFile.getName();
                            if (pattern != null && !pattern.matcher(name).matches()) continue;
                            filenameList.add(name);
                        }
                        return new ListVariable(filenameList);
                    }
                    break block14;
                }
                catch (IOException e) {
                    throw new FtpPluginException(e);
                }
            }
            throw new FtpPluginException("Cannot use ftp list plugin out of ftp plugin context!");
        }
        return new EmptyVariable();
    }

    @Override
    public String[] getValidAttributes() {
        return new String[]{"path", "listfiles", "listdirs", "listlinks", "listfilter"};
    }

    @Override
    public String[] getRequiredAttributes() {
        return new String[0];
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String[] getAttributeValueSuggestions(String attributeName) {
        if ("listfiles".equalsIgnoreCase(attributeName) || "listdirs".equalsIgnoreCase(attributeName) || "listlinks".equalsIgnoreCase(attributeName)) {
            return new String[]{"true", "false"};
        }
        return null;
    }
}

