/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.webharvest.definition.IElementDef;
import org.webharvest.definition.ScraperConfiguration;
import org.webharvest.exception.DatabaseException;
import org.webharvest.runtime.RuntimeConfig;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.ScraperRuntimeListener;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.CallProcessor;
import org.webharvest.runtime.processors.HttpProcessor;
import org.webharvest.runtime.processors.ProcessorResolver;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.runtime.web.HttpClientManager;
import org.webharvest.utils.ClassLoaderUtil;
import org.webharvest.utils.CommonUtil;
import org.webharvest.utils.Stack;

public class Scraper {
    public static final int STATUS_READY = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_FINISHED = 3;
    public static final int STATUS_STOPPED = 4;
    public static final int STATUS_ERROR = 5;
    public static final int STATUS_EXIT = 6;
    private Logger logger = Logger.getLogger((String)("" + System.currentTimeMillis()));
    private ScraperConfiguration configuration;
    private String workingDir;
    private ScraperContext context;
    private RuntimeConfig runtimeConfig;
    private transient boolean isDebugMode = false;
    private HttpClientManager httpClientManager;
    private transient Stack runningProcessors = new Stack();
    private transient Stack runningFunctions = new Stack();
    private transient Map functionParams = new HashMap();
    private transient Stack runningHttpProcessors = new Stack();
    private ScriptEngine scriptEngine = null;
    private Map usedScriptEngines = new HashMap();
    Map dbPool = new HashMap();
    private List<ScraperRuntimeListener> scraperRuntimeListeners = new LinkedList<ScraperRuntimeListener>();
    private int status = 0;
    private String message = null;

    public Scraper(ScraperConfiguration configuration, String workingDir) {
        this.configuration = configuration;
        this.runtimeConfig = new RuntimeConfig();
        this.workingDir = CommonUtil.adaptFilename(workingDir);
        this.httpClientManager = new HttpClientManager();
        this.context = new ScraperContext(this);
        this.scriptEngine = configuration.createScriptEngine(this.context);
        this.usedScriptEngines.put(configuration.getDefaultScriptEngine(), this.scriptEngine);
    }

    public void addVariableToContext(String name, Object value) {
        this.context.put(name, new NodeVariable(value));
    }

    public void addVariablesToContext(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.context.put(entry.getKey(), new NodeVariable(entry.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable execute(List<IElementDef> ops) {
        this.setStatus(1);
        for (ScraperRuntimeListener listener : this.scraperRuntimeListeners) {
            listener.onExecutionStart(this);
        }
        try {
            for (IElementDef elementDef : ops) {
                BaseProcessor processor = ProcessorResolver.createProcessor(elementDef, this.configuration, this);
                if (processor == null) continue;
                processor.run(this, this.context);
            }
        }
        finally {
            this.releaseDBConnections();
        }
        return new EmptyVariable();
    }

    public void execute() {
        long startTime = System.currentTimeMillis();
        this.execute(this.configuration.getOperations());
        if (this.status == 1) {
            this.setStatus(3);
        }
        for (ScraperRuntimeListener listener : this.scraperRuntimeListeners) {
            listener.onExecutionEnd(this);
        }
        if (this.logger.isInfoEnabled()) {
            if (this.status == 3) {
                this.logger.info((Object)("Configuration executed in " + (System.currentTimeMillis() - startTime) + "ms."));
            } else if (this.status == 4) {
                this.logger.info((Object)"Configuration stopped!");
            }
        }
    }

    public ScraperContext getContext() {
        return this.context;
    }

    public ScraperConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public HttpClientManager getHttpClientManager() {
        return this.httpClientManager;
    }

    public void addRunningFunction(CallProcessor callProcessor) {
        this.runningFunctions.push(callProcessor);
    }

    public CallProcessor getRunningFunction() {
        return this.runningFunctions.isEmpty() ? null : (CallProcessor)this.runningFunctions.peek();
    }

    public void clearFunctionParams() {
        this.functionParams.clear();
    }

    public void addFunctionParam(String name, Variable value) {
        this.functionParams.put(name, value);
    }

    public Map getFunctionParams() {
        return this.functionParams;
    }

    public void removeRunningFunction() {
        if (this.runningFunctions.size() > 0) {
            this.runningFunctions.pop();
        }
    }

    public HttpProcessor getRunningHttpProcessor() {
        return (HttpProcessor)this.runningHttpProcessors.peek();
    }

    public void setRunningHttpProcessor(HttpProcessor httpProcessor) {
        this.runningHttpProcessors.push(httpProcessor);
    }

    public void removeRunningHttpProcessor() {
        if (this.runningHttpProcessors.size() > 0) {
            this.runningHttpProcessors.pop();
        }
    }

    public int getRunningLevel() {
        return this.runningProcessors.size() + 1;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void setDebug(boolean debug) {
        this.isDebugMode = debug;
    }

    public ScriptEngine getScriptEngine() {
        return this.runningFunctions.size() > 0 ? this.getRunningFunction().getScriptEngine() : this.scriptEngine;
    }

    public synchronized ScriptEngine getScriptEngine(String engineType) {
        ScriptEngine engine = (ScriptEngine)this.usedScriptEngines.get(engineType);
        if (engine == null) {
            engine = this.configuration.createScriptEngine(this.context, engineType);
            this.usedScriptEngines.put(engineType, engine);
        }
        return engine;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public BaseProcessor getRunningProcessor() {
        return (BaseProcessor)this.runningProcessors.peek();
    }

    public BaseProcessor getParentRunningProcessor(BaseProcessor processor) {
        List runningProcessorList = this.runningProcessors.getList();
        int index = CommonUtil.findValueInCollection(runningProcessorList, processor);
        return index > 0 ? (BaseProcessor)runningProcessorList.get(index - 1) : null;
    }

    public BaseProcessor getRunningProcessorOfType(Class processorClazz) {
        List runningProcessorList = this.runningProcessors.getList();
        ListIterator listIterator = runningProcessorList.listIterator(this.runningProcessors.size());
        while (listIterator.hasPrevious()) {
            BaseProcessor curr = (BaseProcessor)listIterator.previous();
            if (!processorClazz.equals(curr.getClass())) continue;
            return curr;
        }
        return null;
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public Connection getConnection(String jdbc, String connection, String username, String password) {
        try {
            String poolKey = jdbc + "-" + connection + "-" + username + "-" + password;
            Connection conn = (Connection)this.dbPool.get(poolKey);
            if (conn == null) {
                ClassLoaderUtil.registerJDBCDriver(jdbc);
                conn = DriverManager.getConnection(connection, username, password);
                this.dbPool.put(poolKey, conn);
            }
            return conn;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    public void setExecutingProcessor(BaseProcessor processor) {
        this.runningProcessors.push(processor);
        for (ScraperRuntimeListener listener : this.scraperRuntimeListeners) {
            listener.onNewProcessorExecution(this, processor);
        }
    }

    public void finishExecutingProcessor() {
        if (this.runningProcessors.size() > 0) {
            this.runningProcessors.pop();
        }
    }

    public void processorFinishedExecution(BaseProcessor processor, Map properties) {
        for (ScraperRuntimeListener listener : this.scraperRuntimeListeners) {
            listener.onProcessorExecutionFinished(this, processor, properties);
        }
    }

    public void addRuntimeListener(ScraperRuntimeListener listener) {
        this.scraperRuntimeListeners.add(listener);
    }

    public void removeRuntimeListener(ScraperRuntimeListener listener) {
        this.scraperRuntimeListeners.remove(listener);
    }

    public synchronized int getStatus() {
        return this.status;
    }

    private synchronized void setStatus(int status) {
        this.status = status;
    }

    public void stopExecution() {
        this.setStatus(4);
    }

    public void exitExecution(String message) {
        this.setStatus(6);
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void pauseExecution() {
        if (this.status == 1) {
            this.setStatus(2);
            for (ScraperRuntimeListener listener : this.scraperRuntimeListeners) {
                listener.onExecutionPaused(this);
            }
        }
    }

    public void continueExecution() {
        if (this.status == 2) {
            this.setStatus(1);
            for (ScraperRuntimeListener listener : this.scraperRuntimeListeners) {
                listener.onExecutionContinued(this);
            }
        }
    }

    public void informListenersAboutError(Exception e) {
        this.setStatus(5);
        for (ScraperRuntimeListener listener : this.scraperRuntimeListeners) {
            listener.onExecutionError(this, e);
        }
    }

    public void releaseDBConnections() {
        for (Connection conn : this.dbPool.values()) {
            if (conn == null) continue;
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    public void dispose() {
        this.context.clear();
        this.context.dispose();
        if (this.usedScriptEngines != null) {
            for (ScriptEngine engine : this.usedScriptEngines.values()) {
                if (engine == null) continue;
                engine.dispose();
            }
        }
        this.logger.removeAllAppenders();
        for (ScriptEngine engine : this.usedScriptEngines.values()) {
            engine.dispose();
        }
    }
}

