/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.bounce.text.xml.WrappedXMLView;
import org.bounce.text.xml.XMLContext;
import org.bounce.text.xml.XMLDocument;
import org.bounce.text.xml.XMLStyleConstants;
import org.bounce.text.xml.XMLView;
import org.webharvest.gui.XmlTextPane;

public class XMLEditorKit
extends DefaultEditorKit
implements XMLStyleConstants {
    private static final long serialVersionUID = 3832623997442667569L;
    private XMLContext context = null;
    private ViewFactory factory = null;
    private JEditorPane editor = null;
    private boolean lineWrapping = false;
    private boolean wrapStyleWord = false;
    private XmlTextPane xmlTextPane;

    @Override
    public void install(JEditorPane c) {
        super.install(c);
        this.editor = c;
    }

    public XMLEditorKit(boolean lineWrapping, XmlTextPane xmlTextPane) {
        this.xmlTextPane = xmlTextPane;
        this.factory = new XMLViewFactory();
        this.context = new XMLContext();
        this.lineWrapping = lineWrapping;
    }

    public boolean isLineWrapping() {
        return this.lineWrapping;
    }

    public void setLineWrappingEnabled(boolean enabled) {
        this.lineWrapping = enabled;
    }

    public boolean isWrapStyleWord() {
        return this.wrapStyleWord;
    }

    public void setWrapStyleWord(boolean enabled) {
        this.wrapStyleWord = enabled;
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public final ViewFactory getViewFactory() {
        return this.factory;
    }

    public void setStyle(String name, Color foreground, int fontStyle) {
        this.context.setStyle(name, foreground, fontStyle);
    }

    @Override
    public Document createDefaultDocument() {
        return new XMLDocument(this.editor);
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        doc.putProperty("loading", Boolean.TRUE);
        super.read(in, doc, pos);
        doc.putProperty("loading", Boolean.FALSE);
    }

    @Override
    public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
        doc.putProperty("loading", Boolean.TRUE);
        super.read(in, doc, pos);
        doc.putProperty("loading", Boolean.FALSE);
    }

    class XMLViewFactory
    implements ViewFactory {
        XMLViewFactory() {
        }

        @Override
        public View create(Element elem) {
            if (XMLEditorKit.this.lineWrapping) {
                try {
                    return new WrappedXMLView(XMLEditorKit.this.context, elem, XMLEditorKit.this.wrapStyleWord);
                }
                catch (IOException e) {
                }
            } else {
                try {
                    return new XMLView(XMLEditorKit.this.context, elem, XMLEditorKit.this.xmlTextPane);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

