/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BufferedTokenStream
extends TokenFilter {
    private final LinkedList<Token> inQueue = new LinkedList();
    private final LinkedList<Token> outQueue = new LinkedList();

    public BufferedTokenStream(TokenStream input) {
        super(input);
    }

    protected abstract Token process(Token var1) throws IOException;

    public final Token next() throws IOException {
        Token t;
        Token out;
        do {
            if (!this.outQueue.isEmpty()) {
                return this.outQueue.removeFirst();
            }
            t = this.read();
            if (null != t) continue;
            return null;
        } while (null == (out = this.process(t)));
        return out;
    }

    protected Token read() throws IOException {
        if (this.inQueue.isEmpty()) {
            Token t = this.input.next();
            return t;
        }
        return this.inQueue.removeFirst();
    }

    protected void pushBack(Token t) {
        this.inQueue.addFirst(t);
    }

    protected Token peek(int n) throws IOException {
        int fillCount = n - this.inQueue.size();
        for (int i = 0; i < fillCount; ++i) {
            Token t = this.input.next();
            if (null == t) {
                return null;
            }
            this.inQueue.addLast(t);
        }
        return this.inQueue.get(n - 1);
    }

    protected void write(Token t) {
        this.outQueue.addLast(t);
    }

    protected Iterable<Token> output() {
        return this.outQueue;
    }

    public void reset() throws IOException {
        super.reset();
        this.inQueue.clear();
        this.outQueue.clear();
    }
}

