/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.search;

import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.FilterListQueryHandler;
import com.jurismarches.vradi.services.search.LuceneQueryParser;
import com.jurismarches.vradi.services.search.QueryHandler;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class VradiQueryParser {
    private static final Log log = LogFactory.getLog(VradiQueryParser.class);
    public static final String DEFAULT_FIELD = "text";

    public static FilterList parse(String expression) throws UnsupportedQueryException {
        return VradiQueryParser.parse(expression, DEFAULT_FIELD);
    }

    public static FilterList parse(String expression, String defaultField) throws UnsupportedQueryException {
        FilterListQueryHandler queryHandler = new FilterListQueryHandler();
        VradiQueryParser.parse(queryHandler, expression, defaultField);
        FilterList filterList = queryHandler.getFilterList();
        return filterList;
    }

    static void parse(QueryHandler queryHandler, String expression, String defaultField) throws UnsupportedQueryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("expression: " + expression));
        }
        WhitespaceAnalyzer analyzer = new WhitespaceAnalyzer();
        QueryParser parser = new QueryParser(Version.LUCENE_29, defaultField, (Analyzer)analyzer);
        parser.setAllowLeadingWildcard(true);
        parser.setDefaultOperator(QueryParser.Operator.AND);
        if (expression == null || expression.trim().isEmpty()) {
            expression = defaultField + ":*";
        }
        try {
            Query query = parser.parse(expression.trim());
            LuceneQueryParser luceneQueryParser = new LuceneQueryParser(queryHandler);
            luceneQueryParser.parse(query);
        }
        catch (ParseException e) {
            throw new UnsupportedQueryException(expression, e);
        }
    }
}

