/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiServiceConfigurationHelper;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.ooo.SingletonOOo;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.ExternalUriReferenceTranslator;
import com.sun.star.uri.XExternalUriReferenceTranslator;
import com.sun.star.util.XRefreshable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;

public class TemplateManager {
    private static final Log log = LogFactory.getLog(TemplateManager.class);
    protected ApplicationConfig config;
    protected XComponentContext context = null;
    protected XComponentLoader loader = null;
    protected XComponent document = null;
    public static final int IMAGE_UNKNOWN = -1;
    public static final int IMAGE_JPEG = 0;
    public static final int IMAGE_PNG = 1;
    public static final int IMAGE_GIF = 2;
    protected static final String USER_TEXT_FIELD_PREFIX = "com.sun.star.text.fieldmaster.User.";

    public TemplateManager(ApplicationConfig config, File templateFile) throws VradiException {
        this.config = config;
        this.initOpenOfficeContext();
        this.document = this.createDoc(templateFile);
    }

    protected void initOpenOfficeContext() throws VradiException {
        try {
            String oOoExecFolder = VradiServiceConfigurationHelper.getOpenOfficeExecDir(this.config);
            this.context = SingletonOOo.GetInstance(oOoExecFolder).getXContext();
            this.loader = SingletonOOo.GetInstance(oOoExecFolder).getLoader();
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't init openoffice bootstrap", (Throwable)ex);
            }
            throw new VradiException("Can't init openoffice bootstrap", ex);
        }
    }

    public XComponent createDoc(File templateFile) throws VradiException {
        try {
            ArrayList<PropertyValue> props = new ArrayList<PropertyValue>();
            PropertyValue p1 = new PropertyValue();
            p1.Name = "AsTemplate";
            p1.Value = Boolean.TRUE;
            props.add(p1);
            PropertyValue p2 = new PropertyValue();
            p2.Name = "Hidden";
            p2.Value = Boolean.TRUE;
            props.add(p2);
            PropertyValue[] properties = new PropertyValue[props.size()];
            properties = props.toArray(properties);
            String templateFileURL = this.createUNOFileURL(templateFile);
            this.document = this.loader.loadComponentFromURL(templateFileURL, "_blank", 0, properties);
            return this.document;
        }
        catch (Exception e) {
            throw new VradiException("Can't create document. File " + templateFile + " can also not exist or not be read !", e);
        }
    }

    public void generateDoc(String targetFileName, Map<String, Object> myValues, String ... imagesUrls) throws VradiException {
        this.fillFields(myValues);
        for (String imageUrl : imagesUrls) {
            this.insertImageInEndOfDocument(imageUrl);
        }
        this.storeDocComponent(this.document, targetFileName);
    }

    public void storeDocComponent(XComponent xDoc, String storeUrl) throws VradiException {
        try {
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xDoc);
            storeUrl = this.createUNOFileURL(new File(storeUrl));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing pdf file to " + storeUrl));
            }
            PropertyValue[] storeProps = new PropertyValue[2];
            storeProps[0] = new PropertyValue();
            storeProps[0].Name = "FilterName";
            storeProps[0].Value = "writer_pdf_Export";
            storeProps[1] = new PropertyValue();
            storeProps[1].Name = "Overwrite";
            storeProps[1].Value = Boolean.TRUE;
            xStorable.storeToURL(storeUrl, storeProps);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't export template as PDF", (Throwable)eee);
            }
            throw new VradiException("Can't export template as PDF", eee);
        }
    }

    protected String createUNOFileURL(File file) throws VradiException {
        String internalURL;
        try {
            URL before = file.toURI().toURL();
            XExternalUriReferenceTranslator translator = ExternalUriReferenceTranslator.create((XComponentContext)this.context);
            internalURL = translator.translateToInternal(before.toExternalForm());
        }
        catch (MalformedURLException eee) {
            throw new VradiException("Can't convert url", eee);
        }
        return internalURL;
    }

    protected void fillFields(Map<String, Object> myValues) throws VradiException {
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.document);
            XNameAccess xNamedFieldMasters = xTextFieldsSupplier.getTextFieldMasters();
            XEnumerationAccess xEnumeratedFields = xTextFieldsSupplier.getTextFields();
            String[] allFieldNames = xNamedFieldMasters.getElementNames();
            String[] fieldNames = new String[allFieldNames.length];
            XPropertySet[] xPropertySets = new XPropertySet[allFieldNames.length];
            int fieldCount = 0;
            for (String allFieldName : allFieldNames) {
                String shortFieldName;
                if (!allFieldName.toLowerCase().startsWith(USER_TEXT_FIELD_PREFIX.toLowerCase())) continue;
                fieldNames[fieldCount] = shortFieldName = allFieldName.substring(USER_TEXT_FIELD_PREFIX.length());
                Object fieldMaster = xNamedFieldMasters.getByName(allFieldName);
                xPropertySets[fieldCount] = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)fieldMaster);
                ++fieldCount;
            }
            XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xEnumeratedFields);
            for (int i = 0; i < fieldCount; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Replacing " + fieldNames[i] + " with " + myValues.get(fieldNames[i])));
                }
                xPropertySets[i].setPropertyValue("Content", myValues.get(fieldNames[i]));
                if (!log.isDebugEnabled() || myValues.get(fieldNames[i]) != null) continue;
                log.debug((Object)("Field " + fieldNames[i] + " could not be found"));
            }
            xRefreshable.refresh();
        }
        catch (Exception eee) {
            throw new VradiException("Can't replace template fields", eee);
        }
    }

    protected void insertImageInEndOfDocument(String imageUrl) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Insert image at end of document : " + imageUrl));
        }
        try {
            BufferedImage image = ImageIO.read(new URL(imageUrl));
            int width = image.getWidth();
            int height = image.getHeight();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Image size : " + width + "*" + height));
            }
            XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.document);
            XTextRange xStart = xTextDocument.getText().getStart();
            XTextCursor xCursor = xStart.getText().createTextCursorByRange(xStart);
            XMultiServiceFactory xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDocument);
            XTextContent xImage = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xMSFDoc.createInstance("com.sun.star.text.TextGraphicObject"));
            XText xText = xCursor.getText();
            xText.insertControlCharacter(xText.getEnd(), (short)5, false);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xImage);
            xProps.setPropertyValue("AnchorType", (Object)TextContentAnchorType.AT_PARAGRAPH);
            xProps.setPropertyValue("GraphicURL", (Object)imageUrl);
            xProps.setPropertyValue("Print", (Object)true);
            xProps.setPropertyValue("Width", (Object)(width * 15));
            xProps.setPropertyValue("Height", (Object)(height * 15));
            xProps.setPropertyValue("TopMargin", (Object)(height * 15));
            xText.insertTextContent(xText.getEnd(), xImage, false);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't insert image", (Throwable)eee);
            }
            throw new VradiException("Can't insert image", eee);
        }
    }

    public List<String> getDocumentFields() {
        XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.document);
        XNameAccess xNamedFieldMasters = xTextFieldsSupplier.getTextFieldMasters();
        String[] allFieldNames = xNamedFieldMasters.getElementNames();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String allFieldName : allFieldNames) {
            if (!allFieldName.toLowerCase().startsWith(USER_TEXT_FIELD_PREFIX.toLowerCase())) continue;
            String shortFieldName = allFieldName.substring(USER_TEXT_FIELD_PREFIX.length());
            fieldNames.add(shortFieldName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found field in document : " + fieldNames));
        }
        return fieldNames;
    }
}

