/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.VradiServiceConfigurationHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;

public class VradiServiceAction {
    private static final Log log = LogFactory.getLog(VradiServiceAction.class);

    public void help() {
        System.out.println("Usage: vradi-services [-h]");
        System.out.println("Options (set with --option <key> <value>) :");
        for (VradiServiceConfiguration.VradiServiceOption vradiServiceOption : VradiServiceConfiguration.VradiServiceOption.values()) {
            System.out.println("\t" + vradiServiceOption.key + "(" + vradiServiceOption.defaultValue + ") : " + vradiServiceOption.description);
        }
        System.out.println("Actions:");
        for (Enum enum_ : VradiServiceConfiguration.VradiServiceActionDef.values()) {
            System.out.println("\t" + Arrays.toString(((VradiServiceConfiguration.VradiServiceActionDef)enum_).getAliases()) + "(" + ((VradiServiceConfiguration.VradiServiceActionDef)enum_).getAction() + ") : " + ((VradiServiceConfiguration.VradiServiceActionDef)enum_).getDescription());
        }
        System.exit(0);
    }

    public static void reIndexSolr() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting reIndex solr");
        }
        long startingTime = System.nanoTime();
        ServiceFactory.getWikittyProxy().syncSearchEngine();
        if (log.isInfoEnabled()) {
            log.info((Object)("ReIndex solr is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        }
        System.exit(0);
    }

    public static void deleteObseleteThesaurus() {
        log.info((Object)"Starting deleting obselete thesaurus");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Thesaurus").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List thesauruses = proxy.findAllByCriteria(Thesaurus.class, criteria).getAll();
        for (Thesaurus thesaurus : thesauruses) {
            String parentId = thesaurus.getParent();
            if (parentId == null) {
                proxy.delete(thesaurus.getWikittyId());
                log.info((Object)("Found thesaurus '" + thesaurus.getName() + "' has no parentId, deleting this"));
                continue;
            }
            Thesaurus parent = (Thesaurus)proxy.restore(Thesaurus.class, parentId);
            if (parent != null) continue;
            proxy.delete(thesaurus.getWikittyId());
            log.info((Object)("Found thesaurus '" + thesaurus.getName() + "' has no parent with id '" + parentId + ", deleting this"));
        }
        log.info((Object)("Deleting obselete thesaurus is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void reinitStatus() {
        log.info((Object)"Starting reinit status");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Status").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List statuses = proxy.findAllByCriteria(Status.class, criteria).getAll();
        ArrayList<String> statusesIds = new ArrayList<String>();
        for (Status status : statuses) {
            statusesIds.add(status.getWikittyId());
            log.info((Object)("Deleting status " + status.getName()));
        }
        proxy.delete(statusesIds);
        try {
            ServiceFactory.getVradiStorageService().createDefaultStatuses();
        }
        catch (VradiException eee) {
            log.error((Object)eee);
        }
        log.info((Object)("reinit status is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void forceAllOldUserEnable() {
        User user;
        log.info((Object)"Starting forcing all user enabled");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "User").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List users = proxy.findAllByCriteria(User.class, criteria).getAll();
        Iterator i$ = users.iterator();
        while (i$.hasNext() && (user = (User)i$.next()) != null) {
            Object field = user.getField("User", "enable");
            if (field != null) continue;
            log.info((Object)("Found user '" + user.getName() + "' with no enable"));
            user.setField("User", "enable", true);
            proxy.store((BusinessEntity)user);
        }
        log.info((Object)("Forcing all user enabled is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void deleteObseleteUsers() {
        User user;
        log.info((Object)"Starting obselete user deletion");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "User").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List users = proxy.findAllByCriteria(User.class, criteria).getAll();
        Iterator i$ = users.iterator();
        while (i$.hasNext() && (user = (User)i$.next()) != null) {
            String clientId = user.getClient();
            if (clientId == null) {
                log.info((Object)("Deleting user " + user.getName() + " with no client attached"));
                proxy.delete(user.getWikittyId());
                continue;
            }
            Client client = (Client)proxy.restore(Client.class, clientId);
            if (client != null) continue;
            log.info((Object)("Deleting user " + user.getName() + " with no client attached"));
            proxy.delete(user.getWikittyId());
        }
        log.info((Object)("Forcing all user enabled is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void importFiles() {
        File[] files;
        log.info((Object)"Starting import files");
        long startingTime = System.nanoTime();
        File importCSVDir = VradiServiceConfigurationHelper.getImportCSVDir(VradiServiceAction.getConfig());
        if (importCSVDir == null) {
            log.error((Object)"No import csv dir found, abording");
            System.exit(0);
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(".+\\.csv");
            }
        };
        for (File f : files = importCSVDir.listFiles(filter)) {
            String uri = f.toURI().toString();
            try {
                log.info((Object)("Start import file " + uri));
                ServiceFactory.getVradiStorageService().importAsCSV(uri);
            }
            catch (VradiException eee) {
                log.error((Object)("failled to import file : " + uri), (Throwable)eee);
            }
        }
        log.info((Object)("Import files is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void exportClients() {
        log.info((Object)"Starting export clients");
        long startingTime = System.nanoTime();
        File exportCSVDir = VradiServiceConfigurationHelper.getExportCSVDir(VradiServiceAction.getConfig());
        if (exportCSVDir == null) {
            log.error((Object)"No export csv dir found, abording");
            System.exit(0);
        }
        VradiStorageService vradiStorageService = ServiceFactory.getVradiStorageService();
        String vscContent = null;
        try {
            vscContent = vradiStorageService.exportClientDB();
        }
        catch (VradiException eee) {
            log.error((Object)"failled to export clients", (Throwable)eee);
            System.exit(0);
        }
        String fileName = "exportClient" + startingTime + ".csv";
        try {
            FileUtils.writeStringToFile((File)new File(exportCSVDir, fileName), (String)vscContent);
        }
        catch (IOException eee) {
            log.error((Object)("failled to write file : " + fileName), (Throwable)eee);
        }
        log.info((Object)("Export clients is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void exportThesaurus() {
        log.info((Object)"Starting export thesaurus");
        long startingTime = System.nanoTime();
        File exportCSVDir = VradiServiceConfigurationHelper.getExportCSVDir(VradiServiceAction.getConfig());
        if (exportCSVDir == null) {
            log.error((Object)"No export csv dir found, abording");
            System.exit(0);
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "WikittyTreeNode");
        Criteria criteria = search.criteria();
        VradiStorageService vradiStorageService = ServiceFactory.getVradiStorageService();
        String vscContent = null;
        try {
            vscContent = vradiStorageService.exportAsCSV(criteria);
        }
        catch (VradiException eee) {
            log.error((Object)"failled to export thesaurus", (Throwable)eee);
            System.exit(0);
        }
        String fileName = "exportThesaurus" + startingTime + ".csv";
        try {
            FileUtils.writeStringToFile((File)new File(exportCSVDir, fileName), (String)vscContent);
        }
        catch (IOException eee) {
            log.error((Object)("failled to write file : " + fileName), (Throwable)eee);
        }
        log.info((Object)("Export thesaurus is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    protected static ApplicationConfig getConfig() {
        return VradiServiceConfiguration.getInstance(new String[0]);
    }
}

