/*
 * #%L
 * Vradi :: Services
 * *
 * $Id: SendingHelper.java 1848 2010-12-22 16:16:54Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-services/src/main/java/com/jurismarches/vradi/beans/SendingHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.beans;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupForms;
import com.jurismarches.vradi.entities.GroupFormsImpl;
import com.jurismarches.vradi.entities.Sending;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author letellier
 */
public class SendingHelper {

    public static GroupForms createGroupForms(Group group, String formId) {
        Set<String> forms = new HashSet<String>();
        forms.add(formId);
        return createGroupForms(group, forms);
    }

    public static GroupForms createGroupForms(Group group, Set<Form> forms) {
        Set<String> formIds = new HashSet<String>();
        for (Form f : forms) {
            formIds.add(f.getWikittyId());
        }
        return createGroupForms(group, formIds);
    }

    public static GroupForms createGroupForms(Group group, Collection<String> formsId) {
        return createGroupForms(group == null ? null : group.getWikittyId(), formsId);
    }

    public static GroupForms createGroupForms(String groupId, Collection<String> formsId) {

        GroupForms groupFormCreated = new GroupFormsImpl();

        if (groupId != null) {
            groupFormCreated.setGroup(groupId);
        }

        if (formsId != null) {
            for (String formId : formsId) {
                groupFormCreated.addForm(formId);
            }
        }
        return groupFormCreated;
    }

    public static Set<String> extractForms(WikittyProxy wikittyProxy, Collection<String> groupFormIds) {
        Set<String> result = new HashSet<String>();

        if (groupFormIds != null) {
            List<GroupForms> groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormIds));
            for (GroupForms groupForm : groupForms) {
                result.addAll(extractForms(groupForm));
            }
        }
        return result;
    }

    public static Set<String> extractForms(WikittyProxy wikittyProxy, String groupFormId) {

        GroupForms groupForms = wikittyProxy.restore(GroupForms.class, groupFormId);
        return extractForms(groupForms);
    }

    public static Set<String> extractForms(GroupForms groupForm) {
        Set<String> result = new HashSet<String>();

        if (groupForm != null) {
            Set<String> idsSet = groupForm.getForm();
            if (idsSet != null) {
                result.addAll(idsSet);
            }
        }
        return result;
    }

    public static Sending findSendingCorrespondingGroupForm(WikittyProxy wikittyProxy, String wikittyId) {
        
        Search searchOr = Search.query().or();
        searchOr.contains(Sending.FQ_FIELD_SENDING_GROUPFORMS, wikittyId);
        searchOr.contains(Sending.FQ_FIELD_SENDING_DELETEDGROUPFORMS, wikittyId);

        return wikittyProxy.findByCriteria(Sending.class, searchOr.criteria());
    }
}
