/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ReflectUtil {
    private static Log log = LogFactory.getLog(ReflectUtil.class);

    public static boolean isConstantField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static <T> List<T> getConstants(Class<?> klass, Class<T> searchingClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Field field : klass.getDeclaredFields()) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (!searchingClass.isAssignableFrom(field.getType()) || !ReflectUtil.isConstantField(field)) continue;
            try {
                result.add(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Class<?> superClass = klass.getSuperclass();
        if (superClass != null) {
            result.addAll(ReflectUtil.getConstants(superClass, searchingClass));
        }
        return result;
    }

    public static <T> T getConstant(Class<?> klass, String fieldName) {
        try {
            Object result = null;
            Field f = klass.getDeclaredField(fieldName);
            if (ReflectUtil.isConstantField(f)) {
                f.setAccessible(true);
                result = f.get(null);
            }
            return (T)result;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Enum<T>> Class<T> getEnumClass(Class<?> type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(I18n._((String)"nuitonutil.error.null.parameter", (Object[])new Object[]{"type"}));
        }
        if (!type.isEnum()) {
            throw new IllegalArgumentException(I18n._((String)"nuitonutil.error.not.an.enum", (Object[])new Object[]{type}));
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getDeclaredMethod(Class<?> klass, String methodName, boolean strict, Object ... arguments) throws IllegalArgumentException {
        Method method;
        HashSet classes = new HashSet();
        try {
            method = ReflectUtil.getDeclaredMethod(klass, methodName, classes, arguments);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inspected classes : " + classes));
            }
            classes.clear();
        }
        if (method == null && strict) {
            throw new IllegalArgumentException("could not find method " + methodName + " on type " + klass.getName());
        }
        return method;
    }

    public static Class<?> boxType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        if (Void.TYPE.equals(type)) {
            return Void.class;
        }
        return type;
    }

    public static Class<?> unboxType(Class<?> type) {
        if (type.isPrimitive()) {
            return type;
        }
        if (Boolean.class.equals(type)) {
            return Boolean.TYPE;
        }
        if (Character.class.equals(type)) {
            return Character.TYPE;
        }
        if (Byte.class.equals(type)) {
            return Byte.TYPE;
        }
        if (Short.class.equals(type)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(type)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(type)) {
            return Long.TYPE;
        }
        if (Float.class.equals(type)) {
            return Float.TYPE;
        }
        if (Double.class.equals(type)) {
            return Double.TYPE;
        }
        if (Void.class.equals(type)) {
            return Void.TYPE;
        }
        return type;
    }

    protected static Method getDeclaredMethod(Class<?> klass, String methodName, Set<Class<?>> visitedClasses, Object ... arguments) {
        if (visitedClasses.contains(klass)) {
            return null;
        }
        visitedClasses.add(klass);
        Method method = null;
        for (Method m : klass.getDeclaredMethods()) {
            Class<?>[] types;
            if (!methodName.equals(m.getName()) || arguments.length != (types = m.getParameterTypes()).length) continue;
            Object[] prototype = m.getParameterTypes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a method with same parameters size : " + m.getName() + " : " + Arrays.toString(prototype)));
            }
            int index = 0;
            boolean parametersMatches = true;
            for (Object argument : arguments) {
                Class<?> type = prototype[index++];
                if (argument == null) continue;
                Class<?> runtimeType = argument.getClass();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Test parameter [" + (index - 1) + "] : " + type + " vs  " + runtimeType));
                }
                if ((type = ReflectUtil.boxType(type)).equals(runtimeType = ReflectUtil.boxType(runtimeType)) || type.isAssignableFrom(runtimeType)) continue;
                parametersMatches = false;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Types are not matching.");
                break;
            }
            if (!parametersMatches) break;
            method = m;
            break;
        }
        if (method == null && klass.getSuperclass() != null) {
            method = ReflectUtil.getDeclaredMethod(klass.getSuperclass(), methodName, visitedClasses, arguments);
        }
        if (method == null) {
            Class<?> anInterface;
            Class<?>[] interfaces;
            Class<?>[] arr$ = interfaces = klass.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (method = ReflectUtil.getDeclaredMethod(anInterface = arr$[i$], methodName, visitedClasses, arguments)) == null; ++i$) {
            }
        }
        return method;
    }
}

