/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XPatherException;

public class XPather {
    private String[] tokenArray;

    public XPather(String expression) {
        StringTokenizer tokenizer = new StringTokenizer(expression, "/()[]\"'=<>", true);
        int tokenCount = tokenizer.countTokens();
        this.tokenArray = new String[tokenCount];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            this.tokenArray[index++] = tokenizer.nextToken();
        }
    }

    public Object[] evaluateAgainstNode(TagNode node) throws XPatherException {
        if (node == null) {
            throw new XPatherException("Cannot evaluate XPath expression against null value!");
        }
        Collection collectionResult = this.evaluateAgainst(this.singleton(node), 0, this.tokenArray.length - 1, false, 1, 0, false, null);
        Object[] array = new Object[collectionResult.size()];
        Iterator iterator = collectionResult.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            array[index++] = iterator.next();
        }
        return array;
    }

    private void throwStandardException() throws XPatherException {
        throw new XPatherException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection evaluateAgainst(Collection object, int from, int to, boolean isRecursive, int position, int last, boolean isFilterContext, Collection filterSource) throws XPatherException {
        if (from < 0 || to >= this.tokenArray.length || from > to) return object;
        if ("".equals(this.tokenArray[from].trim())) {
            return this.evaluateAgainst(object, from + 1, to, isRecursive, position, last, isFilterContext, filterSource);
        }
        if (this.isToken("(", from)) {
            int closingBracket = this.findClosingIndex(from, to);
            if (closingBracket > 0) {
                Collection value = this.evaluateAgainst(object, from + 1, closingBracket - 1, false, position, last, isFilterContext, filterSource);
                return this.evaluateAgainst(value, closingBracket + 1, to, false, position, last, isFilterContext, filterSource);
            }
            this.throwStandardException();
            throw new XPatherException();
        } else if (this.isToken("[", from)) {
            int closingBracket = this.findClosingIndex(from, to);
            if (closingBracket > 0 && object instanceof Collection) {
                Collection value = this.filterByCondition(object, from + 1, closingBracket - 1);
                return this.evaluateAgainst(value, closingBracket + 1, to, false, position, last, isFilterContext, filterSource);
            }
            this.throwStandardException();
            throw new XPatherException();
        } else if (this.isToken("\"", from) || this.isToken("'", from)) {
            int closingQuote = this.findClosingIndex(from, to);
            if (closingQuote > from) {
                Collection value = this.singleton(this.flatten(from + 1, closingQuote - 1));
                return this.evaluateAgainst(value, closingQuote + 1, to, false, position, last, isFilterContext, filterSource);
            }
            this.throwStandardException();
            throw new XPatherException();
        } else {
            if ((this.isToken("=", from) || this.isToken("<", from) || this.isToken(">", from)) && isFilterContext) {
                boolean logicValue;
                if (this.isToken("=", from + 1) && (this.isToken("<", from) || this.isToken(">", from))) {
                    Collection secondObject = this.evaluateAgainst(filterSource, from + 2, to, false, position, last, isFilterContext, filterSource);
                    logicValue = this.evaluateLogic(object, secondObject, this.tokenArray[from] + this.tokenArray[from + 1]);
                    return this.singleton(new Boolean(logicValue));
                } else {
                    Collection secondObject = this.evaluateAgainst(filterSource, from + 1, to, false, position, last, isFilterContext, filterSource);
                    logicValue = this.evaluateLogic(object, secondObject, this.tokenArray[from]);
                }
                return this.singleton(new Boolean(logicValue));
            }
            if (this.isToken("/", from)) {
                boolean goRecursive = this.isToken("/", from + 1);
                if (goRecursive) {
                    ++from;
                }
                if (from < to) {
                    int toIndex = this.findClosingIndex(from, to) - 1;
                    if (toIndex <= from) {
                        toIndex = to;
                    }
                    Collection value = this.evaluateAgainst(object, from + 1, toIndex, goRecursive, 1, last, isFilterContext, filterSource);
                    return this.evaluateAgainst(value, toIndex + 1, to, false, 1, last, isFilterContext, filterSource);
                }
                this.throwStandardException();
                throw new XPatherException();
            } else {
                if (this.isFunctionCall(from, to)) {
                    int closingBracketIndex = this.findClosingIndex(from + 1, to);
                    Collection funcValue = this.evaluateFunction(object, from, to, position, last, isFilterContext);
                    return this.evaluateAgainst(funcValue, closingBracketIndex + 1, to, false, 1, last, isFilterContext, filterSource);
                }
                if (this.isValidInteger(this.tokenArray[from])) {
                    Collection value = this.singleton(new Integer(this.tokenArray[from]));
                    return this.evaluateAgainst(value, from + 1, to, false, position, last, isFilterContext, filterSource);
                }
                if (!this.isValidDouble(this.tokenArray[from])) return this.getElementsByName(object, from, to, isRecursive, isFilterContext);
                Collection value = this.singleton(new Double(this.tokenArray[from]));
                return this.evaluateAgainst(value, from + 1, to, false, position, last, isFilterContext, filterSource);
            }
        }
    }

    private String flatten(int from, int to) {
        if (from <= to) {
            StringBuffer result = new StringBuffer();
            for (int i = from; i <= to; ++i) {
                result.append(this.tokenArray[i]);
            }
            return result.toString();
        }
        return "";
    }

    private boolean isValidInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isValidDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isIdentifier(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).length() > 0) {
            if (!Character.isLetter(s.charAt(0))) {
                return false;
            }
            for (int i = 1; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '_' || ch == '-' || Character.isLetterOrDigit(ch)) continue;
                return false;
            }
        }
        return false;
    }

    private boolean isFunctionCall(int from, int to) {
        if (!this.isIdentifier(this.tokenArray[from]) && !this.isToken("(", from + 1)) {
            return false;
        }
        return this.findClosingIndex(from + 1, to) > from + 1;
    }

    private Collection evaluateFunction(Collection source, int from, int to, int position, int last, boolean isFilterContext) throws XPatherException {
        String name = this.tokenArray[from].trim();
        ArrayList<Object> result = new ArrayList<Object>();
        int size = source.size();
        Iterator iterator = source.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Collection argumentEvaluated;
            Object curr = iterator.next();
            ++index;
            if ("last".equals(name)) {
                result.add(new Integer(isFilterContext ? last : size));
                continue;
            }
            if ("position".equals(name)) {
                result.add(new Integer(isFilterContext ? position : index));
                continue;
            }
            if ("text".equals(name)) {
                if (curr instanceof TagNode) {
                    result.add(((TagNode)curr).getText());
                    continue;
                }
                if (!(curr instanceof String)) continue;
                result.add(curr.toString());
                continue;
            }
            if ("count".equals(name)) {
                argumentEvaluated = this.evaluateAgainst(source, from + 2, to - 1, false, position, 0, isFilterContext, null);
                result.add(new Integer(argumentEvaluated.size()));
                continue;
            }
            if ("data".equals(name)) {
                argumentEvaluated = this.evaluateAgainst(source, from + 2, to - 1, false, position, 0, isFilterContext, null);
                Iterator it = argumentEvaluated.iterator();
                while (it.hasNext()) {
                    Object elem = it.next();
                    if (elem instanceof TagNode) {
                        result.add(((TagNode)elem).getText());
                        continue;
                    }
                    if (!(elem instanceof String)) continue;
                    result.add(elem.toString());
                }
                continue;
            }
            throw new XPatherException("Unknown function " + name + "!");
        }
        return result;
    }

    private Collection filterByCondition(Collection source, int from, int to) throws XPatherException {
        ArrayList result = new ArrayList();
        Iterator iterator = source.iterator();
        int index = 0;
        int size = source.size();
        while (iterator.hasNext()) {
            Object curr = iterator.next();
            ArrayList logicValueList = new ArrayList(this.evaluateAgainst(this.singleton(curr), from, to, false, ++index, size, true, this.singleton(curr)));
            if (logicValueList.size() < 1) continue;
            Object first = logicValueList.get(0);
            if (first instanceof Boolean) {
                if (!((Boolean)first).booleanValue()) continue;
                result.add(curr);
                continue;
            }
            if (first instanceof Integer) {
                if ((Integer)first != index) continue;
                result.add(curr);
                continue;
            }
            result.add(curr);
        }
        return result;
    }

    private boolean isToken(String token, int index) {
        int len = this.tokenArray.length;
        return index >= 0 && index < len && this.tokenArray[index].trim().equals(token.trim());
    }

    private int findClosingIndex(int from, int to) {
        block16: {
            String currToken;
            block18: {
                block17: {
                    if (from >= to) break block16;
                    currToken = this.tokenArray[from];
                    if (!"\"".equals(currToken)) break block17;
                    for (int i = from + 1; i <= to; ++i) {
                        if (!"\"".equals(this.tokenArray[i])) continue;
                        return i;
                    }
                    break block16;
                }
                if (!"'".equals(currToken)) break block18;
                for (int i = from + 1; i <= to; ++i) {
                    if (!"'".equals(this.tokenArray[i])) continue;
                    return i;
                }
                break block16;
            }
            if (!"(".equals(currToken) && !"[".equals(currToken) && !"/".equals(currToken)) break block16;
            boolean isQuoteClosed = true;
            boolean isAposClosed = true;
            int brackets = "(".equals(currToken) ? 1 : 0;
            int angleBrackets = "[".equals(currToken) ? 1 : 0;
            int slashes = "/".equals(currToken) ? 1 : 0;
            for (int i = from + 1; i <= to; ++i) {
                if ("\"".equals(this.tokenArray[i])) {
                    isQuoteClosed = !isQuoteClosed;
                } else if ("'".equals(this.tokenArray[i])) {
                    isAposClosed = !isAposClosed;
                } else if ("(".equals(this.tokenArray[i]) && isQuoteClosed && isAposClosed) {
                    ++brackets;
                } else if (")".equals(this.tokenArray[i]) && isQuoteClosed && isAposClosed) {
                    --brackets;
                } else if ("[".equals(this.tokenArray[i]) && isQuoteClosed && isAposClosed) {
                    ++angleBrackets;
                } else if ("]".equals(this.tokenArray[i]) && isQuoteClosed && isAposClosed) {
                    --angleBrackets;
                } else if ("/".equals(this.tokenArray[i]) && isQuoteClosed && isAposClosed && brackets == 0 && angleBrackets == 0) {
                    --slashes;
                }
                if (!isQuoteClosed || !isAposClosed || brackets != 0 || angleBrackets != 0 || slashes != 0) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean isAtt(String token) {
        return token != null && token.length() > 1 && token.startsWith("@");
    }

    private Collection singleton(Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(element);
        return result;
    }

    private Collection getElementsByName(Collection source, int from, int to, boolean isRecursive, boolean isFilterContext) throws XPatherException {
        String name = this.tokenArray[from].trim();
        if (this.isAtt(name)) {
            TagNode node;
            Object next;
            Iterator iterator;
            LinkedHashSet nodes;
            name = name.substring(1);
            ArrayList result = new ArrayList();
            if (isRecursive) {
                nodes = new LinkedHashSet();
                iterator = source.iterator();
                while (iterator.hasNext()) {
                    next = iterator.next();
                    if (!(next instanceof TagNode)) continue;
                    node = (TagNode)next;
                    nodes.addAll(node.getAllElementsList(true));
                }
            } else {
                nodes = source;
            }
            iterator = nodes.iterator();
            while (iterator.hasNext()) {
                next = iterator.next();
                if (next instanceof TagNode) {
                    node = (TagNode)next;
                    if ("*".equals(name)) {
                        result.addAll(this.evaluateAgainst(node.getAttributes().values(), from + 1, to, false, 1, 1, isFilterContext, null));
                        continue;
                    }
                    String attValue = node.getAttributeByName(name);
                    if (attValue == null) continue;
                    result.addAll(this.evaluateAgainst(this.singleton(attValue), from + 1, to, false, 1, 1, isFilterContext, null));
                    continue;
                }
                this.throwStandardException();
            }
            return result;
        }
        LinkedHashSet<TagNode> result = new LinkedHashSet<TagNode>();
        Iterator iterator = source.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof TagNode) {
                TagNode parent;
                TagNode node = (TagNode)next;
                ++index;
                boolean isSelf = ".".equals(name);
                boolean isParent = "..".equals(name);
                boolean isAll = "*".equals(name);
                Collection subnodes = isSelf ? this.singleton(node) : (isParent ? ((parent = node.getParent()) != null ? this.singleton(parent) : new ArrayList()) : (isAll ? node.getChildTagList() : node.getElementListByName(name, false)));
                LinkedHashSet nodeSet = new LinkedHashSet(subnodes);
                Collection refinedSubnodes = this.evaluateAgainst(nodeSet, from + 1, to, false, index, nodeSet.size(), isFilterContext, null);
                if (isRecursive) {
                    List childTags = node.getChildTagList();
                    if (isSelf || isParent || isAll) {
                        result.addAll(refinedSubnodes);
                    }
                    Iterator childIterator = childTags.iterator();
                    while (childIterator.hasNext()) {
                        TagNode childTag = (TagNode)childIterator.next();
                        Collection childrenByName = this.getElementsByName(this.singleton(childTag), from, to, isRecursive, isFilterContext);
                        if (!isSelf && !isParent && !isAll && refinedSubnodes.contains(childTag)) {
                            result.add(childTag);
                        }
                        result.addAll(childrenByName);
                    }
                    continue;
                }
                result.addAll(refinedSubnodes);
                continue;
            }
            this.throwStandardException();
        }
        return result;
    }

    private boolean evaluateLogic(Collection first, Collection second, String logicOperator) {
        if (first == null || first.size() == 0 || second == null || second.size() == 0) {
            return false;
        }
        Object elem1 = first.iterator().next();
        Object elem2 = second.iterator().next();
        if (elem1 instanceof Number && elem2 instanceof Number) {
            double d1 = ((Number)elem1).doubleValue();
            double d2 = ((Number)elem2).doubleValue();
            if ("=".equals(logicOperator)) {
                return d1 == d2;
            }
            if ("<".equals(logicOperator)) {
                return d1 < d2;
            }
            if (">".equals(logicOperator)) {
                return d1 > d2;
            }
            if ("<=".equals(logicOperator)) {
                return d1 <= d2;
            }
            if (">=".equals(logicOperator)) {
                return d1 >= d2;
            }
        } else {
            String s1 = this.toText(elem1);
            String s2 = this.toText(elem2);
            int result = s1.compareTo(s2);
            if ("=".equals(logicOperator)) {
                return result == 0;
            }
            if ("<".equals(logicOperator)) {
                return result < 0;
            }
            if (">".equals(logicOperator)) {
                return result > 0;
            }
            if ("<=".equals(logicOperator)) {
                return result <= 0;
            }
            if (">=".equals(logicOperator)) {
                return result >= 0;
            }
        }
        return false;
    }

    private String toText(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof TagNode) {
            return ((TagNode)o).getText().toString();
        }
        return o.toString();
    }
}

