/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class StaxBridge
implements PullProvider,
SaxonLocator {
    private XMLStreamReader reader;
    private StaxAttributes attributes = new StaxAttributes();
    private StaxNamespaces namespaces = new StaxNamespaces();
    private PipelineConfiguration pipe;
    int currentEvent = 0;
    int depth = 0;

    public void setInputStream(String string, InputStream inputStream) throws XPathException {
        try {
            XMLStreamReader xMLStreamReader;
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            xMLInputFactory.setXMLReporter(new StaxErrorReporter());
            this.reader = xMLStreamReader = xMLInputFactory.createXMLStreamReader(string, inputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DynamicError(xMLStreamException);
        }
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = new PipelineConfiguration(pipelineConfiguration);
        this.pipe.setLocationProvider(this);
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.reader;
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public int next() throws XPathException {
        if (this.currentEvent == 0) {
            this.currentEvent = 2;
            return this.currentEvent;
        }
        if (this.currentEvent == -1 || this.currentEvent == 3) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            return -1;
        }
        try {
            if (this.reader.hasNext()) {
                int n = this.reader.next();
                this.currentEvent = this.translate(n);
            } else {
                this.currentEvent = -1;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            int n;
            String string = xMLStreamException.getMessage();
            if (string.startsWith("ParseError at") && (n = string.indexOf("\nMessage: ")) > 0) {
                string = string.substring(n + 10);
            }
            DynamicError dynamicError = new DynamicError("Error reported by XML parser: " + string);
            dynamicError.setErrorCode("SXXP0003");
            dynamicError.setLocator(this.translateLocation(xMLStreamException.getLocation()));
            throw dynamicError;
        }
        return this.currentEvent;
    }

    private int translate(int n) throws XPathException {
        switch (n) {
            case 10: {
                return 6;
            }
            case 12: {
                return 8;
            }
            case 4: {
                if (this.depth == 0) {
                    return this.next();
                }
                return 8;
            }
            case 5: {
                return 9;
            }
            case 11: {
                return this.next();
            }
            case 8: {
                return 3;
            }
            case 2: {
                --this.depth;
                return 5;
            }
            case 15: {
                return this.next();
            }
            case 9: {
                return this.next();
            }
            case 13: {
                return 7;
            }
            case 14: {
                return this.next();
            }
            case 3: {
                return 10;
            }
            case 6: {
                if (this.depth == 0) {
                    return this.next();
                }
                return 8;
            }
            case 7: {
                return this.next();
            }
            case 1: {
                ++this.depth;
                return 4;
            }
        }
        throw new IllegalStateException("Unknown StAX event " + n);
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        return this.attributes;
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        return this.namespaces;
    }

    public int skipToMatchingEnd() throws XPathException {
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 4: {
                try {
                    int n = 0;
                    while (this.reader.hasNext()) {
                        int n2 = this.reader.next();
                        if (n2 == 1) {
                            ++n;
                            continue;
                        }
                        if (n2 != 2 || n-- != 0) continue;
                        this.currentEvent = 5;
                        return this.currentEvent;
                    }
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new DynamicError(xMLStreamException);
                }
                throw new IllegalStateException("Element start has no matching element end");
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public int getNameCode() {
        if (this.currentEvent == 4 || this.currentEvent == 5) {
            String string = this.reader.getLocalName();
            String string2 = this.reader.getNamespaceURI();
            String string3 = this.reader.getPrefix();
            if (string3 == null) {
                string3 = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return this.getNamePool().allocate(string3, string2, string);
        }
        if (this.currentEvent == 10) {
            String string = this.reader.getPITarget();
            return this.getNamePool().allocate("", "", string);
        }
        throw new IllegalStateException();
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public CharSequence getStringValue() throws XPathException {
        switch (this.currentEvent) {
            case 8: {
                CharSlice charSlice = new CharSlice(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                return CompressedWhitespace.compress(charSlice);
            }
            case 9: {
                return new CharSlice(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            }
            case 10: {
                String string = this.reader.getPIData();
                if (string.length() > 0 && string.charAt(0) == ' ') {
                    return string.substring(1);
                }
                return string;
            }
            case 4: {
                FastStringBuffer fastStringBuffer = null;
                try {
                    int n = 0;
                    while (this.reader.hasNext()) {
                        int n2 = this.reader.next();
                        if (n2 == 4) {
                            if (fastStringBuffer == null) {
                                fastStringBuffer = new FastStringBuffer(1024);
                            }
                            fastStringBuffer.append(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                            continue;
                        }
                        if (n2 == 1) {
                            ++n;
                            continue;
                        }
                        if (n2 != 2 || n-- != 0) continue;
                        this.currentEvent = 5;
                        if (fastStringBuffer != null) {
                            return fastStringBuffer.condense();
                        }
                        return "";
                    }
                    break;
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new DynamicError(xMLStreamException);
                }
            }
        }
        throw new IllegalStateException("getStringValue() called when current event is " + this.currentEvent);
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public int getLocationId() {
        return 0;
    }

    public int getTypeAnnotation() {
        return -1;
    }

    public SourceLocator getSourceLocator() {
        return this.translateLocation(this.reader.getLocation());
    }

    private ExpressionLocation translateLocation(Location location) {
        ExpressionLocation expressionLocation = new ExpressionLocation();
        expressionLocation.setLineNumber(location.getLineNumber());
        expressionLocation.setColumnNumber(location.getColumnNumber());
        expressionLocation.setSystemId(location.getSystemId());
        expressionLocation.setPublicId(location.getPublicId());
        return expressionLocation;
    }

    public String getPublicId() {
        return this.reader.getLocation().getPublicId();
    }

    public String getSystemId() {
        return this.reader.getLocation().getSystemId();
    }

    public int getLineNumber() {
        return this.reader.getLocation().getLineNumber();
    }

    public int getColumnNumber() {
        return this.reader.getLocation().getColumnNumber();
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < 1; ++i) {
            long l = System.currentTimeMillis();
            PipelineConfiguration pipelineConfiguration = new Configuration().makePipelineConfiguration();
            StaxBridge staxBridge = new StaxBridge();
            File file = new File(stringArray[0]);
            staxBridge.setInputStream(file.toURI().toString(), new FileInputStream(file));
            XMLEmitter xMLEmitter = new XMLEmitter();
            xMLEmitter.setPipelineConfiguration(pipelineConfiguration);
            xMLEmitter.setOutputProperties(new Properties());
            if (stringArray.length > 1) {
                xMLEmitter.setOutputStream(new FileOutputStream(stringArray[1]));
            } else {
                xMLEmitter.setOutputStream(System.out);
            }
            NamespaceReducer namespaceReducer = new NamespaceReducer();
            namespaceReducer.setUnderlyingReceiver(xMLEmitter);
            staxBridge.setPipelineConfiguration(pipelineConfiguration);
            namespaceReducer.setPipelineConfiguration(pipelineConfiguration);
            new PullPushCopier(staxBridge, namespaceReducer).copy();
            System.err.println("Elapsed time: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    private class StaxErrorReporter
    implements XMLReporter {
        private StaxErrorReporter() {
        }

        public void report(String string, String string2, Object object, Location location) throws XMLStreamException {
            ExpressionLocation expressionLocation = StaxBridge.this.translateLocation(location);
            DynamicError dynamicError = new DynamicError("Error reported by XML parser: " + string + " (" + string2 + ')');
            dynamicError.setLocator(expressionLocation);
            try {
                StaxBridge.this.pipe.getErrorListener().error(dynamicError);
            }
            catch (TransformerException transformerException) {
                throw new XMLStreamException(transformerException);
            }
        }
    }

    public class StaxNamespaces
    implements NamespaceDeclarations {
        public int getNumberOfNamespaces() {
            return StaxBridge.this.reader.getNamespaceCount();
        }

        public String getPrefix(int n) {
            String string = StaxBridge.this.reader.getNamespacePrefix(n);
            return string == null ? "" : string;
        }

        public String getURI(int n) {
            String string = StaxBridge.this.reader.getNamespaceURI(n);
            return string == null ? "" : string;
        }

        public int getNamespaceCode(int n) {
            return StaxBridge.this.getNamePool().allocateNamespaceCode(this.getPrefix(n), this.getURI(n));
        }

        public int[] getNamespaceCodes(int[] nArray) {
            if (nArray.length < this.getNumberOfNamespaces()) {
                nArray = new int[this.getNumberOfNamespaces()];
            }
            for (int i = 0; i < this.getNumberOfNamespaces(); ++i) {
                nArray[i] = this.getNamespaceCode(i);
            }
            return nArray;
        }
    }

    private class StaxAttributes
    implements AttributeCollection {
        private StaxAttributes() {
        }

        public void setLocationProvider(LocationProvider locationProvider) {
        }

        public int getLength() {
            return StaxBridge.this.reader.getAttributeCount();
        }

        public int getNameCode(int n) {
            String string = StaxBridge.this.reader.getAttributeLocalName(n);
            String string2 = StaxBridge.this.reader.getAttributeNamespace(n);
            String string3 = StaxBridge.this.reader.getAttributePrefix(n);
            if (string3 == null) {
                string3 = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return StaxBridge.this.getNamePool().allocate(string3, string2, string);
        }

        public int getTypeAnnotation(int n) {
            if (this.isId(n)) {
                return 1073742384;
            }
            return 642;
        }

        public int getLocationId(int n) {
            return 0;
        }

        public String getSystemId(int n) {
            return StaxBridge.this.reader.getLocation().getSystemId();
        }

        public int getLineNumber(int n) {
            return StaxBridge.this.reader.getLocation().getLineNumber();
        }

        public int getProperties(int n) {
            int n2 = 0;
            if (!StaxBridge.this.reader.isAttributeSpecified(n)) {
                n2 |= 8;
            }
            return n2;
        }

        public String getPrefix(int n) {
            return StaxBridge.this.getNamePool().getPrefix(this.getNameCode(n));
        }

        public String getQName(int n) {
            return StaxBridge.this.getNamePool().getDisplayName(this.getNameCode(n));
        }

        public String getLocalName(int n) {
            return StaxBridge.this.reader.getAttributeLocalName(n);
        }

        public String getURI(int n) {
            return StaxBridge.this.reader.getAttributeNamespace(n);
        }

        public int getIndex(String string, String string2) {
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.getLocalName(i) != string2 || this.getURI(i) != string) continue;
                return i;
            }
            return -1;
        }

        public int getIndexByFingerprint(int n) {
            return this.getIndex(StaxBridge.this.getNamePool().getURI(n), StaxBridge.this.getNamePool().getLocalName(n));
        }

        public String getValueByFingerprint(int n) {
            return this.getValue(this.getIndexByFingerprint(n));
        }

        public String getValue(String string, String string2) {
            return StaxBridge.this.reader.getAttributeValue(string, string2);
        }

        public String getValue(int n) {
            return StaxBridge.this.reader.getAttributeValue(n);
        }

        public boolean isId(int n) {
            return StaxBridge.this.reader.getAttributeType(n).equals("ID");
        }
    }
}

