/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.FtpDelPlugin;
import org.webharvest.runtime.processors.plugins.FtpGetPlugin;
import org.webharvest.runtime.processors.plugins.FtpListPlugin;
import org.webharvest.runtime.processors.plugins.FtpMkdirPlugin;
import org.webharvest.runtime.processors.plugins.FtpPluginException;
import org.webharvest.runtime.processors.plugins.FtpPutPlugin;
import org.webharvest.runtime.processors.plugins.FtpRmdirPlugin;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class FtpPlugin
extends WebHarvestPlugin {
    FTPClient ftpClient;

    @Override
    public String getName() {
        return "ftp";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        String server = CommonUtil.nvl(this.evaluateAttribute("server", scraper), "");
        int port = this.evaluateAttributeAsInteger("port", 21, scraper);
        String username = CommonUtil.nvl(this.evaluateAttribute("username", scraper), "");
        String password = CommonUtil.nvl(this.evaluateAttribute("password", scraper), "");
        String account = CommonUtil.nvl(this.evaluateAttribute("account", scraper), "");
        String remoteDir = CommonUtil.nvl(this.evaluateAttribute("remotedir", scraper), "");
        this.setProperty("Server", server);
        this.setProperty("Port", port);
        this.setProperty("Username", username);
        this.setProperty("Password", password);
        this.setProperty("Account", account);
        this.setProperty("Remote Dir", remoteDir);
        this.ftpClient = new FTPClient();
        try {
            this.ftpClient.connect(server, port);
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
                throw new FtpPluginException("FTP server refused connection!");
            }
            if (CommonUtil.isEmptyString(account)) {
                this.ftpClient.login(username, password);
            } else {
                this.ftpClient.login(username, password, account);
            }
            if (!CommonUtil.isEmptyString(remoteDir)) {
                this.ftpClient.changeWorkingDirectory(remoteDir);
            }
            this.ftpClient.setFileType(2);
            Variable variable = this.executeBody(scraper, scraper.getContext());
            return variable;
        }
        catch (Exception e) {
            throw new FtpPluginException(e);
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException ioe) {}
            }
            this.ftpClient = null;
        }
    }

    @Override
    public String[] getValidAttributes() {
        return new String[]{"server", "port", "username", "password", "account", "remotedir"};
    }

    @Override
    public String[] getRequiredAttributes() {
        return new String[]{"server", "username", "password"};
    }

    @Override
    public Class[] getDependantProcessors() {
        return new Class[]{FtpListPlugin.class, FtpGetPlugin.class, FtpPutPlugin.class, FtpDelPlugin.class, FtpMkdirPlugin.class, FtpRmdirPlugin.class};
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }
}

