/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static <A, E extends Collection<A>> E addAll(E col, A ... e) {
        Collections.addAll(col, e);
        return col;
    }

    public static <A, E extends List<A>> E addAll(E col, int pos, A ... e) {
        col.addAll(pos, Arrays.asList(e));
        return (E)col;
    }

    public static <O> List<O> toGenericList(List<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast List with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }

    public static <O> Collection<O> toGenericCollection(Collection<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast Collection with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }

    public static <O> Set<O> toGenericSet(Set<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast Set with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }
}

