/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.xa;

import com.arjuna.ats.jta.xa.XATxConverter;
import java.io.Serializable;

class XID
implements Serializable {
    public static final int XIDDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    public static final int NULL_XID = -1;
    public int formatID = -1;
    public int gtrid_length = 0;
    public int bqual_length = 0;
    public byte[] data = new byte[128];

    public final boolean isSameTransaction(XID xid) {
        if (this.formatID == xid.formatID && this.gtrid_length == xid.gtrid_length) {
            if (this.equals(xid)) {
                return true;
            }
            for (int i = 0; i < this.gtrid_length; ++i) {
                if (this.data[i] == xid.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void copy(XID toCopy) {
        if (toCopy == null || toCopy.formatID == -1) {
            this.formatID = -1;
            this.gtrid_length = 0;
            this.bqual_length = 0;
        } else {
            this.formatID = toCopy.formatID;
            this.gtrid_length = toCopy.gtrid_length;
            this.bqual_length = toCopy.bqual_length;
            System.arraycopy(toCopy.data, 0, this.data, 0, toCopy.data.length);
        }
    }

    public boolean equals(XID other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.formatID == other.formatID && this.gtrid_length == other.gtrid_length && this.bqual_length == other.bqual_length) {
            for (int i = 0; i < this.gtrid_length + this.bqual_length; ++i) {
                if (this.data[i] == other.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        if (this.formatID == 131076) {
            return XATxConverter.getXIDString(this);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("< ");
        stringBuilder.append(this.formatID);
        stringBuilder.append(", ");
        stringBuilder.append(this.gtrid_length);
        stringBuilder.append(", ");
        stringBuilder.append(this.bqual_length);
        stringBuilder.append(", ");
        for (i = 0; i < this.gtrid_length; ++i) {
            stringBuilder.append(this.data[i]);
        }
        stringBuilder.append(", ");
        for (i = 0; i < this.bqual_length; ++i) {
            stringBuilder.append(this.gtrid_length + this.data[i]);
        }
        stringBuilder.append(" >");
        return stringBuilder.toString();
    }
}

