/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class PropertyExpression
extends Expression {
    private Expression objectExpression;
    private String property;
    private boolean spreadSafe = false;
    private boolean safe = false;
    private boolean isStatic = false;
    private Method getter = null;
    private Method setter = null;
    private Field field = null;
    private int access = -1;

    public boolean isStatic() {
        return this.isStatic;
    }

    public PropertyExpression(Expression objectExpression, String property) {
        this(objectExpression, property, false);
    }

    public PropertyExpression(Expression objectExpression, String property, boolean safe) {
        this.objectExpression = objectExpression;
        this.property = property;
        this.safe = safe;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitPropertyExpression(this);
    }

    public boolean isDynamic() {
        return true;
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    public Expression getObjectExpression() {
        return this.objectExpression;
    }

    public void setObjectExpression(Expression exp) {
        this.objectExpression = exp;
    }

    public String getProperty() {
        return this.property;
    }

    public String getText() {
        return this.objectExpression.getText() + "." + this.property;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public boolean isSpreadSafe() {
        return this.spreadSafe;
    }

    public void setSpreadSafe(boolean value) {
        this.spreadSafe = value;
    }

    public String toString() {
        return super.toString() + "[object: " + this.objectExpression + " property: " + this.property + "]";
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setField(Field fld) {
        this.field = fld;
        this.setStatic(Modifier.isStatic(fld.getModifiers()));
        this.setType(ClassHelper.make(fld.getType()));
    }

    public Field getField() {
        return this.field;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public int getAccess() {
        return this.access;
    }
}

