/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.Message;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-independent"}, sequential=true)
public class SendAndReceiveTest {
    JChannel channel;
    static final int NUM_MSGS = 1000;
    static final long TIMEOUT = 30000L;
    String props1 = "UDP(loopback=true;mcast_port=27000;ip_ttl=1;mcast_send_buf_size=64000;mcast_recv_buf_size=64000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096):pbcast.GMS(join_timeout=5000;print_local_addr=true)";
    String props2 = "UDP(loopback=false;mcast_port=27000;ip_ttl=1;mcast_send_buf_size=64000;mcast_recv_buf_size=64000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096):pbcast.GMS(join_timeout=5000;print_local_addr=true)";
    String props3 = "SHARED_LOOPBACK:PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096):pbcast.GMS(join_timeout=5000;print_local_addr=true)";

    private void setUp(String props) {
        block2: {
            try {
                this.channel = new JChannel(props);
                this.channel.connect("test1");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"channel could not be created");
            }
        }
    }

    @AfterMethod
    public void tearDown() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Test
    public void testSendAndReceiveWithDefaultUDP_Loopback() {
        this.setUp(this.props1);
        this.sendMessages(1000);
        int received_msgs = this.receiveMessages(1000, 30000L);
        assert (received_msgs >= 1000);
    }

    @Test
    public void testSendAndReceiveWithDefaultUDP_NoLoopback() {
        this.setUp(this.props2);
        this.sendMessages(1000);
        int received_msgs = this.receiveMessages(1000, 30000L);
        assert (received_msgs >= 1000);
    }

    @Test
    public void testSendAndReceiveWithLoopback() {
        this.setUp(this.props3);
        this.sendMessages(1000);
        int received_msgs = this.receiveMessages(1000, 30000L);
        assert (received_msgs >= 1000);
    }

    private void sendMessages(int num) {
        for (int i = 0; i < num; ++i) {
            try {
                Message msg = new Message();
                this.channel.send(msg);
                System.out.print(i + " ");
                continue;
            }
            catch (Throwable t) {
                assert (false) : "could not send message #" + i;
                continue;
            }
        }
    }

    private int receiveMessages(int num, long timeout) {
        long current;
        long wait_time;
        int received = 0;
        if (timeout <= 0L) {
            timeout = 5000L;
        }
        long start = System.currentTimeMillis();
        while ((wait_time = timeout - ((current = System.currentTimeMillis()) - start)) > 0L) {
            try {
                Object msg = this.channel.receive(wait_time);
                if (msg instanceof Message) {
                    System.out.print("+" + ++received + ' ');
                }
                if (received < num) continue;
                break;
            }
            catch (Throwable t) {
                assert (false) : "failed receiving message";
            }
        }
        return received;
    }
}

