/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class IpAddressTest {
    IpAddress a;
    IpAddress b;
    IpAddress c;
    IpAddress d;
    IpAddress e;
    IpAddress f;
    IpAddress g;
    IpAddress h;
    IpAddress i;
    IpAddress j;
    IpAddress k;

    @BeforeClass
    public void setUp() throws Exception {
        StackType type = Util.getIpStackType();
        if (type == StackType.IPv6) {
            this.a = new IpAddress("::1", 5555);
            this.b = new IpAddress("::1", 5555);
            this.d = new IpAddress("::1", 5556);
            this.e = new IpAddress("::1", 5555);
            this.f = new IpAddress("2001:0db8:0000:0000:0000:002e:0370:2334", 80);
            this.g = new IpAddress("2001:0db8:0000:0000:0000:002e:0370:2334", 8080);
            this.h = new IpAddress("ff0e::3:4:5", 5555);
        } else {
            this.a = new IpAddress("localhost", 5555);
            this.b = new IpAddress("localhost", 5555);
            this.d = new IpAddress("localhost", 5556);
            this.e = new IpAddress("127.0.0.1", 5555);
            this.f = new IpAddress("www.ibm.com", 80);
            this.g = new IpAddress("www.ibm.com", 8080);
            this.h = new IpAddress("224.0.0.1", 5555);
        }
        this.c = this.b;
    }

    public static void testUnknownAddress() {
        try {
            IpAddress tmp = new IpAddress("idontknow.com", 55);
            assert (false) : "should throw an UnknownHostException for " + tmp;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void testEquality() throws Exception {
        Assert.assertEquals((Object)this.a, (Object)this.b);
        Assert.assertEquals((Object)this.c, (Object)this.b);
        Assert.assertEquals((Object)this.a, (Object)this.e);
        Assert.assertEquals((Object)this.c, (Object)this.e);
    }

    public static void testEqualityWithDnsRoundRobin() throws UnknownHostException {
        StackType type = Util.getIpStackType();
        String tmp = type == StackType.IPv6 ? "::1" : "127.0.0.1";
        InetAddress addr = InetAddress.getByName(tmp);
        byte[] rawAddr = addr.getAddress();
        InetAddress inet1 = InetAddress.getByAddress("MyHost1", rawAddr);
        InetAddress inet2 = InetAddress.getByAddress("MyHost2", rawAddr);
        InetAddress inet3 = InetAddress.getByAddress("MyHost3", rawAddr);
        Assert.assertEquals((Object)inet1, (Object)inet2);
        IpAddress x1 = new IpAddress(inet1, 5555);
        IpAddress x2 = new IpAddress(inet2, 5555);
        IpAddress x3 = new IpAddress(inet3, 5555);
        Assert.assertEquals((Object)x1, (Object)x2);
        Assert.assertEquals((Object)x3, (Object)x1);
        HashSet s = new HashSet();
        Collections.addAll(s, x1, x2, x3);
        System.out.println("s=" + s);
        Assert.assertEquals((int)1, (int)s.size());
        HashMap<IpAddress, String> m = new HashMap<IpAddress, String>();
        m.put(x1, "Bela");
        m.put(x2, "Michelle");
        m.put(x3, "Nicole");
        Assert.assertEquals((int)1, (int)m.size());
        Assert.assertEquals((String)"Nicole", (String)((String)m.get(x1)));
    }

    public void testInequality() throws Exception {
        Object tmp = null;
        assert (!this.a.equals(this.d));
        assert (!this.c.equals(this.d));
        assert (!this.a.equals(this.f));
        assert (!this.e.equals(this.f));
        assert (!this.f.equals(this.g));
        assert (!this.a.equals(tmp));
    }

    public void testSameHost() throws Exception {
        assert (Util.sameHost(this.a, this.b));
        assert (Util.sameHost(this.a, this.c));
        assert (Util.sameHost(this.a, this.d));
        assert (Util.sameHost(this.a, this.e));
        assert (Util.sameHost(this.f, this.g));
    }

    public void testNotSameHost() throws Exception {
        assert (!Util.sameHost(this.a, this.f));
        assert (!Util.sameHost(this.e, this.f));
        assert (!Util.sameHost(this.e, null));
        assert (!Util.sameHost(null, null));
    }

    public void testMcast() {
        assert (this.h.isMulticastAddress());
        assert (!this.a.isMulticastAddress());
        assert (!this.e.isMulticastAddress());
        assert (!this.g.isMulticastAddress());
    }

    public void testCompareTo() {
        Assert.assertEquals((int)0, (int)this.a.compareTo(this.b));
        assert (this.a.compareTo(this.d) < 0);
        assert (this.d.compareTo(this.a) > 0);
    }

    public void testCompareTime() {
        int NUM = 1000000;
        IpAddressTest._testCompareTime(this.a, this.a, 1000000);
        IpAddressTest._testCompareTime(this.a, this.b, 1000000);
        IpAddressTest._testCompareTime(this.a, this.c, 1000000);
        IpAddressTest._testCompareTime(this.a, this.d, 1000000);
    }

    private static void _testCompareTime(IpAddress one, IpAddress two, int num) {
        int rc = -99;
        long start = System.currentTimeMillis();
        for (int x = 0; x < num; ++x) {
            rc = one.compareTo(two);
        }
        long stop = System.currentTimeMillis();
        long diff = stop - start;
        System.out.println("calling compareTo(" + one + ", " + two + ") " + num + " times took " + diff + "ms, result=" + rc);
    }

    public void testHashcode() {
        int hcode_a = this.a.hashCode();
        int hcode_b = this.b.hashCode();
        Assert.assertEquals((int)hcode_a, (int)hcode_b);
    }

    public void testHashcodeTime() {
        int hash = -1;
        int NUM = 10000000;
        long start = System.currentTimeMillis();
        for (int x = 0; x < 10000000; ++x) {
            hash = this.a.hashCode();
        }
        long stop = System.currentTimeMillis();
        long diff = stop - start;
        System.out.println("taking the hash code of " + this.a + "(" + hash + ") took " + diff + "ms");
    }

    public static void testIPv6WithExternalization() throws IOException, ClassNotFoundException {
        InetAddress tmp = Util.getNonLoopbackAddress();
        IpAddress ip = new IpAddress(tmp, 5555);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        System.out.println("-- address is " + tmp);
        oos.writeObject(ip);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        IpAddress ip2 = (IpAddress)ois.readObject();
        Assert.assertEquals((Object)ip, (Object)ip2);
    }

    public static void testIPv6WithStreamable() throws IOException, ClassNotFoundException {
        InetAddress tmp = Util.getNonLoopbackAddress();
        IpAddress ip = new IpAddress(tmp, 5555);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        System.out.println("-- address is " + tmp);
        ip.writeTo(dos);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        IpAddress ip2 = new IpAddress();
        ip2.readFrom(dis);
        Assert.assertEquals((Object)ip, (Object)ip2);
    }

    public void testExternalization() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        this.a.setAdditionalData(null);
        this.b.setAdditionalData("Bela Ban".getBytes());
        oos.writeObject(this.a);
        oos.writeObject(this.b);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        IpAddress a2 = (IpAddress)ois.readObject();
        IpAddress b2 = (IpAddress)ois.readObject();
        Assert.assertEquals((Object)this.a, (Object)a2);
        Assert.assertEquals((Object)this.b, (Object)b2);
        assert (a2.getAdditionalData() == null);
        Assert.assertEquals((String)"Bela Ban", (String)new String(b2.getAdditionalData()));
    }

    public void testExternalizationAdditionalData() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        oos.writeObject(this.a);
        oos.writeObject(this.b);
        oos.writeObject(this.c);
        oos.writeObject(this.d);
        oos.writeObject(this.e);
        oos.writeObject(this.f);
        oos.writeObject(this.g);
        oos.writeObject(this.h);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        IpAddress a2 = (IpAddress)ois.readObject();
        IpAddress b2 = (IpAddress)ois.readObject();
        IpAddress c2 = (IpAddress)ois.readObject();
        IpAddress d2 = (IpAddress)ois.readObject();
        IpAddress e2 = (IpAddress)ois.readObject();
        IpAddress f2 = (IpAddress)ois.readObject();
        IpAddress g2 = (IpAddress)ois.readObject();
        IpAddress h2 = (IpAddress)ois.readObject();
        Assert.assertEquals((Object)b2, (Object)c2);
        Assert.assertEquals((Object)this.a, (Object)a2);
        Assert.assertEquals((Object)this.b, (Object)b2);
        Assert.assertEquals((Object)this.c, (Object)c2);
        Assert.assertEquals((Object)this.d, (Object)d2);
        Assert.assertEquals((Object)this.e, (Object)e2);
        Assert.assertEquals((Object)this.f, (Object)f2);
        Assert.assertEquals((Object)this.g, (Object)g2);
        Assert.assertEquals((Object)this.h, (Object)h2);
    }

    public void testStreamable() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream oos = new DataOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        IpAddress x = IpAddressTest.createStackConformantAddress(5555);
        x.setAdditionalData(new byte[]{98, 101, 108, 97});
        IpAddress y = IpAddressTest.createStackConformantAddress(1111);
        y.setAdditionalData(new byte[]{98, 101, 108, 97});
        this.a.setAdditionalData(null);
        this.b.setAdditionalData("Bela Ban".getBytes());
        this.a.writeTo(oos);
        this.b.writeTo(oos);
        x.writeTo(oos);
        y.writeTo(oos);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        DataInputStream ois = new DataInputStream(bis);
        IpAddress a2 = new IpAddress();
        a2.readFrom(ois);
        IpAddress b2 = new IpAddress();
        b2.readFrom(ois);
        IpAddress x2 = new IpAddress();
        x2.readFrom(ois);
        IpAddress y2 = new IpAddress();
        y2.readFrom(ois);
        Assert.assertEquals((Object)this.a, (Object)a2);
        Assert.assertEquals((Object)this.b, (Object)b2);
        assert (a2.getAdditionalData() == null);
        Assert.assertEquals((String)"Bela Ban", (String)new String(b2.getAdditionalData()));
        assert (x2.getAdditionalData() != null);
        Assert.assertEquals((int)4, (int)x2.getAdditionalData().length);
        assert (y2.getIpAddress() != null);
        Assert.assertEquals((int)1111, (int)y2.getPort());
        assert (y2.getAdditionalData() != null);
        Assert.assertEquals((int)4, (int)y2.getAdditionalData().length);
    }

    public static void testStreamableWithHighPort() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream oos = new DataOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        IpAddress x = IpAddressTest.createStackConformantAddress(65535);
        x.writeTo(oos);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        IpAddress x2 = new IpAddress();
        x2.readFrom(dis);
        System.out.println("x: " + x + ", x2: " + x2);
        assert (x2.getPort() > 0);
        Assert.assertEquals((int)x.getPort(), (int)x2.getPort());
    }

    public void testStreamableAdditionalData() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream oos = new DataOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        this.a.writeTo(oos);
        this.b.writeTo(oos);
        this.c.writeTo(oos);
        this.d.writeTo(oos);
        this.e.writeTo(oos);
        this.f.writeTo(oos);
        this.g.writeTo(oos);
        this.h.writeTo(oos);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        DataInputStream ois = new DataInputStream(bis);
        IpAddress a2 = new IpAddress();
        a2.readFrom(ois);
        IpAddress b2 = new IpAddress();
        b2.readFrom(ois);
        IpAddress c2 = new IpAddress();
        c2.readFrom(ois);
        IpAddress d2 = new IpAddress();
        d2.readFrom(ois);
        IpAddress e2 = new IpAddress();
        e2.readFrom(ois);
        IpAddress f2 = new IpAddress();
        f2.readFrom(ois);
        IpAddress g2 = new IpAddress();
        g2.readFrom(ois);
        IpAddress h2 = new IpAddress();
        h2.readFrom(ois);
        Assert.assertEquals((Object)b2, (Object)c2);
        Assert.assertEquals((Object)this.a, (Object)a2);
        Assert.assertEquals((Object)this.b, (Object)b2);
        Assert.assertEquals((Object)this.c, (Object)c2);
        Assert.assertEquals((Object)this.d, (Object)d2);
        Assert.assertEquals((Object)this.e, (Object)e2);
        Assert.assertEquals((Object)this.f, (Object)f2);
        Assert.assertEquals((Object)this.g, (Object)g2);
        Assert.assertEquals((Object)this.h, (Object)h2);
    }

    private static IpAddress createStackConformantAddress(int port) throws UnknownHostException {
        StackType type = Util.getIpStackType();
        if (type == StackType.IPv6) {
            return new IpAddress("::1", port);
        }
        return new IpAddress("127.0.0.1", port);
    }
}

