/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.util.Promise;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@Experimental
public class FILE_PING
extends Discovery {
    protected static final String SUFFIX = ".node";
    @Property(description="The absolute path of the shared file")
    protected String location = File.separator + "tmp" + File.separator + "jgroups";
    @Property(description="Interval (in milliseconds) at which the own address is written to the file system. 0 disables it.")
    protected long interval = 60000L;
    protected File root_dir = null;
    protected FilenameFilter filter;
    private ScheduledFuture<?> writer_future;

    @Override
    public void init() throws Exception {
        super.init();
        this.createRootDir();
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.interval > 0L) {
            this.writer_future = this.timer.scheduleWithFixedDelay(new WriterTask(), this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.writer_future != null) {
            this.writer_future.cancel(false);
            this.writer_future = null;
        }
        super.stop();
    }

    @Override
    public void sendGetMembersRequest(String cluster_name, Promise promise, boolean return_views_only) throws Exception {
        List<PingData> existing_mbrs = this.readAll(cluster_name);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
        PingData data = new PingData(this.local_addr, null, false, UUID.get(this.local_addr), physical_addrs);
        if (existing_mbrs.isEmpty()) {
            if (promise != null) {
                promise.setResult(null);
            }
        } else {
            for (PingData tmp : existing_mbrs) {
                Collection<PhysicalAddress> dests;
                Collection<PhysicalAddress> collection = dests = tmp != null ? tmp.getPhysicalAddrs() : null;
                if (dests == null) continue;
                for (final PhysicalAddress dest : dests) {
                    if (dest == null || dest.equals(physical_addr)) continue;
                    PingHeader hdr = new PingHeader(1, data, cluster_name);
                    hdr.return_view_only = return_views_only;
                    final Message msg = new Message(dest);
                    msg.setFlag((byte)1);
                    msg.putHeader(this.id, hdr);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest());
                    }
                    this.timer.execute(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    FILE_PING.this.down_prot.down(new Event(1, msg));
                                }
                                catch (Exception ex) {
                                    if (!FILE_PING.this.log.isErrorEnabled()) break block2;
                                    FILE_PING.this.log.error("failed sending discovery request to " + dest, ex);
                                }
                            }
                        }
                    });
                }
            }
        }
        this.writeToFile(data, cluster_name);
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return retval;
    }

    protected void createRootDir() {
        this.root_dir = new File(this.location);
        if (this.root_dir.exists()) {
            if (!this.root_dir.isDirectory()) {
                throw new IllegalArgumentException("location " + this.root_dir.getPath() + " is not a directory");
            }
        } else {
            this.root_dir.mkdirs();
        }
        if (!this.root_dir.exists()) {
            throw new IllegalArgumentException("location " + this.root_dir.getPath() + " could not be accessed");
        }
        this.filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(FILE_PING.SUFFIX);
            }
        };
    }

    protected void handleView(View view) {
        boolean is_coordinator;
        Vector<Address> mbrs = view.getMembers();
        boolean bl = is_coordinator = !mbrs.isEmpty() && ((Address)mbrs.iterator().next()).equals(this.local_addr);
        if (is_coordinator) {
            List<PingData> data = this.readAll(this.group_addr);
            for (PingData entry : data) {
                Address addr = entry.getAddress();
                if (addr == null || mbrs.contains(addr)) continue;
                this.remove(this.group_addr, addr);
            }
        }
    }

    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            return;
        }
        try {
            String filename = addr instanceof UUID ? ((UUID)addr).toStringLong() : addr.toString();
            File file = new File(dir, filename + SUFFIX);
            if (this.log.isTraceEnabled()) {
                this.log.trace("removing " + file);
            }
            file.delete();
        }
        catch (Throwable e) {
            this.log.error("failure removing data", e);
        }
    }

    protected List<PingData> readAll(String clustername) {
        File[] files;
        ArrayList<PingData> retval = new ArrayList<PingData>();
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if ((files = dir.listFiles(this.filter)) != null) {
            for (File file : files) {
                retval.add(FILE_PING.readFile(file));
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    protected static PingData readFile(File file) {
        PingData pingData;
        PingData retval = null;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            PingData tmp = new PingData();
            tmp.readFrom(in);
            pingData = tmp;
        }
        catch (Exception exception) {
            Util.close(in);
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
        }
        Util.close(in);
        return pingData;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeToFile(PingData data, String clustername) {
        DataOutputStream out = null;
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        String filename = this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : this.local_addr.toString();
        File file = new File(dir, filename + SUFFIX);
        file.deleteOnExit();
        try {
            out = new DataOutputStream(new FileOutputStream(file));
            data.writeTo(out);
        }
        catch (Exception e) {
            Util.close(out);
            catch (Throwable throwable) {
                Util.close(out);
                throw throwable;
            }
        }
        Util.close(out);
    }

    protected class WriterTask
    implements Runnable {
        protected WriterTask() {
        }

        @Override
        public void run() {
            PhysicalAddress physical_addr = (PhysicalAddress)FILE_PING.this.down(new Event(87, FILE_PING.this.local_addr));
            List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
            PingData data = new PingData(FILE_PING.this.local_addr, null, false, UUID.get(FILE_PING.this.local_addr), physical_addrs);
            FILE_PING.this.writeToFile(data, FILE_PING.this.group_addr);
        }
    }
}

