/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.saxon.trans.XPathException;
import org.webharvest.exception.BaseException;
import org.webharvest.exception.ScraperXPathException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.CallProcessor;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;
import org.webharvest.utils.XmlUtil;

public class SystemUtilities {
    public static final Variable lf = new NodeVariable("\n");
    public static final Variable tab = new NodeVariable("\t");
    public static final Variable cr = new NodeVariable("\r");
    public static final Variable space = new NodeVariable(" ");
    public static final Variable quot = new NodeVariable("\"");
    public static final Variable apos = new NodeVariable("'");
    public static final Variable backspace = new NodeVariable("\b");
    private Scraper scraper;

    public SystemUtilities(Scraper scraper) {
        this.scraper = scraper;
    }

    public void setScraper(Scraper scraper) {
        this.scraper = scraper;
    }

    public boolean isVariableDefined(String varName) {
        return this.scraper.getContext().get(varName) != null;
    }

    public Variable getVar(String varName) {
        CallProcessor runningFunction = this.scraper.getRunningFunction();
        ScraperContext activeContext = runningFunction == null ? this.scraper.getContext() : runningFunction.getFunctionContext();
        return activeContext.getVar(varName);
    }

    public void defineVariable(String varName, Object varValue, boolean overwrite) {
        ScraperContext context = this.scraper.getContext();
        if (overwrite || context.get(varName) == null) {
            Variable var = CommonUtil.createVariable(varValue);
            context.put(varName, var);
        }
    }

    public void defineVariable(String varName, Object varValue) {
        this.defineVariable(varName, varValue, true);
    }

    public String datetime(Object format) {
        if (format != null) {
            SimpleDateFormat formatter = new SimpleDateFormat(format.toString());
            return formatter.format(new Date());
        }
        throw new BaseException("Cannot return datetime for null format!");
    }

    public String date() {
        return this.datetime("yyyyMMdd");
    }

    public String time() {
        return this.datetime("HHmmss");
    }

    public String escapeXml(Object s) {
        if (s != null) {
            return CommonUtil.escapeXml(s.toString());
        }
        throw new BaseException("Cannot escape XML for null argumant!");
    }

    public String fullUrl(Object pageUrl, Object link) {
        if (pageUrl != null && link != null) {
            return CommonUtil.fullUrl(pageUrl.toString(), link.toString());
        }
        throw new BaseException("Cannot make full url for null argumants!");
    }

    public Variable xpath(Object expression, Object xml) {
        if (expression == null) {
            throw new ScraperXPathException("XPath expression is null!");
        }
        if (xml == null) {
            throw new ScraperXPathException("XML value is null!");
        }
        try {
            return XmlUtil.evaluateXPath(expression.toString(), xml.toString(), this.scraper.getRuntimeConfig());
        }
        catch (XPathException e) {
            throw new ScraperXPathException("Error parsing XPath expression (XPath = [" + expression + "])!", e);
        }
    }

    public String getFilename(String path) {
        int index = Math.max(path.lastIndexOf("\\"), path.lastIndexOf("/"));
        return index >= 0 && index < path.length() - 1 ? path.substring(index + 1) : path;
    }
}

