/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiTestAbstract;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.services.managers.FormManager;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FormManagerTest
extends VradiTestAbstract {
    protected DateFormat dateFormat = DateFormat.getDateInstance(1, Locale.US);
    protected FormManager manager;

    @Before
    public void init() throws Exception {
        this.manager = new FormManager(this.wikittyProxy, null, null);
    }

    public void getBeginOfDaySolrDateTestGmt1() throws Exception {
        Date d1 = this.dateFormat.parse("January 16, 2010 3:30:32pm");
        String dateAsString = FormManager.getBeginOfDaySolrDate((Date)d1);
        Assert.assertEquals((Object)"2010-01-16T00:00:00.000Z", (Object)dateAsString);
    }

    public void getBeginOfDaySolrDateTestGmt2() throws Exception {
        Date d1 = this.dateFormat.parse("July 16, 2010 3:30:32pm");
        String dateAsString = FormManager.getBeginOfDaySolrDate((Date)d1);
        Assert.assertEquals((Object)"2010-07-16T00:00:00.000Z", (Object)dateAsString);
    }

    public void getEndOfDaySolrDateTestGmt1() throws Exception {
        Date d1 = this.dateFormat.parse("January 16, 2010 3:30:32pm");
        String dateAsString = FormManager.getEndOfDaySolrDate((Date)d1);
        Assert.assertEquals((Object)"2010-01-16T23:59:59.999Z", (Object)dateAsString);
    }

    public void getEndOfDaySolrDateTestGmt2() throws Exception {
        Date d1 = this.dateFormat.parse("July 16, 2010 3:30:32pm");
        String dateAsString = FormManager.getEndOfDaySolrDate((Date)d1);
        Assert.assertEquals((Object)"2010-07-16T23:59:59.999Z", (Object)dateAsString);
    }

    @Test
    public void testGetLastClosedSession() throws Exception {
        Date date = new Date();
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(0);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session);
        SessionImpl session2 = new SessionImpl();
        session2.setSessionDate(DateUtils.addDays((Date)date, (int)-1));
        session2.setNum(1);
        session2.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        sessions.add(session2);
        SessionImpl session3 = new SessionImpl();
        session3.setSessionDate(DateUtils.addDays((Date)date, (int)-2));
        session3.setNum(2);
        session3.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session3);
        this.wikittyProxy.store(sessions);
        Session result = this.manager.getLastCloseSession();
        Assert.assertEquals((long)1L, (long)result.getNum());
    }

    @Test
    public void testGetLastClosedSessionWhenNoClosedSession() throws Exception {
        Date date = new Date();
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(0);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session);
        SessionImpl session3 = new SessionImpl();
        session3.setSessionDate(DateUtils.addDays((Date)date, (int)-2));
        session3.setNum(2);
        session3.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        sessions.add(session3);
        this.wikittyProxy.store(sessions);
        Session result = this.manager.getLastCloseSession();
        Assert.assertNull((Object)result);
    }
}

