package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserBean;

import java.util.HashSet;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:33:15
 */
public class VradiUserDTO extends UserBean implements VradiDTO<User> {

    private static final long serialVersionUID = 1L;

    public VradiUserDTO() {
        QueryMaker$queries = new HashSet<String>();
    }

    @Override
    public void fromWikitty(User wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setCreationDate(wikitty.getCreationDate());
            setAddress(wikitty.getAddress());
            setEmail(wikitty.getEmail());
            setName(wikitty.getName());
            setPhone(wikitty.getPhone());
            setService(wikitty.getService());
            setValidEmail(wikitty.getValidEmail());

            QueryMaker$queries.clear();
            addAllQueries(wikitty.getQueries());
        }
    }

    @Override
    public void reset() {
        setWikittyId(null);
        setCreationDate(null);
        setAddress(null);
        setEmail(null);
        setName(null);
        setPhone(null);
        setService(null);
        setValidEmail(false);
        clearQueries();
    }

    @Override
    public void toWikitty(User wikitty) {
        wikitty.setCreationDate(getCreationDate());
        wikitty.setAddress(getAddress());
        wikitty.setEmail(getEmail());
        wikitty.setName(getName());
        wikitty.setPhone(getPhone());
        wikitty.setService(getService());
        wikitty.setValidEmail(getValidEmail());

        wikitty.clearQueries();
        for (String id : getQueries()) {
            wikitty.addQueries(id);
        }
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                QueryMaker$queries.add(s);
            }
        }
        propertyChange.firePropertyChange("queries", null, QueryMaker$queries);
    }
}
