package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientBean;

import java.util.HashSet;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:23:27
 */
public class VradiClientDTO extends ClientBean implements VradiDTO<Client> {

    private static final long serialVersionUID = 1L;

    public VradiClientDTO() {
        Client$user = new HashSet<String>();
        Client$sending = new HashSet<String>();
        QueryMaker$queries = new HashSet<String>();
    }

    @Override
    public void fromWikitty(Client wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setAddress(wikitty.getAddress());
            setContact(wikitty.getContact());
            setCreationDate(wikitty.getCreationDate());
            setEmail(wikitty.getEmail());
            setName(wikitty.getName());
            setPhone(wikitty.getPhone());
            setValidEmail(wikitty.getValidEmail());

            QueryMaker$queries.clear();
            addAllQueries(wikitty.getQueries());

            Client$user.clear();
            addAllUsers(wikitty.getUser());

            Client$sending.clear();
            addAllSendings(wikitty.getUser());

        }
    }

    public void reset() {
        setWikittyId(null);
        setAddress(null);
        setContact(null);
        setCreationDate(null);
        setEmail(null);
        setName(null);
        setPhone(null);
        setValidEmail(false);
        clearQueries();
        clearUser();
        clearSending();
    }

    @Override
    public void toWikitty(Client wikitty) {
        wikitty.setAddress(getAddress());
        wikitty.setContact(getContact());
        wikitty.setCreationDate(getCreationDate());
        wikitty.setEmail(getEmail());
        wikitty.setName(getName());
        wikitty.setPhone(getPhone());
        wikitty.setValidEmail(getValidEmail());

        wikitty.clearSending();
        for (String id : getSending()) {
            wikitty.addSending(id);
        }

        wikitty.clearUser();
        for (String id : getUser()) {
            wikitty.addUser(id);
        }

        wikitty.clearQueries();
        for (String id : getQueries()) {
            wikitty.addQueries(id);
        }
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public void addAllUsers(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                Client$user.add(s);
            }
        }
        propertyChange.firePropertyChange("user", null, Client$user);
    }

    public void addAllSendings(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                Client$sending.add(s);
            }
        }
        propertyChange.firePropertyChange("sending", null, Client$sending);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                QueryMaker$queries.add(s);
            }
        }
        propertyChange.firePropertyChange("queries", null, QueryMaker$queries);
    }
}
