/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.searchable;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import jidefx.scene.control.searchable.Searchable;

public class TreeViewSearchable<T>
extends Searchable<TreeItem<T>> {
    private BooleanProperty _recursiveProperty;
    private transient List<TreeItem> _treeItems;
    private ChangeListener _rootChangeListener;

    public TreeViewSearchable(TreeView<T> treeView) {
        super((Node)treeView);
        this.recursiveProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                TreeViewSearchable.this.hidePopup();
                TreeViewSearchable.this.resetTreeItems();
            }
        });
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._rootChangeListener == null) {
            this._rootChangeListener = new ChangeListener(){

                public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                    TreeViewSearchable.this.hidePopup();
                    TreeViewSearchable.this.resetTreeItems();
                }
            };
        }
        ((TreeView)this._node).rootProperty().addListener(this._rootChangeListener);
    }

    @Override
    public void uninstallListeners() {
        if (this._rootChangeListener != null) {
            ((TreeView)this._node).rootProperty().removeListener(this._rootChangeListener);
            this._rootChangeListener = null;
        }
        super.uninstallListeners();
    }

    public BooleanProperty recursiveProperty() {
        if (this._recursiveProperty == null) {
            this._recursiveProperty = new SimpleBooleanProperty();
        }
        return this._recursiveProperty;
    }

    public boolean isRecursive() {
        return this.recursiveProperty().get();
    }

    public void setRecursive(boolean recursive) {
        this.recursiveProperty().set(recursive);
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        TreeView treeView = (TreeView)this._node;
        if (!this.isRecursive()) {
            if (incremental) {
                treeView.getSelectionModel().select(index);
            } else {
                treeView.getSelectionModel().clearAndSelect(index);
            }
            treeView.scrollTo(index);
        } else {
            TreeItem<T> item = this.getElementAt(index);
            if (item != null) {
                if (incremental) {
                    treeView.getSelectionModel().select(item);
                } else {
                    treeView.getSelectionModel().clearSelection();
                    treeView.getSelectionModel().select(item);
                }
                treeView.scrollTo(treeView.getRow(item));
            }
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((TreeView)this._node).getSelectionModel().getSelectedIndex();
    }

    @Override
    protected TreeItem<T> getElementAt(int index) {
        if (index == -1) {
            return null;
        }
        if (!this.isRecursive()) {
            return ((TreeView)this._node).getTreeItem(index);
        }
        return this.getTreeItems().get(index);
    }

    @Override
    protected int getElementCount() {
        if (!this.isRecursive()) {
            return ((TreeView)this._node).getExpandedItemCount();
        }
        return this.getTreeItems().size();
    }

    protected void populateTreePaths() {
        this._treeItems = new ArrayList<TreeItem>();
        TreeItem root = ((TreeView)this._node).getRoot();
        this.populateTreePaths0(root);
    }

    private void populateTreePaths0(TreeItem item) {
        this._treeItems.add(item);
        ObservableList children = item.getChildren();
        for (TreeItem child : children) {
            this.populateTreePaths0(child);
        }
    }

    protected void resetTreeItems() {
        this._treeItems = null;
    }

    protected List<TreeItem> getTreeItems() {
        if (this._treeItems == null) {
            this.populateTreePaths();
        }
        return this._treeItems;
    }

    @Override
    protected String convertElementToString(TreeItem<T> object) {
        if (object != null) {
            Object value = object.getValue();
            return value != null ? value.toString() : "";
        }
        return "";
    }
}

