/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.searchable;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import jidefx.scene.control.searchable.Searchable;

public class TextInputControlSearchable
extends Searchable<String> {
    private int _selectedIndex = -1;
    private ChangeListener<String> _textChangeListener;
    private transient String _text = null;
    private transient boolean _oldEditable = false;

    public TextInputControlSearchable(TextInputControl textInputControl) {
        super((Node)textInputControl);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._node instanceof TextInputControl) {
            this._textChangeListener = new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TextInputControlSearchable.this.hidePopup();
                }
            };
            ((TextInputControl)this._node).textProperty().addListener(this._textChangeListener);
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._node instanceof TextInputControl && this._textChangeListener != null) {
            ((TextInputControl)this._node).textProperty().removeListener(this._textChangeListener);
        }
    }

    @Override
    protected void keyTypedOrPressed(KeyEvent e) {
        if (this.isActivateKey(e)) {
            this.switchToNonEditable();
        }
        super.keyTypedOrPressed(e);
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        if (this._node instanceof TextInputControl) {
            if (index == -1) {
                this.removeAllHighlights();
                this._selectedIndex = -1;
                return;
            }
            if (!incremental) {
                this.removeAllHighlights();
            }
            String text = this.getSearchingText();
            this.addHighlight(index, text, incremental);
        }
    }

    protected void addHighlight(int index, String text, boolean incremental) {
        if (this._node instanceof TextInputControl) {
            TextInputControl textComponent = (TextInputControl)this._node;
            textComponent.selectRange(index, index + text.length());
            this._selectedIndex = index;
        }
    }

    protected void removeAllHighlights() {
        if (this._node instanceof TextInputControl) {
            ((TextInputControl)this._node).deselect();
        }
    }

    @Override
    protected int getSelectedIndex() {
        if (this._node instanceof TextInputControl) {
            return this._selectedIndex;
        }
        return 0;
    }

    @Override
    protected String getElementAt(int index) {
        String text = this.getSearchingText();
        if (text != null && this._node instanceof TextInputControl) {
            int elementCount;
            int endIndex = index + text.length();
            if (endIndex > (elementCount = this.getElementCount())) {
                endIndex = this.getElementCount();
            }
            if (endIndex < this.getElementCount() && index < this.getElementCount()) {
                return ((TextInputControl)this._node).getText().substring(index, endIndex);
            }
        }
        return "";
    }

    @Override
    protected int getElementCount() {
        if (this._node instanceof TextInputControl) {
            return ((TextInputControl)this._node).getLength();
        }
        return 0;
    }

    @Override
    protected String convertElementToString(String element) {
        if (element != null) {
            return element;
        }
        return "";
    }

    @Override
    protected boolean isActivateKey(KeyEvent e) {
        if (this._node instanceof TextInputControl && ((TextInputControl)this._node).isEditable()) {
            return KeyCombination.keyCombination((String)"Ctrl+F").match(e);
        }
        return super.isActivateKey(e);
    }

    @Override
    public int findLast(String s) {
        if (this._node instanceof TextInputControl) {
            String text = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return text.lastIndexOf(s);
            }
            return TextInputControlSearchable.lastIndexOf(text, s, text.length());
        }
        return super.findLast(s);
    }

    private String getDocumentText() {
        if (this._text == null && this._node instanceof TextInputControl) {
            this._text = ((TextInputControl)this._node).getText();
        }
        return this._text;
    }

    @Override
    public int findFirst(String s) {
        if (this._node instanceof TextInputControl) {
            String text = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return text.indexOf(s);
            }
            return TextInputControlSearchable.indexOf(text, s, 0);
        }
        return super.findFirst(s);
    }

    static int lastIndexOf(String source, String target, int fromIndex) {
        int sourceCount = source.length();
        int targetCount = target.length();
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char[] lowerTarget = target.toLowerCase().toCharArray();
        char[] upperTarget = target.toUpperCase().toCharArray();
        int strLastIndex = targetCount - 1;
        int min = targetCount - 1;
        int i = min + fromIndex;
        while (i >= min) {
            while (i >= min && source.charAt(i) != lowerTarget[strLastIndex] && source.charAt(i) != upperTarget[strLastIndex]) {
                --i;
            }
            if (i < min) break;
            int j = i - 1;
            int start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                char ch = source.charAt(j);
                if (ch != lowerTarget[k] && ch != upperTarget[k]) {
                    --i;
                    break;
                }
                --j;
                --k;
            }
            if (j > start) continue;
            return start + 1;
        }
        return -1;
    }

    private static int indexOf(String source, String target, int fromIndex) {
        int sourceCount = source.length();
        int targetCount = target.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char[] lowerTarget = target.toLowerCase().toCharArray();
        char[] upperTarget = target.toUpperCase().toCharArray();
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            char ch;
            int j;
            char c = source.charAt(i);
            if (c != lowerTarget[0] && c != upperTarget[0]) {
                ++i;
                while (i <= max && source.charAt(i) != lowerTarget[0] && source.charAt(i) != upperTarget[0]) {
                    ++i;
                }
            }
            if (i > max) continue;
            int end = j + targetCount - 1;
            int k = 1;
            for (j = i + 1; j < end && ((ch = source.charAt(j)) == lowerTarget[k] || ch == upperTarget[k]); ++j) {
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int findFromCursor(String s) {
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(s);
        }
        if (this._node instanceof TextInputControl) {
            int found;
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s.length() > 0 ? -1 : 0;
            }
            int n2 = found = this.isCaseSensitive() ? text.indexOf(s, selectedIndex) : TextInputControlSearchable.indexOf(text, s, selectedIndex);
            if (found == -1) {
                int n3 = found = this.isCaseSensitive() ? text.indexOf(s, 0) : TextInputControlSearchable.indexOf(text, s, 0);
                if (found >= selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findFromCursor(s);
    }

    @Override
    public int reverseFindFromCursor(String s) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(s);
        }
        if (this._node instanceof TextInputControl) {
            int found;
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s.length() > 0 ? -1 : 0;
            }
            int n2 = found = this.isCaseSensitive() ? text.lastIndexOf(s, selectedIndex) : TextInputControlSearchable.lastIndexOf(text, s, selectedIndex);
            if (found == -1) {
                int n3 = found = this.isCaseSensitive() ? text.lastIndexOf(s, text.length() - 1) : TextInputControlSearchable.lastIndexOf(text, s, text.length() - 1);
                if (found <= selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findFromCursor(s);
    }

    @Override
    public int findNext(String s) {
        if (this._node instanceof TextInputControl) {
            int found;
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s.length() > 0 ? -1 : 0;
            }
            int n2 = found = this.isCaseSensitive() ? text.indexOf(s, selectedIndex + 1) : TextInputControlSearchable.indexOf(text, s, selectedIndex + 1);
            if (found == -1 && this.isRepeats()) {
                int n3 = found = this.isCaseSensitive() ? text.indexOf(s, 0) : TextInputControlSearchable.indexOf(text, s, 0);
                if (found > selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findNext(s);
    }

    @Override
    public int findPrevious(String s) {
        if (this._node instanceof TextInputControl) {
            int found;
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s.length() > 0 ? -1 : 0;
            }
            int n2 = found = this.isCaseSensitive() ? text.lastIndexOf(s, selectedIndex - 1) : TextInputControlSearchable.lastIndexOf(text, s, selectedIndex - 1);
            if (found == -1 && this.isRepeats()) {
                int n3 = found = this.isCaseSensitive() ? text.lastIndexOf(s, count - 1) : TextInputControlSearchable.lastIndexOf(text, s, count - 1);
                if (found < selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findPrevious(s);
    }

    private void switchToNonEditable() {
        if (this._node instanceof TextInputControl && !this._oldEditable) {
            this._oldEditable = ((TextInputControl)this._node).isEditable();
            if (this._oldEditable) {
                ((TextInputControl)this._node).setEditable(false);
            }
        }
    }

    private void switchToEditable() {
        if (this._node instanceof TextInputControl && this._oldEditable) {
            ((TextInputControl)this._node).setEditable(this._oldEditable);
            this._oldEditable = false;
        }
    }

    @Override
    public void showPopup(String searchingText) {
        this.switchToNonEditable();
        super.showPopup(searchingText);
    }

    @Override
    public void hidePopup() {
        super.hidePopup();
        this._selectedIndex = -1;
        this._text = null;
        this.switchToEditable();
    }
}

