/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.searchable;

import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import jidefx.scene.control.searchable.Searchable;
import jidefx.utils.CommonUtils;

public class TableViewSearchable<T>
extends Searchable<Object> {
    private int[] _searchColumnIndices = new int[]{0};
    private ListChangeListener<T> _listChangeListener;
    private ChangeListener<ObservableList<T>> _itemsChangeListener;

    public TableViewSearchable(TableView<T> tableView) {
        super((Node)tableView);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._node instanceof TableView) {
            if (this._listChangeListener == null) {
                this._listChangeListener = new ListChangeListener<T>(){

                    public void onChanged(ListChangeListener.Change<? extends T> c) {
                        TableViewSearchable.this.hidePopup();
                    }
                };
            }
            ((TableView)this._node).getItems().addListener(this._listChangeListener);
            if (this._itemsChangeListener == null) {
                this._itemsChangeListener = new ChangeListener<ObservableList<T>>(){

                    public void changed(ObservableValue<? extends ObservableList<T>> observable, ObservableList<T> oldValue, ObservableList<T> newValue) {
                        TableViewSearchable.this.hidePopup();
                    }
                };
            }
            ((TableView)this._node).itemsProperty().addListener(this._itemsChangeListener);
        }
    }

    @Override
    public void uninstallListeners() {
        if (this._node instanceof TableView) {
            if (this._listChangeListener != null) {
                ((TableView)this._node).getItems().removeListener(this._listChangeListener);
                this._listChangeListener = null;
            }
            if (this._itemsChangeListener != null) {
                ((TableView)this._node).itemsProperty().removeListener(this._itemsChangeListener);
                this._itemsChangeListener = null;
            }
        }
        super.uninstallListeners();
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        TableView table = (TableView)this._node;
        if (this.isColumnSelectionAllowed(table)) {
            int minorIndex = index;
            int majorIndex = this.getMainIndex();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        } else if (this.isRowSelectionAllowed(table)) {
            int majorIndex = index;
            int minorIndex = this.getMainIndex();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        } else {
            int columnCount = table.getColumns().size();
            if (columnCount == 0) {
                return;
            }
            int majorIndex = index / columnCount;
            int minorIndex = index % columnCount;
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        }
    }

    protected void addTableSelection(TableView<T> table, int rowIndex, int columnIndex, boolean incremental) {
        if (!incremental) {
            table.getSelectionModel().clearSelection();
        }
        if (rowIndex >= 0 && columnIndex >= 0 && rowIndex < table.getItems().size() && columnIndex < table.getColumns().size() && !table.getSelectionModel().isSelected(rowIndex, (TableColumn)table.getColumns().get(columnIndex))) {
            TableColumn column = (TableColumn)table.getColumns().get(columnIndex);
            table.getSelectionModel().select(rowIndex, column);
            table.scrollTo(rowIndex);
            table.scrollToColumnIndex(columnIndex);
            table.getFocusModel().focus(rowIndex, column);
        }
    }

    private boolean isColumnSelectionAllowed(TableView<T> table) {
        return false;
    }

    protected boolean isRowSelectionAllowed(TableView<T> table) {
        return this.getSearchColumnIndices().length == 1 && !table.getSelectionModel().isCellSelectionEnabled();
    }

    protected boolean isSearchSelectedRows() {
        return this.getSearchColumnIndices().length > 1;
    }

    @Override
    protected int getSelectedIndex() {
        TableView table = (TableView)this._node;
        if (this.isColumnSelectionAllowed(table)) {
            return this.getSelectedColumnIndex(table, table.getSelectionModel().getSelectedIndex());
        }
        if (this.isRowSelectionAllowed(table)) {
            return table.getSelectionModel().getSelectedIndex();
        }
        return table.getSelectionModel().getSelectedIndex() * table.getColumns().size() + this.getSelectedColumnIndex(table, table.getSelectionModel().getSelectedIndex());
    }

    private int getSelectedColumnIndex(TableView<T> table, int selectedIndex) {
        TablePosition cell = table.getFocusModel().getFocusedCell();
        if (cell != null) {
            return cell.getColumn();
        }
        for (int i = 0; i < table.getColumns().size(); ++i) {
            TableColumn tableColumn = (TableColumn)table.getColumns().get(i);
            boolean selected = table.getSelectionModel().isSelected(selectedIndex, tableColumn);
            if (!selected) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected Object getElementAt(int index) {
        TableView table = (TableView)this._node;
        if (this.isColumnSelectionAllowed(table)) {
            return this.getValueAt(table, this.getMainIndex(), index);
        }
        if (this.isRowSelectionAllowed(table)) {
            return this.getValueAt(table, index, this.getMainIndex());
        }
        if (this.isSearchSelectedRows()) {
            int columnIndex = index % table.getColumns().size();
            boolean doNotSearch = true;
            for (int i : this.getSearchColumnIndices()) {
                if (i != columnIndex) continue;
                doNotSearch = false;
            }
            if (doNotSearch) {
                return null;
            }
            int rowIndex = index / table.getColumns().size();
            return this.getValueAt(table, rowIndex, columnIndex);
        }
        int columnIndex = index % table.getColumns().size();
        int rowIndex = index / table.getColumns().size();
        return this.getValueAt(table, rowIndex, columnIndex);
    }

    protected Object getValueAt(TableView table, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < table.getItems().size() && columnIndex >= 0 && columnIndex < table.getColumns().size()) {
            return ((TableColumn)table.getColumns().get(columnIndex)).getCellObservableValue(rowIndex);
        }
        return null;
    }

    @Override
    protected int getElementCount() {
        TableView table = (TableView)this._node;
        if (this.isColumnSelectionAllowed(table)) {
            return table.getColumns().size();
        }
        if (this.isRowSelectionAllowed(table)) {
            return table.getItems().size();
        }
        return table.getColumns().size() * table.getItems().size();
    }

    @Override
    protected String convertElementToString(Object item) {
        if (item instanceof Property) {
            Object value = ((Property)item).getValue();
            return value != null ? value.toString() : "";
        }
        if (item != null) {
            return item.toString();
        }
        return "";
    }

    public int[] getSearchColumnIndices() {
        return this._searchColumnIndices;
    }

    public int getMainIndex() {
        if (this._searchColumnIndices.length == 0) {
            return -1;
        }
        return this._searchColumnIndices[0];
    }

    public void setSearchColumnIndices(int[] columnIndices) {
        int[] old;
        if (columnIndices == null) {
            columnIndices = new int[]{};
        }
        if (!CommonUtils.equals(old = this._searchColumnIndices, columnIndices, true)) {
            this._searchColumnIndices = columnIndices;
            this.hidePopup();
        }
    }

    public void setMainIndex(int mainIndex) {
        int[] old;
        int[] temp = new int[]{mainIndex};
        if (mainIndex < 0) {
            temp = new int[]{};
        }
        if ((old = this._searchColumnIndices) != temp) {
            this._searchColumnIndices = temp;
            this.hidePopup();
        }
    }

    @Override
    protected boolean isFindNextKey(KeyEvent e) {
        KeyCode keyCode = e.getCode();
        TableView table = (TableView)this._node;
        if (this.isColumnSelectionAllowed(table)) {
            return keyCode == KeyCode.RIGHT;
        }
        if (this.isRowSelectionAllowed(table)) {
            return keyCode == KeyCode.DOWN;
        }
        return keyCode == KeyCode.DOWN || keyCode == KeyCode.RIGHT;
    }

    @Override
    protected boolean isFindPreviousKey(KeyEvent e) {
        KeyCode keyCode = e.getCode();
        TableView table = (TableView)this._node;
        if (this.isColumnSelectionAllowed(table)) {
            return keyCode == KeyCode.LEFT;
        }
        if (this.isRowSelectionAllowed(table)) {
            return keyCode == KeyCode.UP;
        }
        return keyCode == KeyCode.UP || keyCode == KeyCode.LEFT;
    }

    @Override
    protected boolean isActivateKey(KeyEvent e) {
        boolean editable = this.isSelectedCellEditable();
        return !editable && super.isActivateKey(e);
    }

    protected boolean isSelectedCellEditable() {
        return ((TableView)this._node).isEditable();
    }
}

