/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.popup;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeType;
import javafx.scene.shape.VLineTo;
import jidefx.scene.control.popup.PopupOutline;

public class BalloonPopupOutline
extends PopupOutline {
    private ObjectProperty<Side> _arrowSide;
    private DoubleProperty _widthProperty;
    private DoubleProperty _heightProperty;
    private DoubleProperty _roundedRadiusProperty;
    private DoubleProperty _arrowPositionProperty;
    private DoubleProperty _arrowBasePositionProperty;
    private DoubleProperty _arrowWidthProperty;
    private DoubleProperty _arrowHeightProperty;

    public BalloonPopupOutline() {
        this.createPath();
        this.initializeStyle();
    }

    protected void initializeStyle() {
        this.getStyleClass().add((Object)"balloon-popup-outline");
    }

    @Override
    public DoubleProperty widthProperty() {
        if (this._widthProperty == null) {
            this._widthProperty = new SimpleDoubleProperty();
        }
        return this._widthProperty;
    }

    public double getWidth() {
        return this.widthProperty().get();
    }

    public void setWidth(double width) {
        this.widthProperty().set(width);
    }

    @Override
    public DoubleProperty heightProperty() {
        if (this._heightProperty == null) {
            this._heightProperty = new SimpleDoubleProperty();
        }
        return this._heightProperty;
    }

    public double getHeight() {
        return this.heightProperty().get();
    }

    public void setHeight(double height) {
        this.heightProperty().set(height);
    }

    public DoubleProperty roundedRadiusProperty() {
        if (this._roundedRadiusProperty == null) {
            this._roundedRadiusProperty = new SimpleDoubleProperty(8.0);
        }
        return this._roundedRadiusProperty;
    }

    public double getRoundedRadius() {
        return this.roundedRadiusProperty().get();
    }

    public void setRoundedRadius(double roundedRadius) {
        this.roundedRadiusProperty().set(roundedRadius);
    }

    public DoubleProperty arrowPositionProperty() {
        if (this._arrowPositionProperty == null) {
            this._arrowPositionProperty = new SimpleDoubleProperty(0.1);
        }
        return this._arrowPositionProperty;
    }

    public double getArrowPosition() {
        return this.arrowPositionProperty().get();
    }

    public void setArrowPosition(double arrowPosition) {
        this.arrowPositionProperty().set(arrowPosition);
    }

    public DoubleProperty arrowBasePositionProperty() {
        if (this._arrowBasePositionProperty == null) {
            this._arrowBasePositionProperty = new SimpleDoubleProperty(0.1);
        }
        return this._arrowBasePositionProperty;
    }

    public double getArrowBasePosition() {
        return this.arrowBasePositionProperty().get();
    }

    public void setArrowBasePosition(double arrowBasePosition) {
        this.arrowBasePositionProperty().set(arrowBasePosition);
    }

    public DoubleProperty arrowHeightProperty() {
        if (this._arrowHeightProperty == null) {
            this._arrowHeightProperty = new SimpleDoubleProperty(10.0);
        }
        return this._arrowHeightProperty;
    }

    public double getArrowHeight() {
        return this.arrowHeightProperty().get();
    }

    public void setArrowHeight(double arrowHeight) {
        this.arrowHeightProperty().set(arrowHeight);
    }

    public DoubleProperty arrowWidthProperty() {
        if (this._arrowWidthProperty == null) {
            this._arrowWidthProperty = new SimpleDoubleProperty(12.0);
        }
        return this._arrowWidthProperty;
    }

    public double getArrowWidth() {
        return this.arrowWidthProperty().get();
    }

    public void setArrowWidth(double arrowWidth) {
        this.arrowWidthProperty().set(arrowWidth);
    }

    public ObjectProperty<Side> arrowSideProperty() {
        if (this._arrowSide == null) {
            this._arrowSide = new SimpleObjectProperty<Side>(Side.RIGHT){

                protected void invalidated() {
                    BalloonPopupOutline.this.createPath();
                }
            };
        }
        return this._arrowSide;
    }

    public Side getArrowSide() {
        return (Side)this.arrowSideProperty().get();
    }

    public void setArrowSide(Side side) {
        this.arrowSideProperty().set((Object)side);
    }

    @Override
    public Insets getContentPadding() {
        double arrowHeight = this.getArrowHeight();
        switch (this.getArrowSide()) {
            case RIGHT: {
                return new Insets(0.0, arrowHeight, 0.0, 0.0);
            }
            case LEFT: {
                return new Insets(0.0, 0.0, 0.0, arrowHeight);
            }
            case TOP: {
                return new Insets(arrowHeight, 0.0, 0.0, 0.0);
            }
            case BOTTOM: {
                return new Insets(0.0, 0.0, arrowHeight, 0.0);
            }
        }
        return new Insets(0.0);
    }

    @Override
    public Point2D getOriginPoint() {
        double width = this.getWidth();
        double height = this.getHeight();
        double arrowPosition = this.getArrowPosition();
        switch (this.getArrowSide()) {
            case RIGHT: {
                return new Point2D(width, height * arrowPosition);
            }
            case LEFT: {
                return new Point2D(0.0, height * arrowPosition);
            }
            case TOP: {
                return new Point2D(width * arrowPosition, 0.0);
            }
            case BOTTOM: {
                return new Point2D(width * arrowPosition, height);
            }
        }
        return null;
    }

    public void createPath() {
        this.getElements().clear();
        this.setStrokeType(StrokeType.INSIDE);
        switch (this.getArrowSide()) {
            case RIGHT: {
                MoveTo startPoint = new MoveTo();
                startPoint.xProperty().bind((ObservableValue)this.roundedRadiusProperty());
                startPoint.setY(0.0);
                HLineTo topLine = new HLineTo();
                topLine.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()).subtract((ObservableNumberValue)this.arrowHeightProperty()));
                ArcTo trArc = new ArcTo();
                trArc.setSweepFlag(true);
                trArc.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.arrowHeightProperty()));
                trArc.yProperty().bind((ObservableValue)this.roundedRadiusProperty());
                trArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                trArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                VLineTo rightLineTop = new VLineTo();
                rightLineTop.yProperty().bind((ObservableValue)this.heightProperty().multiply((ObservableNumberValue)this.arrowBasePositionProperty()).subtract((ObservableNumberValue)this.arrowWidthProperty().divide(2)));
                LineTo arrowTop = new LineTo();
                arrowTop.xProperty().bind((ObservableValue)this.widthProperty());
                arrowTop.yProperty().bind((ObservableValue)this.heightProperty().multiply((ObservableNumberValue)this.arrowPositionProperty()));
                LineTo arrowBottom = new LineTo();
                arrowBottom.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.arrowHeightProperty()));
                arrowBottom.yProperty().bind((ObservableValue)this.heightProperty().multiply((ObservableNumberValue)this.arrowBasePositionProperty()).add((ObservableNumberValue)this.arrowWidthProperty().divide(2)));
                VLineTo rightLineBottom = new VLineTo();
                rightLineBottom.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                ArcTo brArc = new ArcTo();
                brArc.setSweepFlag(true);
                brArc.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.arrowHeightProperty()).subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                brArc.yProperty().bind((ObservableValue)this.heightProperty());
                brArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                brArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                HLineTo bottomLine = new HLineTo();
                bottomLine.xProperty().bind((ObservableValue)this.roundedRadiusProperty());
                ArcTo blArc = new ArcTo();
                blArc.setSweepFlag(true);
                blArc.setX(0.0);
                blArc.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                blArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                blArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                VLineTo leftLine = new VLineTo();
                leftLine.yProperty().bind((ObservableValue)this.roundedRadiusProperty());
                ArcTo tlArc = new ArcTo();
                tlArc.setSweepFlag(true);
                tlArc.xProperty().bind((ObservableValue)startPoint.xProperty());
                tlArc.yProperty().bind((ObservableValue)startPoint.yProperty());
                tlArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                tlArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                this.getElements().addAll((Object[])new PathElement[]{startPoint, topLine, trArc, rightLineTop, arrowTop, arrowBottom, rightLineBottom, brArc, bottomLine, blArc, leftLine, tlArc});
                break;
            }
            case BOTTOM: {
                MoveTo startPoint = new MoveTo();
                startPoint.xProperty().bind((ObservableValue)this.roundedRadiusProperty());
                startPoint.setY(0.0);
                HLineTo topLine = new HLineTo();
                topLine.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                ArcTo trArc = new ArcTo();
                trArc.setSweepFlag(true);
                trArc.xProperty().bind((ObservableValue)this.widthProperty());
                trArc.yProperty().bind((ObservableValue)this.roundedRadiusProperty());
                trArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                trArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                VLineTo rightLine = new VLineTo();
                rightLine.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.arrowHeightProperty()).subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                ArcTo brArc = new ArcTo();
                brArc.setSweepFlag(true);
                brArc.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                brArc.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.arrowHeightProperty()));
                brArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                brArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                HLineTo bottomLineRight = new HLineTo();
                bottomLineRight.xProperty().bind((ObservableValue)this.widthProperty().multiply((ObservableNumberValue)this.arrowBasePositionProperty()).add((ObservableNumberValue)this.arrowWidthProperty().divide(2)));
                LineTo arrowRight = new LineTo();
                arrowRight.xProperty().bind((ObservableValue)this.widthProperty().multiply((ObservableNumberValue)this.arrowPositionProperty()));
                arrowRight.yProperty().bind((ObservableValue)this.heightProperty());
                LineTo arrowLeft = new LineTo();
                arrowLeft.xProperty().bind((ObservableValue)this.widthProperty().multiply((ObservableNumberValue)this.arrowBasePositionProperty()).subtract((ObservableNumberValue)this.arrowWidthProperty().divide(2)));
                arrowLeft.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.arrowHeightProperty()));
                HLineTo bottomLineLeft = new HLineTo();
                bottomLineLeft.xProperty().bind((ObservableValue)this.roundedRadiusProperty());
                ArcTo blArc = new ArcTo();
                blArc.setSweepFlag(true);
                blArc.setX(0.0);
                blArc.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.arrowHeightProperty()).subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                blArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                blArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                VLineTo leftLine = new VLineTo();
                leftLine.yProperty().bind((ObservableValue)this.roundedRadiusProperty());
                ArcTo tlArc = new ArcTo();
                tlArc.setSweepFlag(true);
                tlArc.xProperty().bind((ObservableValue)startPoint.xProperty());
                tlArc.yProperty().bind((ObservableValue)startPoint.yProperty());
                tlArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                tlArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                this.getElements().addAll((Object[])new PathElement[]{startPoint, topLine, trArc, rightLine, brArc, bottomLineRight, arrowRight, arrowLeft, bottomLineLeft, blArc, leftLine, tlArc});
                break;
            }
            case LEFT: {
                MoveTo startPoint = new MoveTo();
                startPoint.xProperty().bind((ObservableValue)this.roundedRadiusProperty().add((ObservableNumberValue)this.arrowHeightProperty()));
                startPoint.setY(0.0);
                HLineTo topLine = new HLineTo();
                topLine.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                ArcTo trArc = new ArcTo();
                trArc.setSweepFlag(true);
                trArc.xProperty().bind((ObservableValue)this.widthProperty());
                trArc.yProperty().bind((ObservableValue)this.roundedRadiusProperty());
                trArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                trArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                VLineTo rightLine = new VLineTo();
                rightLine.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                ArcTo brArc = new ArcTo();
                brArc.setSweepFlag(true);
                brArc.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                brArc.yProperty().bind((ObservableValue)this.heightProperty());
                brArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                brArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                HLineTo bottomLine = new HLineTo();
                bottomLine.xProperty().bind((ObservableValue)this.roundedRadiusProperty().add((ObservableNumberValue)this.arrowHeightProperty()));
                ArcTo blArc = new ArcTo();
                blArc.setSweepFlag(true);
                blArc.xProperty().bind((ObservableValue)this.arrowHeightProperty());
                blArc.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                blArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                blArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                VLineTo leftLineBottom = new VLineTo();
                leftLineBottom.yProperty().bind((ObservableValue)this.heightProperty().multiply((ObservableNumberValue)this.arrowBasePositionProperty()).add((ObservableNumberValue)this.arrowWidthProperty().divide(2)));
                LineTo arrowBottom = new LineTo();
                arrowBottom.setX(0.0);
                arrowBottom.yProperty().bind((ObservableValue)this.heightProperty().multiply((ObservableNumberValue)this.arrowPositionProperty()));
                LineTo arrowTop = new LineTo();
                arrowTop.xProperty().bind((ObservableValue)this.arrowHeightProperty());
                arrowTop.yProperty().bind((ObservableValue)this.heightProperty().multiply((ObservableNumberValue)this.arrowBasePositionProperty()).subtract((ObservableNumberValue)this.arrowWidthProperty().divide(2)));
                VLineTo leftLineTop = new VLineTo();
                leftLineTop.yProperty().bind((ObservableValue)this.roundedRadiusProperty());
                ArcTo tlArc = new ArcTo();
                tlArc.setSweepFlag(true);
                tlArc.xProperty().bind((ObservableValue)startPoint.xProperty());
                tlArc.yProperty().bind((ObservableValue)startPoint.yProperty());
                tlArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                tlArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                this.getElements().addAll((Object[])new PathElement[]{startPoint, topLine, trArc, rightLine, brArc, bottomLine, blArc, leftLineBottom, arrowBottom, arrowTop, leftLineTop, tlArc});
                break;
            }
            case TOP: {
                MoveTo startPoint = new MoveTo();
                startPoint.xProperty().bind((ObservableValue)this.roundedRadiusProperty());
                startPoint.yProperty().bind((ObservableValue)this.arrowHeightProperty());
                HLineTo topLineLeft = new HLineTo();
                topLineLeft.xProperty().bind((ObservableValue)this.widthProperty().multiply((ObservableNumberValue)this.arrowBasePositionProperty()).subtract((ObservableNumberValue)this.arrowWidthProperty().divide(2)));
                LineTo arrowLeft = new LineTo();
                arrowLeft.xProperty().bind((ObservableValue)this.widthProperty().multiply((ObservableNumberValue)this.arrowPositionProperty()));
                arrowLeft.setY(0.0);
                LineTo arrowRight = new LineTo();
                arrowRight.xProperty().bind((ObservableValue)this.widthProperty().multiply((ObservableNumberValue)this.arrowBasePositionProperty()).add((ObservableNumberValue)this.arrowWidthProperty().divide(2)));
                arrowRight.yProperty().bind((ObservableValue)this.arrowHeightProperty());
                HLineTo topLineRight = new HLineTo();
                topLineRight.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                ArcTo trArc = new ArcTo();
                trArc.setSweepFlag(true);
                trArc.xProperty().bind((ObservableValue)this.widthProperty());
                trArc.yProperty().bind((ObservableValue)this.roundedRadiusProperty().add((ObservableNumberValue)this.arrowHeightProperty()));
                trArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                trArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                VLineTo rightLine = new VLineTo();
                rightLine.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                ArcTo brArc = new ArcTo();
                brArc.setSweepFlag(true);
                brArc.xProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                brArc.yProperty().bind((ObservableValue)this.heightProperty());
                brArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                brArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                HLineTo bottomLine = new HLineTo();
                bottomLine.xProperty().bind((ObservableValue)this.roundedRadiusProperty());
                ArcTo blArc = new ArcTo();
                blArc.setSweepFlag(true);
                blArc.setX(0.0);
                blArc.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.roundedRadiusProperty()));
                blArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                blArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                VLineTo leftLine = new VLineTo();
                leftLine.yProperty().bind((ObservableValue)this.arrowHeightProperty().add((ObservableNumberValue)this.roundedRadiusProperty()));
                ArcTo tlArc = new ArcTo();
                tlArc.setSweepFlag(true);
                tlArc.xProperty().bind((ObservableValue)startPoint.xProperty());
                tlArc.yProperty().bind((ObservableValue)startPoint.yProperty());
                tlArc.radiusXProperty().bind((ObservableValue)this.roundedRadiusProperty());
                tlArc.radiusYProperty().bind((ObservableValue)this.roundedRadiusProperty());
                this.getElements().addAll((Object[])new PathElement[]{startPoint, topLineLeft, arrowLeft, arrowRight, topLineRight, trArc, rightLine, brArc, bottomLine, blArc, leftLine, tlArc});
                break;
            }
        }
    }
}

