/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.hints;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.control.TextInputControl;
import jidefx.scene.control.hints.AbstractListIntelliHints;

public class ListDataIntelliHints<T>
extends AbstractListIntelliHints<T> {
    private boolean _caseSensitive = false;
    private List<T> _completionList;

    public ListDataIntelliHints(TextInputControl comp, List<T> completionList) {
        super(comp);
        this.setCompletionList(completionList);
    }

    public ListDataIntelliHints(TextInputControl comp, T[] completionList) {
        super(comp);
        this.setCompletionList(completionList);
    }

    public List<T> getCompletionList() {
        return this._completionList;
    }

    public void setCompletionList(List<T> completionList) {
        this._completionList = completionList;
    }

    public void setCompletionList(T[] completionList) {
        final Object[] list = completionList;
        this._completionList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list[index];
            }

            @Override
            public int size() {
                return list.length;
            }
        };
    }

    @Override
    public boolean updateHints(Object context) {
        if (context == null) {
            return false;
        }
        ArrayList<T> possibleHints = new ArrayList<T>();
        for (T o : this.getCompletionList()) {
            if (!this.compare(context, o)) continue;
            possibleHints.add(o);
        }
        this.setAvailableHints(FXCollections.observableArrayList(possibleHints));
        return possibleHints.size() > 0;
    }

    protected boolean compare(Object context, T o) {
        boolean match = false;
        String listEntry = o == null ? "" : o.toString();
        String s = context.toString();
        int substringLen = s.length();
        if (substringLen <= listEntry.length()) {
            if (!this.isCaseSensitive()) {
                if (s.equalsIgnoreCase(listEntry.substring(0, substringLen))) {
                    match = true;
                }
            } else if (listEntry.startsWith(s)) {
                match = true;
            }
        }
        return match;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }
}

