/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.richtext.actions;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class CkeditorUpload
extends ActionSupport {
    private static final long serialVersionUID = 8163586984026522679L;
    private String uploadContentType;
    private String uploadFileName;
    private String uploadFolder = "/uploads";
    private String CKEditorFuncNum;
    private String CKEditor;
    private String langCode;
    private File upload;
    private boolean allowUploads = false;
    private String allowedFileExtensions = "";
    private static final Logger log = LogManager.getLogger(CkeditorUpload.class);

    public String execute() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Upload is allowed: {}", (Object)this.allowUploads);
            log.debug("Allowed File Extensions: {}", (Object)this.allowedFileExtensions);
            log.debug("Upload Folder : {}", (Object)this.uploadFolder);
        }
        if (!this.allowUploads) {
            this.addActionError(this.getText("struts.ckeditor.error.notallowed", "Uploads are not allowed!"));
            return "error";
        }
        String strPath = ServletActionContext.getServletContext().getRealPath(this.uploadFolder);
        File path = new File(strPath);
        if (!path.exists()) {
            path.mkdirs();
        }
        String uuid = UUID.randomUUID().toString();
        String[] rt = this.uploadFileName.split("\\.");
        String uploadFileExtension = "";
        if (rt.length >= 2) {
            uploadFileExtension = rt[rt.length - 1];
            this.uploadFileName = uuid + "." + uploadFileExtension;
        }
        boolean isAllowed = ArrayUtils.contains((Object[])this.allowedFileExtensions.split(","), (Object)uploadFileExtension.toLowerCase());
        if (log.isDebugEnabled()) {
            log.debug("Upload Content Type: {}", (Object)this.uploadContentType);
            log.debug("Upload File Name: {}", (Object)this.uploadFileName);
            log.debug("Upload File Extension: {}", (Object)uploadFileExtension);
            log.debug("File Extension is allowed: {}", (Object)isAllowed);
        }
        if (!isAllowed) {
            this.addActionError(this.getText("struts.ckeditor.error.invalid.extension", "Invalid File Extension!"));
            return "error";
        }
        try (FileInputStream is = new FileInputStream(this.upload);
             FileOutputStream os = new FileOutputStream(new File(strPath + File.separator + this.uploadFileName));){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            this.addActionError(this.getText("struts.ckeditor.error.general", "Error occurred! " + e.getLocalizedMessage()));
            return "error";
        }
        PrintWriter out = ServletActionContext.getResponse().getWriter();
        out.write("<script type=\"text/javascript\">window.parent.CKEDITOR.tools.callFunction(" + this.CKEditorFuncNum + ", \"" + this.uploadFolder + "/" + this.uploadFileName + "\", \"\");</script>");
        return "none";
    }

    @Inject(value="struts.ckeditor.uploadFolder", required=false)
    public void setUploadFolder(String uploadFolder) {
        this.uploadFolder = uploadFolder;
    }

    @Inject(value="struts.ckeditor.allowedFileExtensions", required=false)
    public void setAllowedFileExtensions(String allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    @Inject(value="struts.ckeditor.allowUploads", required=false)
    public void setAllowUploads(String allowUploads) {
        this.allowUploads = allowUploads.equalsIgnoreCase("true");
    }

    public File getUpload() {
        return this.upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getCKEditorFuncNum() {
        return this.CKEditorFuncNum;
    }

    public void setCKEditorFuncNum(String cKEditorFuncNum) {
        this.CKEditorFuncNum = cKEditorFuncNum;
    }

    public String getCKEditor() {
        return this.CKEditor;
    }

    public void setCKEditor(String cKEditor) {
        this.CKEditor = cKEditor;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    public String getUploadContentType() {
        return this.uploadContentType;
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }
}

