/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.TimeUnit;
import com.jerolba.carpet.impl.write.DecimalConfig;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class SchemaBuilder {
    SchemaBuilder() {
    }

    static PrimitiveType buildLocalTimeType(Type.Repetition repetition, String name, TimeUnit timeUnit, boolean isAdjustedToUTC) {
        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType = LogicalTypeAnnotation.timeType((boolean)isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)SchemaBuilder.toParquetTimeUnit(timeUnit));
        PrimitiveType.PrimitiveTypeName typeName = switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.MILLIS -> PrimitiveType.PrimitiveTypeName.INT32;
            case TimeUnit.MICROS, TimeUnit.NANOS -> PrimitiveType.PrimitiveTypeName.INT64;
        };
        return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)typeName, (Type.Repetition)repetition).as((LogicalTypeAnnotation)timeType)).named(name);
    }

    static PrimitiveType buildLocalDateType(Type.Repetition repetition, String name) {
        return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(name);
    }

    static PrimitiveType buildLocalDateTimeType(Type.Repetition repetition, String name, TimeUnit timeUnit) {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStampType = LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)SchemaBuilder.toParquetTimeUnit(timeUnit));
        return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)timeStampType)).named(name);
    }

    static PrimitiveType buildInstantType(Type.Repetition repetition, String name, TimeUnit timeUnit) {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStampType = LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)SchemaBuilder.toParquetTimeUnit(timeUnit));
        return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)timeStampType)).named(name);
    }

    static Type buildDecimalTypeItem(Type.Repetition repetition, String name, DecimalConfig decimalConfig) {
        if (decimalConfig == null || decimalConfig.scale() == null || decimalConfig.precision() == null) {
            throw new RecordTypeConversionException("If BigDecimal is used, a Default Decimal configuration must be provided in the setup of CarpetWriter builder, or BigDecimal fields must be annotated with @PrecisionScale");
        }
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = LogicalTypeAnnotation.decimalType((int)decimalConfig.scale(), (int)decimalConfig.precision());
        if (decimalConfig.precision() <= 9) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalType)).named(name);
        }
        if (decimalConfig.precision() <= 18) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalType)).named(name);
        }
        return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalType)).named(name);
    }

    static Type buildUuidType(Type.Repetition repetition, String name) {
        return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType())).length(16)).named(name);
    }

    static LogicalTypeAnnotation.TimeUnit toParquetTimeUnit(TimeUnit timeUnit) {
        return switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.MILLIS -> LogicalTypeAnnotation.TimeUnit.MILLIS;
            case TimeUnit.MICROS -> LogicalTypeAnnotation.TimeUnit.MICROS;
            case TimeUnit.NANOS -> LogicalTypeAnnotation.TimeUnit.NANOS;
        };
    }
}

